/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.launchers;

import dk.zlepper.itlt.client.launchers.CurseClient;
import dk.zlepper.itlt.client.launchers.DetectedLauncher;
import dk.zlepper.itlt.client.launchers.FTBApp;
import dk.zlepper.itlt.client.launchers.ForgeDevEnv;
import dk.zlepper.itlt.client.launchers.MultiMC;
import dk.zlepper.itlt.client.launchers.Technic;
import dk.zlepper.itlt.client.launchers.Unknown;
import dk.zlepper.itlt.itlt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.userdev.FMLDevClientLaunchProvider;
import net.minecraftforge.userdev.FMLDevServerLaunchProvider;

public class LauncherUtils {
    static Path getItltJarPath() {
        Path itltJarPath = ModList.get().getModFileById("itlt").getFile().getFilePath();
        itlt.LOGGER.debug("itltJarPath: " + itltJarPath);
        return itltJarPath;
    }

    public static DetectedLauncher getDetectedLauncher() {
        Path itltJarPath = LauncherUtils.getItltJarPath();
        Path theoreticalTechnicPath = itltJarPath.getParent().getParent().getParent().getParent();
        boolean isTechnicLauncher = Files.exists(theoreticalTechnicPath.resolve("installedPacks"), new LinkOption[0]) && Files.exists(theoreticalTechnicPath.resolve("modpacks"), new LinkOption[0]);
        itlt.LOGGER.debug("theoreticalTechnicPath: " + theoreticalTechnicPath);
        itlt.LOGGER.debug("isTechnicLauncher: " + isTechnicLauncher);
        if (isTechnicLauncher) {
            return new Technic();
        }
        Path theoreticalMultiMCPath = itltJarPath.getParent().getParent().getParent();
        boolean isMultiMCLauncher = Files.exists(theoreticalMultiMCPath.resolve("mmc-pack.json"), new LinkOption[0]) && Files.exists(theoreticalMultiMCPath.resolve("instance.cfg"), new LinkOption[0]);
        itlt.LOGGER.debug("theoreticalMultiMCPath: " + theoreticalMultiMCPath);
        itlt.LOGGER.debug("isMultiMCLauncher: " + isMultiMCLauncher);
        if (isMultiMCLauncher) {
            return new MultiMC();
        }
        Path theoreticalCurseClientPath = itltJarPath.getParent().getParent();
        boolean isCurseClientLauncher = Files.exists(theoreticalCurseClientPath.resolve(".curseclient"), new LinkOption[0]) && Files.exists(theoreticalCurseClientPath.resolve("minecraftinstance.json"), new LinkOption[0]);
        itlt.LOGGER.debug("theoreticalCurseClientPath: " + theoreticalCurseClientPath);
        itlt.LOGGER.debug("isCurseClientLauncher: " + isCurseClientLauncher);
        if (isCurseClientLauncher) {
            return new CurseClient();
        }
        Path theoreticalFTBAppPath = itltJarPath.getParent().getParent().getParent().getParent();
        boolean isFTBAppLauncher = Files.exists(theoreticalFTBAppPath.resolve("ftbapp.log"), new LinkOption[0]);
        itlt.LOGGER.debug("theoreticalFTBAppPath: " + theoreticalFTBAppPath);
        itlt.LOGGER.debug("isFTBAppLauncher: " + isFTBAppLauncher);
        if (isFTBAppLauncher) {
            return new FTBApp();
        }
        boolean isForgeDevEnv = LauncherUtils.isForgeDevEnv();
        itlt.LOGGER.debug("isForgeDevEnv: " + isForgeDevEnv);
        if (isForgeDevEnv) {
            return new ForgeDevEnv();
        }
        return new Unknown();
    }

    public static boolean isForgeDevEnv() {
        try {
            Class.forName("net.minecraftforge.userdev.FMLDevClientLaunchProvider");
            if (new FMLDevClientLaunchProvider().name().equals("fmldevclient")) {
                return true;
            }
            if (new FMLDevServerLaunchProvider().name().equals("fmldevserver")) {
                return true;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        return false;
    }
}

