/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.helpers;

import dk.zlepper.itlt.client.helpers.Platform;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class IconLoader {
    public static ByteBuffer[] load(String filepath) {
        return IconLoader.load(new File(filepath));
    }

    public static ByteBuffer[] load(File file) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteBuffer[] buffers = Platform.isWindows() ? new ByteBuffer[]{IconLoader.loadInstance(image, 16), IconLoader.loadInstance(image, 32)} : (Platform.isMac() ? new ByteBuffer[]{IconLoader.loadInstance(image, 128)} : new ByteBuffer[]{IconLoader.loadInstance(image, 32)});
        return buffers;
    }

    private static ByteBuffer loadInstance(BufferedImage image, int dimension) {
        BufferedImage scaledIcon = new BufferedImage(dimension, dimension, 3);
        Graphics2D g = scaledIcon.createGraphics();
        double ratio = IconLoader.getIconRatio(image, scaledIcon);
        double width = (double)image.getWidth() * ratio;
        double height = (double)image.getHeight() * ratio;
        g.drawImage(image, (int)(((double)scaledIcon.getWidth() - width) / 2.0), (int)(((double)scaledIcon.getHeight() - height) / 2.0), (int)width, (int)height, null);
        g.dispose();
        return IconLoader.convertToByteBuffer(scaledIcon);
    }

    private static double getIconRatio(BufferedImage src, BufferedImage icon) {
        double ratio = src.getWidth() > icon.getWidth() ? (double)icon.getWidth() / (double)src.getWidth() : (double)(icon.getWidth() / src.getWidth());
        if (src.getHeight() > icon.getHeight()) {
            double r2 = (double)icon.getHeight() / (double)src.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        } else {
            double r2 = icon.getHeight() / src.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        }
        return ratio;
    }

    public static ByteBuffer convertToByteBuffer(BufferedImage image) {
        byte[] buffer = new byte[image.getWidth() * image.getHeight() * 4];
        int counter = 0;
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer[counter] = (byte)(colorSpace << 8 >> 24);
                buffer[counter + 1] = (byte)(colorSpace << 16 >> 24);
                buffer[counter + 2] = (byte)(colorSpace << 24 >> 24);
                buffer[counter + 3] = (byte)(colorSpace >> 24);
                counter += 4;
            }
        }
        return ByteBuffer.wrap(buffer);
    }
}

