/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client.helpers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.client.ClientModEvents;
import dk.zlepper.itlt.client.helpers.Message;
import dk.zlepper.itlt.itlt;
import dk.zlepper.itlt.shadow.org.apache.commons.imaging.ImageReadException;
import dk.zlepper.itlt.shadow.org.apache.commons.imaging.formats.icns.IcnsImageParser;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraftforge.fml.ModList;
import net.sf.image4j.codec.ico.ICODecoder;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;

public class ClientUtils {
    public static byte getJavaVersion() {
        String javaVerStr = System.getProperty("java.version");
        String[] splitJavaVer = javaVerStr.split(Pattern.quote("."));
        byte javaVer = Byte.parseByte(splitJavaVer[0]);
        if (javaVer == 1) {
            javaVer = Byte.parseByte(splitJavaVer[1]);
        }
        return javaVer;
    }

    public static boolean alreadyInServerList(ServerData server, ServerList list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.func_78856_c(); ++i) {
            ServerData serverData = list.func_78850_a(i);
            if (serverData.field_78847_a == null || serverData.field_78845_b == null || !serverData.field_78847_a.equalsIgnoreCase(server.field_78847_a) || !serverData.field_78845_b.equalsIgnoreCase(server.field_78845_b)) continue;
            return true;
        }
        return false;
    }

    public static void setWindowIcon(InputStream inputIconInStream, Minecraft mcInstance, File itltDir, String fileExtension) throws IOException {
        Files.copy(inputIconInStream, Paths.get(itltDir.getAbsolutePath(), "temp." + fileExtension), StandardCopyOption.REPLACE_EXISTING);
        File tmpIconFile = new File(itltDir.getAbsolutePath(), "temp." + fileExtension);
        ClientUtils.setWindowIcon(tmpIconFile, mcInstance);
        if (!tmpIconFile.delete()) {
            tmpIconFile.deleteOnExit();
        }
    }

    public static void setWindowIcon(File inputIconFile, Minecraft mcInstance) throws IOException {
        ArrayList<InputStream> iconsList = new ArrayList<InputStream>();
        List<Object> bufferedImageList = new ArrayList(0);
        String inputIconFilenameAndExt = inputIconFile.getName().toLowerCase();
        if (inputIconFilenameAndExt.endsWith(".ico")) {
            bufferedImageList = ICODecoder.read(inputIconFile);
        } else if (inputIconFilenameAndExt.endsWith(".icns")) {
            try {
                bufferedImageList = new IcnsImageParser().getAllBufferedImages(inputIconFile);
            }
            catch (ImageReadException e) {
                e.printStackTrace();
                return;
            }
        } else if (inputIconFilenameAndExt.endsWith(".png")) {
            iconsList.add(new FileInputStream(inputIconFile));
        }
        itlt.LOGGER.debug("Icon file: \"" + inputIconFilenameAndExt + "\"");
        if (inputIconFilenameAndExt.endsWith(".ico") || inputIconFilenameAndExt.endsWith(".icns")) {
            for (BufferedImage bufferedImage : bufferedImageList) {
                itlt.LOGGER.debug("---");
                itlt.LOGGER.debug("Type: " + bufferedImage.getType());
                itlt.LOGGER.debug("Width: " + bufferedImage.getWidth());
                itlt.LOGGER.debug("Height: " + bufferedImage.getHeight());
                itlt.LOGGER.debug("Transparency: " + bufferedImage.getTransparency());
                if (bufferedImage.getType() == 2) {
                    if (inputIconFilenameAndExt.endsWith(".icns")) {
                        if (bufferedImage.getWidth() <= 48) {
                            iconsList.add(ClientUtils.convertToInputStream(bufferedImage));
                            itlt.LOGGER.debug("Added embedded image");
                            continue;
                        }
                        itlt.LOGGER.debug("Skipped embedded image");
                        continue;
                    }
                    iconsList.add(ClientUtils.convertToInputStream(bufferedImage));
                    itlt.LOGGER.debug("Added embedded image");
                    continue;
                }
                itlt.LOGGER.debug("Skipped embedded image");
            }
        }
        itlt.LOGGER.debug("Final iconsList size: " + iconsList.size());
        GLFWImage.Buffer buffer = ClientUtils.loadIconsIntoBuffer(iconsList, mcInstance);
        GLFW.glfwSetWindowIcon((long)mcInstance.func_228018_at_().field_198119_f, (GLFWImage.Buffer)buffer);
    }

    public static GLFWImage.Buffer loadIconsIntoBuffer(List<InputStream> iconsList, Minecraft mcInstance) throws IOException {
        return ClientUtils.loadIconsIntoBuffer(iconsList, mcInstance, 1);
    }

    public static GLFWImage.Buffer loadIconsIntoBuffer(List<InputStream> iconsList, Minecraft mcInstance, int attempt) throws IOException {
        MemoryStack memoryStack = MemoryStack.stackPush();
        GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)iconsList.size(), (MemoryStack)memoryStack);
        IntBuffer intBufferX = memoryStack.mallocInt(1);
        IntBuffer intBufferY = memoryStack.mallocInt(1);
        IntBuffer intBufferChannels = memoryStack.mallocInt(1);
        int iconCounter = 0;
        int errorCounter = 0;
        ArrayList<InputStream> newIconsList = new ArrayList<InputStream>();
        for (InputStream inStream : iconsList) {
            ByteBuffer byteBuffer;
            try {
                byteBuffer = mcInstance.func_228018_at_().func_198111_a(inStream, intBufferX, intBufferY, intBufferChannels);
                if (byteBuffer == null) {
                    throw new IOException("byteBuffer is null");
                }
            }
            catch (IOException e) {
                itlt.LOGGER.debug("Unable to load image #" + iconCounter + " inside iconsList, skipping...");
                errorCounter = (short)(errorCounter + 1);
                continue;
            }
            buffer.position(iconCounter);
            buffer.width(intBufferX.get(0));
            buffer.height(intBufferY.get(0));
            buffer.pixels(byteBuffer);
            iconCounter = (short)(iconCounter + 1);
            newIconsList.add(inStream);
        }
        if (errorCounter == iconsList.size()) {
            throw new IOException("Unable to load icon(s): Failed to load all embedded images");
        }
        if (errorCounter > 0) {
            if (attempt > 2) {
                throw new IOException("Unable to load icon(s): Too many failed attempts");
            }
            return ClientUtils.loadIconsIntoBuffer(newIconsList, mcInstance, attempt + 1);
        }
        buffer.position(0);
        return buffer;
    }

    public static ByteArrayInputStream convertToInputStream(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        ImageIO.write((RenderedImage)bufferedImage, "png", output);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(output.toByteArray(), 0, output.size());
        bufferedImage.flush();
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startUIProcess(Message.Content messageContent) {
        Type type;
        InputStreamReader embeddedLangJson;
        HashMap translationsMap;
        String guideURL;
        String rightButtonText;
        String middleButtonText;
        Path modFile = ModList.get().getModFileById("itlt").getFile().getFilePath();
        String msgTranslationKeyTemplate = "itlt." + messageContent.msgType.name().toLowerCase() + "." + messageContent.msgDesire.name().toLowerCase() + "." + messageContent.msgSubject.name().toLowerCase();
        String messageTitle = msgTranslationKeyTemplate + ".title";
        String messageBody = msgTranslationKeyTemplate + ".body";
        String messageGuideError = "itlt.cantOpenGuideErrorMsg";
        String leftButtonText = msgTranslationKeyTemplate + ".guideButtonText";
        if (messageContent.msgType == Message.Type.Needs) {
            middleButtonText = msgTranslationKeyTemplate + ".closeButtonText";
            rightButtonText = ".";
        } else {
            middleButtonText = msgTranslationKeyTemplate + ".askLaterButtonText";
            rightButtonText = msgTranslationKeyTemplate + ".dontAskAgainButtonText";
        }
        String defaultGuideURL = "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
        switch (messageContent.msgSubject) {
            case Memory: {
                if (((Boolean)ClientConfig.enableCustomMemoryAllocGuide.get()).booleanValue()) {
                    guideURL = (String)ClientConfig.customMemoryAllocGuideURL.get();
                    break;
                }
                guideURL = "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
                break;
            }
            case Java: {
                if (messageContent.msgDesire == Message.Desire.SixtyFourBit) {
                    if (((Boolean)ClientConfig.enableCustom64bitJavaGuide.get()).booleanValue()) {
                        guideURL = (String)ClientConfig.custom64bitJavaGuideURL.get();
                        break;
                    }
                    guideURL = "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
                    break;
                }
                if (messageContent.msgDesire == Message.Desire.Newer) {
                    if (((Boolean)ClientConfig.enableCustomJavaUpgradeGuide.get()).booleanValue()) {
                        guideURL = (String)ClientConfig.customJavaUpgradeGuideURL.get();
                        break;
                    }
                    guideURL = "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
                    break;
                }
                if (((Boolean)ClientConfig.enableCustomJavaDowngradeGuide.get()).booleanValue()) {
                    guideURL = (String)ClientConfig.customJavaDowngradeGuideURL.get();
                    break;
                }
                guideURL = "https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject";
                break;
            }
            default: {
                guideURL = "N/A";
            }
        }
        guideURL = guideURL.replaceAll("%launcher", ClientModEvents.detectedLauncher.getName()).replaceAll("%reason", messageContent.toString()).replaceAll("%type", messageContent.msgType.toString()).replaceAll("%desire", messageContent.msgDesire.toString()).replaceAll("%subject", messageContent.msgSubject.toString());
        String lang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        InputStream embeddedLangJsonInStream = itlt.class.getClassLoader().getResourceAsStream("assets/itlt/lang/" + lang + ".json");
        if (embeddedLangJsonInStream == null) {
            embeddedLangJsonInStream = itlt.class.getClassLoader().getResourceAsStream("assets/itlt/lang/en_us.json");
        }
        if ((translationsMap = (HashMap)new Gson().fromJson((Reader)(embeddedLangJson = new InputStreamReader(embeddedLangJsonInStream, StandardCharsets.UTF_8)), type = new TypeToken<HashMap<String, String>>(){}.getType())) != null) {
            messageTitle = translationsMap.getOrDefault(messageTitle, messageTitle);
            messageBody = translationsMap.getOrDefault(messageBody, messageBody);
            leftButtonText = translationsMap.getOrDefault(leftButtonText, leftButtonText);
            middleButtonText = translationsMap.getOrDefault(middleButtonText, middleButtonText);
            rightButtonText = translationsMap.getOrDefault(rightButtonText, rightButtonText);
            messageGuideError = translationsMap.getOrDefault(messageGuideError, messageGuideError);
            if (messageContent.msgSubject == Message.Subject.Memory) {
                messageBody = messageBody.replaceFirst("%sb", ClientConfig.getSimplifiedFloatStr(ClientModEvents.currentMem));
            } else if (messageContent.msgSubject == Message.Subject.Java) {
                messageBody = messageBody.replaceFirst("%sb", String.valueOf(ClientUtils.getJavaVersion()));
            }
            switch (messageContent) {
                case NeedsMoreMemory: {
                    messageBody = messageBody.replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.reqMinMemoryAmountInGB.get()).floatValue()));
                    break;
                }
                case WantsMoreMemory: {
                    messageBody = messageBody.replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.warnMinMemoryAmountInGB.get()).floatValue()));
                    break;
                }
                case NeedsLessMemory: {
                    messageBody = messageBody.replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.reqMaxMemoryAmountInGB.get()).floatValue()));
                    break;
                }
                case WantsLessMemory: {
                    messageBody = messageBody.replaceFirst("%s", ClientConfig.getSimplifiedFloatStr(((Double)ClientConfig.warnMaxMemoryAmountInGB.get()).floatValue()));
                    break;
                }
                case NeedsNewerJava: {
                    messageTitle = messageTitle.replaceFirst("%s", ((Integer)ClientConfig.requiredMinJavaVersion.get()).toString());
                    messageBody = messageBody.replaceFirst("%s", ((Integer)ClientConfig.requiredMinJavaVersion.get()).toString());
                    break;
                }
                case WantsNewerJava: {
                    messageTitle = messageTitle.replaceFirst("%s", ((Integer)ClientConfig.warnMinJavaVersion.get()).toString());
                    messageBody = messageBody.replaceFirst("%s", ((Integer)ClientConfig.warnMinJavaVersion.get()).toString());
                    break;
                }
                case NeedsOlderJava: {
                    messageTitle = messageTitle.replaceFirst("%s", ((Integer)ClientConfig.requiredMaxJavaVersion.get()).toString());
                    messageBody = messageBody.replaceFirst("%s", ((Integer)ClientConfig.requiredMaxJavaVersion.get()).toString());
                    break;
                }
                case WantsOlderJava: {
                    messageTitle = messageTitle.replaceFirst("%s", ((Integer)ClientConfig.warnMaxJavaVersion.get()).toString());
                    messageBody = messageBody.replaceFirst("%s", ((Integer)ClientConfig.warnMaxJavaVersion.get()).toString());
                    break;
                }
            }
        }
        messageGuideError = messageGuideError.replaceFirst("%s", guideURL);
        itlt.LOGGER.info("messageContent: " + messageContent.toString());
        itlt.LOGGER.debug("messageType: " + messageContent.msgType.toString());
        itlt.LOGGER.info("messageTitle: " + messageTitle);
        itlt.LOGGER.info("messageBody: " + messageBody);
        itlt.LOGGER.info("guideURL: " + guideURL);
        itlt.LOGGER.debug("messageGuideError: " + messageGuideError);
        itlt.LOGGER.debug("left: " + leftButtonText);
        itlt.LOGGER.debug("middle: " + middleButtonText);
        itlt.LOGGER.debug("right: " + rightButtonText);
        try {
            ProcessBuilder builder = new ProcessBuilder(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java", "-Dapple.awt.application.appearance=system", "-jar", modFile.toString(), messageContent.msgType.toString().toLowerCase(), messageTitle, messageBody, leftButtonText, middleButtonText, rightButtonText, messageGuideError, guideURL, messageContent.toString());
            builder.inheritIO();
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (messageContent.msgType == Message.Type.Needs) {
                itlt.LOGGER.fatal("Can't launch the game as a requirement isn't met. ");
                itlt.LOGGER.fatal("The unmet requirement is: \"" + (Object)((Object)messageContent) + "\".");
                if (messageBody.isEmpty()) {
                    itlt.LOGGER.error("The requirement details are blank, please report this bug on itlt's GitHub issues");
                } else {
                    itlt.LOGGER.error("Requirement details: " + messageBody);
                }
                System.exit(1);
            }
        }
    }

    public static String readString(Path path) throws IOException {
        if (ClientUtils.getJavaVersion() >= 11) {
            return Files.readString(path);
        }
        return new String(Files.readAllBytes(path));
    }

    public static class CustomServerData {
        public String name;
        public String address;
        public boolean forceResourcePack;
    }
}

