/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client;

import com.google.gson.Gson;
import dk.zlepper.itlt.client.ClientConfig;
import dk.zlepper.itlt.client.helpers.ClientUtils;
import dk.zlepper.itlt.client.helpers.Message;
import dk.zlepper.itlt.client.launchers.DetectedLauncher;
import dk.zlepper.itlt.client.launchers.LauncherUtils;
import dk.zlepper.itlt.itlt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="itlt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    public static float currentMem = ClientModEvents.getCurrentMem();
    public static File itltDir = null;
    public static DetectedLauncher detectedLauncher = LauncherUtils.getDetectedLauncher();

    private static float getCurrentMem() {
        long currentMem = Runtime.getRuntime().maxMemory() + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getMax();
        return Float.parseFloat(String.format((Locale)null, "%.1f", Float.valueOf((float)currentMem / 1.0737418E9f)));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void commonInit(FMLCommonSetupEvent event) {
        itltDir = ClientConfig.makeItltFolderIfNeeded();
        byte javaVerInt = ClientUtils.getJavaVersion();
        itlt.LOGGER.debug("javaVerInt: " + javaVerInt);
        itlt.LOGGER.info("detectedLauncher: " + detectedLauncher.getName());
        itlt.LOGGER.debug("requiredMinJavaVerion: " + ClientConfig.requiredMinJavaVersion.get());
        itlt.LOGGER.debug("warnMinJavaVersion: " + ClientConfig.warnMinJavaVersion.get());
        if (((Boolean)ClientConfig.enableMinJavaVerRequirement.get()).booleanValue() && javaVerInt < (Integer)ClientConfig.requiredMinJavaVersion.get()) {
            ClientUtils.startUIProcess(Message.Content.NeedsNewerJava);
        } else if (((Boolean)ClientConfig.enableMinJavaVerWarning.get()).booleanValue() && javaVerInt < (Integer)ClientConfig.warnMinJavaVersion.get()) {
            if (((Boolean)ClientConfig.selectivelyIgnoreMinJavaVerWarning.get()).booleanValue()) {
                if (!detectedLauncher.supportsChangingJavaVersion()) {
                    itlt.LOGGER.info("Skipping minJavaVerWarning as you appear to be using the " + detectedLauncher.getName() + " launcher which currently does not allow changing Java version beyond Java 8. :(");
                    itlt.LOGGER.info("If you are seeing this and your launcher does allow it, update itlt.");
                    itlt.LOGGER.info("If already up-to-date, let us know by filing an issue on itlt's Github issues");
                } else {
                    ClientUtils.startUIProcess(Message.Content.WantsNewerJava);
                }
            } else {
                ClientUtils.startUIProcess(Message.Content.WantsNewerJava);
            }
        }
        itlt.LOGGER.debug("requiredMaxJavaVerion: " + ClientConfig.requiredMaxJavaVersion.get());
        itlt.LOGGER.debug("warnMaxJavaVersion: " + ClientConfig.warnMaxJavaVersion.get());
        if (((Boolean)ClientConfig.enableMaxJavaVerRequirement.get()).booleanValue() && javaVerInt > (Integer)ClientConfig.requiredMaxJavaVersion.get()) {
            ClientUtils.startUIProcess(Message.Content.NeedsOlderJava);
        } else if (((Boolean)ClientConfig.enableMaxJavaVerWarning.get()).booleanValue() && javaVerInt > (Integer)ClientConfig.warnMaxJavaVersion.get()) {
            if (((Boolean)ClientConfig.selectivelyIgnoreMaxJavaVerWarning.get()).booleanValue()) {
                if (!detectedLauncher.supportsChangingJavaVersion()) {
                    itlt.LOGGER.info("Skipping maxJavaVerWarning as you appear to be using the " + detectedLauncher.getName() + " launcher which currently does not allow changing Java version beyond Java 8. :(");
                    itlt.LOGGER.info("If you are seeing this and your launcher does allow it, update itlt.");
                    itlt.LOGGER.info("If already up-to-date, let us know by filing an issue on itlt's Github issues");
                } else {
                    ClientUtils.startUIProcess(Message.Content.WantsOlderJava);
                }
            } else {
                ClientUtils.startUIProcess(Message.Content.WantsOlderJava);
            }
        }
        itlt.LOGGER.debug("currentMem: " + currentMem);
        itlt.LOGGER.debug("reqMinMemoryAmountInGB: " + ClientConfig.reqMinMemoryAmountInGB.get());
        itlt.LOGGER.debug("warnMinMemoryAmountInGB: " + ClientConfig.warnMinMemoryAmountInGB.get());
        itlt.LOGGER.debug("reqMaxMemoryAmountInGB: " + ClientConfig.reqMaxMemoryAmountInGB.get());
        itlt.LOGGER.debug("warnMaxMemoryAmountInGB: " + ClientConfig.warnMaxMemoryAmountInGB.get());
        if (((Boolean)ClientConfig.enableMinMemoryRequirement.get()).booleanValue() && currentMem < ((Double)ClientConfig.reqMinMemoryAmountInGB.get()).floatValue()) {
            ClientUtils.startUIProcess(Message.Content.NeedsMoreMemory);
        } else if (((Boolean)ClientConfig.enableMinMemoryWarning.get()).booleanValue() && currentMem < ((Double)ClientConfig.warnMinMemoryAmountInGB.get()).floatValue()) {
            ClientUtils.startUIProcess(Message.Content.WantsMoreMemory);
        }
        if (((Boolean)ClientConfig.enableMaxMemoryRequirement.get()).booleanValue() && currentMem > ((Double)ClientConfig.reqMaxMemoryAmountInGB.get()).floatValue()) {
            ClientUtils.startUIProcess(Message.Content.NeedsLessMemory);
        } else if (((Boolean)ClientConfig.enableMaxMemoryWarning.get()).booleanValue() && currentMem > ((Double)ClientConfig.warnMaxMemoryAmountInGB.get()).floatValue()) {
            ClientUtils.startUIProcess(Message.Content.WantsLessMemory);
        }
    }

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        Minecraft mcInstance = (Minecraft)event.getMinecraftSupplier().get();
        boolean isJava64bit = mcInstance.func_147111_S();
        itlt.LOGGER.debug("isJava64bit: " + isJava64bit);
        if (!isJava64bit) {
            if (((Boolean)ClientConfig.enable64bitRequirement.get()).booleanValue()) {
                ClientUtils.startUIProcess(Message.Content.NeedsJava64bit);
            } else if (((Boolean)ClientConfig.enable64bitWarning.get()).booleanValue()) {
                ClientUtils.startUIProcess(Message.Content.WantsJava64bit);
            }
        }
        if (((Boolean)ClientConfig.enableCustomWindowTitle.get()).booleanValue()) {
            String customWindowTitle = (String)ClientConfig.customWindowTitleText.get();
            String autoDetectedDisplayName = (String)ClientConfig.autoDetectedDisplayNameFallback.get();
            if (((Boolean)ClientConfig.enableUsingAutodetectedDisplayName.get()).booleanValue() && customWindowTitle.contains("%autoName")) {
                try {
                    String tmp = detectedLauncher.getModpackDisplayName();
                    if (tmp != null) {
                        autoDetectedDisplayName = tmp;
                    }
                }
                catch (IOException e) {
                    itlt.LOGGER.warn("Unable to auto-detect modpack display name, falling back to autoDetectedDisplayNameFallback in the config.");
                    e.printStackTrace();
                }
            }
            customWindowTitle = customWindowTitle.replaceFirst("%autoName", autoDetectedDisplayName);
            customWindowTitle = customWindowTitle.replaceFirst("%mc", mcInstance.func_230149_ax_());
            itlt.LOGGER.info("customWindowTitle: " + customWindowTitle);
            if (!customWindowTitle.isEmpty()) {
                mcInstance.func_228018_at_().func_230148_b_(customWindowTitle);
            }
        }
        boolean isCustomIconSet = false;
        if (((Boolean)ClientConfig.enableCustomIcon.get()).booleanValue()) {
            File autoDetectedIcon;
            File customIcon = null;
            if (((Boolean)ClientConfig.enableUsingAutodetectedIcon.get()).booleanValue() && (autoDetectedIcon = detectedLauncher.getModpackIcon()) != null && autoDetectedIcon.exists() && !autoDetectedIcon.isDirectory()) {
                customIcon = autoDetectedIcon;
            }
            if (itltDir != null) {
                File icoIcon = Paths.get(itltDir.getAbsolutePath(), "icon.ico").toFile();
                File icnsIcon = Paths.get(itltDir.getAbsolutePath(), "icon.icns").toFile();
                File pngIcon = Paths.get(itltDir.getAbsolutePath(), "icon.png").toFile();
                if (icoIcon.exists() && !icoIcon.isDirectory()) {
                    customIcon = icoIcon;
                } else if (icnsIcon.exists() && !icnsIcon.isDirectory()) {
                    customIcon = icnsIcon;
                } else if (pngIcon.exists() && !pngIcon.isDirectory()) {
                    customIcon = pngIcon;
                }
            }
            if (customIcon != null) {
                try {
                    ClientUtils.setWindowIcon(customIcon, mcInstance);
                    isCustomIconSet = true;
                }
                catch (IOException e) {
                    itlt.LOGGER.error("Unable to set the window icon.");
                    e.printStackTrace();
                }
            } else {
                itlt.LOGGER.warn("enableCustomIcon is true but icon.ico/icns/png is missing or invalid.");
            }
        }
        if (((Boolean)ClientConfig.enableEnhancedVanillaIcon.get()).booleanValue() && !isCustomIconSet) {
            try {
                InputStream enhancedIcon = mcInstance.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/minecraft.icns"));
                ClientUtils.setWindowIcon(enhancedIcon, mcInstance, itltDir, "icns");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (((Boolean)ClientConfig.enableCustomServerListEntries.get()).booleanValue()) {
            File itltDir = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "itlt").toFile();
            if (!itltDir.exists()) {
                itlt.LOGGER.warn("itlt folder in the config folder is missing.");
                if (itltDir.mkdir()) {
                    itlt.LOGGER.info("The folder has been successfully created for you.");
                } else {
                    itlt.LOGGER.warn("Please create a folder named \"itlt\" (case sensitive) in the config folder.");
                }
                return;
            }
            Path customServersJsonPath = Paths.get(itltDir.getAbsolutePath(), "servers.json");
            File customServersJsonFile = customServersJsonPath.toFile();
            if (!customServersJsonFile.exists() || customServersJsonFile.isDirectory()) {
                itlt.LOGGER.warn("enableCustomServerListEntries is true but servers.json is missing or invalid.");
                return;
            }
            try {
                String customServersJson = ClientUtils.readString(customServersJsonPath);
                ClientUtils.CustomServerData[] featuredList = (ClientUtils.CustomServerData[])new Gson().fromJson(customServersJson, ClientUtils.CustomServerData[].class);
                if (featuredList != null) {
                    ServerList serverList = new ServerList(mcInstance);
                    for (ClientUtils.CustomServerData customServerEntry : featuredList) {
                        ServerData serverToAdd = new ServerData(customServerEntry.name, customServerEntry.address, false);
                        if (customServerEntry.forceResourcePack) {
                            serverToAdd.func_152584_a(ServerData.ServerResourceMode.ENABLED);
                        }
                        if (ClientUtils.alreadyInServerList(serverToAdd, serverList)) continue;
                        itlt.LOGGER.info("Adding custom server entry");
                        serverList.func_78849_a(serverToAdd);
                        serverList.func_78855_b();
                    }
                }
            }
            catch (IOException e) {
                itlt.LOGGER.error("Unable to read the contents of " + customServersJsonPath);
                e.printStackTrace();
            }
        }
    }
}

