/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.forge.tileentity;

import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import hardcorequesting.common.forge.tileentity.AbstractBarrelBlockEntity;
import hardcorequesting.forge.ForgeFluidStack;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockEntity
extends AbstractBarrelBlockEntity {
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            QuestTask task = BarrelBlockEntity.this.getCurrentTask();
            if (task instanceof ConsumeItemTask) {
                ConsumeItemTask consumeTask = (ConsumeItemTask)task;
                UUID playerUUID = BarrelBlockEntity.this.getPlayerUUID();
                return consumeTask.canTakeFluid(stack.getFluid(), playerUUID);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            QuestTask task = BarrelBlockEntity.this.getCurrentTask();
            if (task instanceof ConsumeItemTask) {
                UUID playerUUID = BarrelBlockEntity.this.getPlayerUUID();
                FluidStack duplicate = resource.copy();
                if (((ConsumeItemTask)task).increaseFluid(new ForgeFluidStack(duplicate), playerUUID, action.execute()) && action.execute()) {
                    BarrelBlockEntity.this.updateState();
                    BarrelBlockEntity.this.doSync();
                }
                return resource.getAmount() - duplicate.getAmount();
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    });

    @Override
    public void syncToClientsNearby() {
        if (!this.func_145831_w().func_201670_d()) {
            ServerWorld world = (ServerWorld)this.func_145831_w();
            world.func_72863_F().func_217217_a(this.func_174877_v());
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 10, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

