/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.forge;

import com.google.common.collect.Maps;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.platform.NetworkManager;
import hardcorequesting.forge.ClientNetworkingManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkingManager
implements NetworkManager {
    private static final ResourceLocation CHANNEL_ID = new ResourceLocation("hardcorequesting", "network");
    private static final ResourceLocation SYNC_IDS = new ResourceLocation("hardcorequesting", "sync_ids");
    static final EventNetworkChannel CHANNEL = NetworkRegistry.newEventChannel((ResourceLocation)CHANNEL_ID, () -> "1", version -> true, version -> true);
    static final Map<ResourceLocation, BiConsumer<PacketContext, PacketBuffer>> S2C = Maps.newHashMap();
    static final Map<ResourceLocation, BiConsumer<PacketContext, PacketBuffer>> C2S = Maps.newHashMap();

    public static void init() {
        CHANNEL.addListener(NetworkingManager.createPacketHandler(NetworkEvent.ClientCustomPayloadEvent.class, C2S));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::initClient);
    }

    static <T extends NetworkEvent> Consumer<T> createPacketHandler(Class<T> clazz, Map<ResourceLocation, BiConsumer<PacketContext, PacketBuffer>> map) {
        return event -> {
            if (event.getClass() != clazz) {
                return;
            }
            final NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            if (context.getPacketHandled()) {
                return;
            }
            PacketBuffer buffer = new PacketBuffer(event.getPayload().copy());
            ResourceLocation type = buffer.func_192575_l();
            BiConsumer consumer = (BiConsumer)map.get(type);
            if (consumer != null) {
                consumer.accept(new PacketContext(){

                    @Override
                    public PlayerEntity getPlayer() {
                        return this.isClient() ? this.getClientPlayer() : context.getSender();
                    }

                    @Override
                    public Consumer<Runnable> getTaskQueue() {
                        return arg_0 -> ((NetworkEvent.Context)context).enqueueWork(arg_0);
                    }

                    @Override
                    public boolean isClient() {
                        return context.getDirection().getReceptionSide() == LogicalSide.CLIENT;
                    }

                    private PlayerEntity getClientPlayer() {
                        return (PlayerEntity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::getClientPlayer);
                    }
                }, buffer);
            }
            context.setPacketHandled(true);
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerS2CHandler(ResourceLocation id, BiConsumer<PacketContext, PacketBuffer> consumer) {
        S2C.put(id, consumer);
    }

    @Override
    public void registerC2SHandler(ResourceLocation id, BiConsumer<PacketContext, PacketBuffer> consumer) {
        C2S.put(id, consumer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(ResourceLocation id, PacketBuffer buffer) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
            packetBuffer.func_192572_a(id);
            packetBuffer.writeBytes((ByteBuf)buffer);
            connection.func_147297_a(NetworkDirection.PLAY_TO_SERVER.buildPacket(Pair.of((Object)packetBuffer, (Object)0), CHANNEL_ID).getThis());
        }
    }

    public void sendToClient(ResourceLocation id, PacketDistributor.PacketTarget target, PacketBuffer buffer) {
        target.send(this.createToPlayerPacket(id, buffer));
    }

    @Override
    public void sendToPlayer(ServerPlayerEntity player, ResourceLocation id, PacketBuffer buffer) {
        this.sendToClient(id, PacketDistributor.PLAYER.with(() -> player), buffer);
    }

    @Override
    public IPacket<?> createToPlayerPacket(ResourceLocation id, PacketBuffer buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_192572_a(id);
        packetBuffer.writeBytes((ByteBuf)buffer);
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket(Pair.of((Object)packetBuffer, (Object)0), CHANNEL_ID).getThis();
    }
}

