/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.forge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.CommandDispatcher;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.platform.AbstractPlatform;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.platform.NetworkManager;
import hardcorequesting.common.forge.tileentity.AbstractBarrelBlockEntity;
import hardcorequesting.common.forge.util.Fraction;
import hardcorequesting.forge.ForgeFluidStack;
import hardcorequesting.forge.NetworkingManager;
import hardcorequesting.forge.tileentity.BarrelBlockEntity;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.util.TriConsumer;

@Mod(value="hardcorequesting")
public class HardcoreQuestingForge
implements AbstractPlatform {
    private final NetworkManager networkManager = new NetworkingManager();
    private final DeferredRegister<SoundEvent> sounds = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"hardcorequesting");
    private final DeferredRegister<Block> block = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"hardcorequesting");
    private final DeferredRegister<Item> item = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"hardcorequesting");
    private final DeferredRegister<TileEntityType<?>> tileEntityType = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"hardcorequesting");

    public HardcoreQuestingForge() {
        NetworkingManager.init();
        HardcoreQuestingCore.initialize(this);
        this.sounds.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.block.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.item.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.tileEntityType.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (player instanceof FakePlayer || event.isCanceled() || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || HQMConfig.getInstance().LOSE_QUEST_BOOK) {
                    return;
                }
                Iterator iter = event.getDrops().iterator();
                while (iter.hasNext()) {
                    ItemEntity entityItem = (ItemEntity)iter.next();
                    ItemStack stack = entityItem.func_92059_d();
                    if (stack.func_190926_b() || !stack.func_77973_b().equals((Object)ModItems.book.get())) continue;
                    player.field_71071_by.func_70441_a(stack);
                    iter.remove();
                }
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null || event.getPlayer() instanceof FakePlayer || !event.isWasDeath() || event.isCanceled() || event.getPlayer().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || HQMConfig.getInstance().LOSE_QUEST_BOOK) {
                return;
            }
            if (event.getOriginal().field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.book.get()))) {
                ItemStack bookStack = new ItemStack((IItemProvider)ModItems.book.get());
                for (ItemStack stack : event.getOriginal().field_71071_by.field_70460_b) {
                    if (!bookStack.func_77969_a(stack)) continue;
                    bookStack = stack.func_77946_l();
                    break;
                }
                event.getPlayer().field_71071_by.func_70441_a(bookStack);
            }
        });
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @Override
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("hardcorequesting").get()).getModInfo().getVersion().toString();
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public void registerOnCommandRegistration(Consumer<CommandDispatcher<CommandSource>> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> consumer.accept(event.getDispatcher()));
    }

    @Override
    public void registerOnWorldLoad(BiConsumer<RegistryKey<World>, ServerWorld> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(load -> {
            if (load.getWorld() instanceof ServerWorld) {
                biConsumer.accept(((World)load.getWorld()).func_234923_W_(), (ServerWorld)load.getWorld());
            }
        });
    }

    @Override
    public void registerOnWorldSave(Consumer<ServerWorld> consumer) {
        MinecraftForge.EVENT_BUS.addListener(save -> {
            if (save.getWorld() instanceof ServerWorld) {
                consumer.accept((ServerWorld)save.getWorld());
            }
        });
    }

    @Override
    public void registerOnPlayerJoin(Consumer<ServerPlayerEntity> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> consumer.accept((ServerPlayerEntity)event.getPlayer()));
    }

    @Override
    public void registerOnServerTick(Consumer<MinecraftServer> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                consumer.accept(this.getServer());
            }
        });
    }

    @Override
    public void registerOnClientTick(Consumer<Minecraft> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                consumer.accept(Minecraft.func_71410_x());
            }
        });
    }

    @Override
    public void registerOnWorldTick(Consumer<World> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                consumer.accept(event.world);
            }
        });
    }

    @Override
    public void registerOnHudRender(BiConsumer<MatrixStack, Float> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                biConsumer.accept(event.getMatrixStack(), Float.valueOf(event.getPartialTicks()));
            }
        });
    }

    @Override
    public void registerOnUseItem(TriConsumer<PlayerEntity, World, Hand> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept((Object)event.getPlayer(), (Object)event.getWorld(), (Object)event.getHand()));
    }

    @Override
    public void registerOnBlockPlace(AbstractPlatform.BlockPlaced blockPlaced) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getEntity() instanceof LivingEntity) {
                blockPlaced.onBlockPlaced(event.getEntity().func_130014_f_(), event.getPos(), event.getPlacedBlock(), (LivingEntity)event.getEntity());
            }
        });
    }

    @Override
    public void registerOnBlockUse(AbstractPlatform.BlockUsed blockUsed) {
        MinecraftForge.EVENT_BUS.addListener(event -> blockUsed.onBlockUsed(event.getPlayer(), event.getWorld(), event.getHand(), event.getPos(), event.getFace()));
    }

    @Override
    public void registerOnBlockBreak(AbstractPlatform.BlockBroken blockBroken) {
        MinecraftForge.EVENT_BUS.addListener(event -> blockBroken.onBlockBroken(event.getWorld(), event.getPos(), event.getState(), event.getPlayer()));
    }

    @Override
    public void registerOnItemPickup(BiConsumer<PlayerEntity, ItemStack> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> biConsumer.accept(event.getPlayer(), event.getStack()));
    }

    @Override
    public void registerOnLivingDeath(BiConsumer<LivingEntity, DamageSource> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> biConsumer.accept(event.getEntityLiving(), event.getSource()));
    }

    @Override
    public void registerOnCrafting(BiConsumer<PlayerEntity, ItemStack> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept(event.getPlayer(), event.getCrafting()));
    }

    @Override
    public void registerOnAnvilCrafting(BiConsumer<PlayerEntity, ItemStack> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept(event.getPlayer(), event.getItemResult()));
    }

    @Override
    public void registerOnSmelting(BiConsumer<PlayerEntity, ItemStack> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept(event.getPlayer(), event.getSmelting()));
    }

    @Override
    public void registerOnAdvancement(BiConsumer<ServerPlayerEntity, Advancement> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                biConsumer.accept((ServerPlayerEntity)event.getPlayer(), event.getAdvancement());
            }
        });
    }

    @Override
    public void registerOnAnimalTame(BiConsumer<PlayerEntity, Entity> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> biConsumer.accept(event.getTamer(), (Entity)event.getAnimal()));
    }

    @Override
    public CompoundNBT getPlayerExtraTag(PlayerEntity playerEntity) {
        return playerEntity.getPersistentData();
    }

    @Override
    public ItemGroup createTab(ResourceLocation resourceLocation, final Supplier<ItemStack> supplier) {
        return new ItemGroup(String.format("%s.%s", resourceLocation.func_110624_b(), resourceLocation.func_110623_a())){

            @Nonnull
            public ItemStack func_78016_d() {
                return (ItemStack)supplier.get();
            }
        };
    }

    @Override
    public AbstractBlock.Properties createDeliveryBlockProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_235861_h_().func_200943_b(1.0f).harvestTool(ToolType.AXE).harvestLevel(0);
    }

    @Override
    public AbstractBarrelBlockEntity createBarrelBlockEntity() {
        return new BarrelBlockEntity();
    }

    @Override
    public void setCraftingRemainingItem(Item item, Item item1) {
        item.field_77700_c = item1;
    }

    @Override
    public SaveFormat.LevelSave getStorageSourceOfServer(MinecraftServer minecraftServer) {
        return minecraftServer.field_71310_m;
    }

    @Override
    public FluidStack createEmptyFluidStack() {
        return new ForgeFluidStack();
    }

    @Override
    public FluidStack createFluidStack(Fluid fluid, Fraction fraction) {
        return new ForgeFluidStack(new net.minecraftforge.fluids.FluidStack(fluid, fraction.intValue()));
    }

    @Override
    public FluidStack findFluidIn(ItemStack stack) {
        return new ForgeFluidStack(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> handler.getFluidInTank(0)).orElse(net.minecraftforge.fluids.FluidStack.EMPTY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType createFluid(ResourceLocation location) {
        return RenderType.func_228633_a_((String)"hardcorequesting:fluid_type", (VertexFormat)DefaultVertexFormats.field_181709_i, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(RenderState.field_228520_l_).func_228719_a_(RenderState.field_228528_t_).func_228724_a_(new RenderState.TextureState(location, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228728_a_(false));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFluidStack(FluidStack fluidStack, MatrixStack matrices, int x1, int y1, int x2, int y2) {
        ForgeFluidStack stack = (ForgeFluidStack)fluidStack;
        FluidAttributes attributes = stack.getFluid().getAttributes();
        ResourceLocation texture = attributes.getStillTexture(stack._stack);
        RenderMaterial blockMaterial = ForgeHooksClient.getBlockMaterial((ResourceLocation)texture);
        TextureAtlasSprite sprite = blockMaterial.func_229314_c_();
        int color = attributes.getColor((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, BlockPos.field_177992_a);
        int a = 255;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        IRenderTypeBuffer.Impl source = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = blockMaterial.func_229311_a_((IRenderTypeBuffer)source, HardcoreQuestingForge::createFluid);
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix, (float)x2, (float)y1, 0.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, 0.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y2, 0.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_225586_a_(r, g, b, a).func_181675_d();
        source.func_228461_a_();
    }

    @Override
    public Fraction getBucketAmount() {
        return Fraction.ofWhole(1000L);
    }

    @Override
    public Block getBlock(ResourceLocation resourceLocation) {
        return (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
    }

    @Override
    public SoundEvent getSoundEvent(ResourceLocation location) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(location);
    }

    @Override
    public Item getItem(ResourceLocation resourceLocation) {
        return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
    }

    @Override
    public TileEntityType<?> getBlockEntity(ResourceLocation resourceLocation) {
        return (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(resourceLocation);
    }

    @Override
    public void registerBlock(ResourceLocation resourceLocation, Supplier<Block> supplier) {
        this.block.register(resourceLocation.func_110623_a(), supplier);
    }

    @Override
    public void registerSound(ResourceLocation resourceLocation, Supplier<SoundEvent> supplier) {
        this.sounds.register(resourceLocation.func_110623_a(), supplier);
    }

    @Override
    public void registerItem(ResourceLocation resourceLocation, Supplier<Item> supplier) {
        this.item.register(resourceLocation.func_110623_a(), supplier);
    }

    @Override
    public void registerBlockEntity(ResourceLocation resourceLocation, Supplier<TileEntityType<?>> supplier) {
        this.tileEntityType.register(resourceLocation.func_110623_a(), supplier);
    }
}

