/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import com.google.common.collect.Lists;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.util.Executor;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Translator {
    private static Pattern pluralPattern = Pattern.compile("\\[\\[(.*)\\|\\|(.*)]]");
    private static final LazyValue<BiFunction<String, Object[], String>> storageTranslator = new LazyValue(() -> (BiFunction)Executor.call(() -> () -> (s, args) -> I18n.func_135052_a((String)s, (Object[])args), () -> () -> (s, args) -> {
        String s1 = LanguageMap.func_74808_a().func_230503_a_(s);
        if (s1 == null) {
            s1 = s;
        }
        try {
            return String.format(s1, args);
        }
        catch (IllegalFormatException var5) {
            return "Format error: " + s1;
        }
    }));

    public static String get(String id, Object ... args) {
        return ((String)((BiFunction)storageTranslator.func_179281_c()).apply(id, args)).replace("\\n", "\n");
    }

    public static IFormattableTextComponent pluralTranslated(boolean plural, String id, Object ... args) {
        return Translator.pluralFormat((ITextComponent)Translator.text(Translator.get(id, args)), null, plural);
    }

    public static IFormattableTextComponent pluralTranslated(boolean plural, String id, GuiColor color, Object ... args) {
        return Translator.pluralFormat((ITextComponent)Translator.text(Translator.get(id, args)), color, plural);
    }

    private static IFormattableTextComponent pluralFormat(ITextComponent text, GuiColor color, boolean plural) {
        if (text == null) {
            return new StringTextComponent("");
        }
        try {
            TextCollector collector = new TextCollector();
            text.func_230438_a_(asString -> {
                Matcher matcher = pluralPattern.matcher(asString);
                while (matcher.find()) {
                    asString = matcher.replaceFirst(matcher.group(plural ? 2 : 1));
                    matcher = pluralPattern.matcher(asString);
                }
                collector.add((ITextComponent)(color == null ? Translator.text(asString) : Translator.text(asString, color)));
                return Optional.empty();
            });
            return collector.getCombined();
        }
        catch (IllegalFormatException e) {
            return TextCollector.concat(new ITextComponent[]{Translator.text("Format Exception: "), text});
        }
    }

    public static String rawString(ITextProperties text) {
        return TextFormatting.func_110646_a((String)text.getString());
    }

    public static ITextProperties plain(String s) {
        return s != null ? ITextProperties.func_240652_a_((String)s) : ITextProperties.field_240651_c_;
    }

    public static IFormattableTextComponent text(String s) {
        return s != null ? new StringTextComponent(s) : new StringTextComponent("");
    }

    public static IFormattableTextComponent text(String s, TextFormatting formatting) {
        return Translator.text(s).func_240703_c_(Style.field_240709_b_.func_240712_a_(formatting));
    }

    public static IFormattableTextComponent text(String s, Color color) {
        return Translator.text(s).func_240703_c_(Style.field_240709_b_.func_240718_a_(color));
    }

    public static IFormattableTextComponent text(String s, GuiColor color) {
        return Translator.text(s, Color.func_240743_a_((int)(color.getHexColor() & 0xFFFFFF)));
    }

    public static IFormattableTextComponent translatable(String id, Object ... args) {
        return new TranslationTextComponent(id, args);
    }

    public static IFormattableTextComponent translatable(String id, TextFormatting formatting, Object ... args) {
        return Translator.translatable(id, args).func_240699_a_(formatting);
    }

    public static IFormattableTextComponent translatable(String id, Color color, Object ... args) {
        return Translator.translatable(id, args).func_240703_c_(Style.field_240709_b_.func_240718_a_(color));
    }

    public static IFormattableTextComponent translatable(String id, GuiColor color, Object ... args) {
        return Translator.translatable(id, Color.func_240743_a_((int)(color.getHexColor() & 0xFFFFFF)), args);
    }

    private static class TextCollector {
        private final List<ITextComponent> texts = Lists.newArrayList();

        private TextCollector() {
        }

        public void add(ITextComponent text) {
            this.texts.add(text);
        }

        public IFormattableTextComponent getRawCombined() {
            if (this.texts.isEmpty()) {
                return null;
            }
            return this.texts.size() == 1 ? this.texts.get(0).func_230532_e_() : TextCollector.concat(this.texts);
        }

        public IFormattableTextComponent getCombined() {
            IFormattableTextComponent text = this.getRawCombined();
            return text != null ? text : new StringTextComponent("");
        }

        private static TextComponent concat(ITextComponent ... texts) {
            return TextCollector.concat(Arrays.asList(texts));
        }

        private static TextComponent concat(final List<ITextComponent> texts) {
            return new TextComponent(){

                public TextComponent func_230531_f_() {
                    return TextCollector.concat(texts);
                }

                public <T> Optional<T> func_230438_a_(ITextProperties.ITextAcceptor<T> visitor) {
                    Optional optional;
                    Iterator var2 = texts.iterator();
                    do {
                        if (var2.hasNext()) continue;
                        return Optional.empty();
                    } while (!(optional = ((ITextComponent)var2.next()).func_230438_a_(visitor)).isPresent());
                    return optional;
                }

                @OnlyIn(value=Dist.CLIENT)
                public <T> Optional<T> func_230439_a_(ITextProperties.IStyledTextAcceptor<T> styledVisitor, Style style) {
                    return Optional.empty();
                }
            };
        }
    }
}

