/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.tileentity;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.tileentity.TrackerBlockEntity;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public enum TrackerType {
    TEAM("team"){

        @Override
        public int getMeta(TrackerBlockEntity tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : TeamManager.getInstance().getTeams()) {
                boolean valid;
                if (!team.getQuestData((UUID)quest.getQuestId()).completed) continue;
                boolean bl = valid = radius == 0;
                if (!(valid = TrackerType.isValid(valid, team, tracker, radius)) || ++meta != 15) continue;
                break;
            }
            return meta;
        }
    }
    ,
    PLAYER("player"){

        @Override
        public int getMeta(TrackerBlockEntity tracker, Quest quest, int radius) {
            int meta = 0;
            block0: for (Team team : TeamManager.getInstance().getTeams()) {
                if (!team.getQuestData((UUID)quest.getQuestId()).completed) continue;
                for (PlayerEntry entry : team.getPlayers()) {
                    PlayerEntity player;
                    boolean valid;
                    if (!entry.isInTeam()) continue;
                    boolean bl = valid = radius == 0;
                    if (!valid && (player = QuestingData.getPlayer(entry.getUUID())) != null && TrackerType.isPlayerWithinRadius(tracker, player, radius)) {
                        valid = true;
                    }
                    if (!valid || ++meta != 15) continue;
                    continue block0;
                }
            }
            return meta;
        }
    }
    ,
    PROGRESS_MAX("progressMax"){

        @Override
        public int getMeta(TrackerBlockEntity tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : TeamManager.getInstance().getTeams()) {
                boolean valid;
                int newMeta = (int)(quest.getProgress(team) * 15.0f);
                if (newMeta <= meta) continue;
                boolean bl = valid = radius == 0;
                if (!(valid = TrackerType.isValid(valid, team, tracker, radius))) continue;
                meta = newMeta;
            }
            return meta;
        }
    }
    ,
    PROGRESS_CLOSE("progressClose"){

        @Override
        public int getMeta(TrackerBlockEntity tracker, Quest quest, int radius) {
            double closest = 0.0;
            ServerPlayerEntity closestPlayer = null;
            for (ServerPlayerEntity player : HardcoreQuestingCore.getServer().func_184103_al().func_181057_v()) {
                double distance = player.func_70092_e((double)tracker.func_174877_v().func_177958_n() + 0.5, (double)tracker.func_174877_v().func_177956_o() + 0.5, (double)tracker.func_174877_v().func_177952_p() + 0.5);
                if (closestPlayer != null && !(distance < closest)) continue;
                closest = distance;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                return (int)(quest.getProgress(QuestingDataManager.getInstance().getQuestingData((PlayerEntity)closestPlayer).getTeam()) * 15.0f);
            }
            return 0;
        }
    };

    private String id;

    private TrackerType(String name) {
        this.id = name;
    }

    private static boolean isPlayerWithinRadius(TrackerBlockEntity tracker, PlayerEntity player, int radius) {
        return player.func_70092_e((double)tracker.func_174877_v().func_177958_n() + 0.5, (double)tracker.func_174877_v().func_177956_o() + 0.5, (double)tracker.func_174877_v().func_177952_p() + 0.5) < (double)(radius * radius);
    }

    private static boolean isValid(boolean valid, Team team, TrackerBlockEntity tracker, int radius) {
        if (!valid) {
            for (PlayerEntry entry : team.getPlayers()) {
                PlayerEntity player;
                if (!entry.isInTeam() || (player = QuestingData.getPlayer(entry.getUUID())) == null || !TrackerType.isPlayerWithinRadius(tracker, player, radius)) continue;
                return true;
            }
        }
        return valid;
    }

    public String getName() {
        return I18n.func_135052_a((String)("hqm.tracker." + this.id + ".title"), (Object[])new Object[0]);
    }

    public String getDescription() {
        return I18n.func_135052_a((String)("hqm.tracker." + this.id + ".desc"), (Object[])new Object[0]);
    }

    public abstract int getMeta(TrackerBlockEntity var1, Quest var2, int var3);
}

