/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.tileentity;

import hardcorequesting.common.forge.blocks.ModBlocks;
import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiType;
import hardcorequesting.common.forge.client.interfaces.GuiWrapperEditMenu;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuTracker;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.tileentity.TrackerType;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrackerBlockEntity
extends TileEntity
implements ITickableTileEntity {
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_RADIUS = "Radius";
    private static final String NBT_TYPE = "TrackerType";
    private Quest quest;
    private UUID questId;
    private int radius;
    private TrackerType type = TrackerType.TEAM;
    private int delay = 0;

    public TrackerBlockEntity() {
        super(ModBlocks.typeTracker.get());
    }

    private static TrackerBlockEntity getTracker(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TrackerBlockEntity ? (TrackerBlockEntity)te : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openInterface(PlayerEntity player, BlockPos pos, UUID questId, int radius, TrackerType type) {
        TrackerBlockEntity tracker = TrackerBlockEntity.getTracker(player.field_70170_p, pos);
        if (tracker != null) {
            tracker.questId = questId;
            tracker.quest = null;
            tracker.radius = radius;
            tracker.type = type;
            GuiWrapperEditMenu gui = new GuiWrapperEditMenu();
            ((GuiBase)gui).setEditMenu(new GuiEditMenuTracker((GuiBase)gui, player, tracker));
            Minecraft.func_71410_x().func_147108_a((Screen)gui);
        }
    }

    public static void saveToServer(PlayerEntity player, BlockPos pos, int radius, TrackerType type) {
        TrackerBlockEntity tracker = TrackerBlockEntity.getTracker(player.field_70170_p, pos);
        if (Quest.canQuestsBeEdited() && tracker != null) {
            tracker.radius = radius;
            tracker.type = type;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b(NBT_QUEST)) {
            try {
                compound.func_186854_a(NBT_QUEST, UUID.fromString(compound.func_74779_i(NBT_QUEST)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            compound.func_82580_o(NBT_QUEST);
        }
        if (compound.func_74764_b("QuestMost")) {
            this.questId = compound.func_186857_a(NBT_QUEST);
        } else {
            this.quest = null;
        }
        this.radius = compound.func_74762_e(NBT_RADIUS);
        this.type = TrackerType.values()[compound.func_74771_c(NBT_TYPE)];
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.quest != null) {
            compound.func_186854_a(NBT_QUEST, this.quest.getQuestId());
        }
        compound.func_74768_a(NBT_RADIUS, this.radius);
        compound.func_74774_a(NBT_TYPE, (byte)this.type.ordinal());
        return compound;
    }

    public void func_73660_a() {
        if (this.quest == null && this.questId != null) {
            this.quest = Quest.getQuest(this.questId);
            this.questId = null;
        }
    }

    private void notifyUpdate(int x, int y, int z, int i) {
        if (i == 2 || x != this.field_174879_c.func_177958_n() || y != this.field_174879_c.func_177956_o() || z != this.field_174879_c.func_177952_p()) {
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            if (i > 0) {
                this.notifyUpdate(x - 1, y, z, i - 1);
                this.notifyUpdate(x + 1, y, z, i - 1);
                this.notifyUpdate(x, y - 1, z, i - 1);
                this.notifyUpdate(x, y + 1, z, i - 1);
                this.notifyUpdate(x, y, z - 1, i - 1);
                this.notifyUpdate(x, y, z + 1, i - 1);
            }
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public TrackerType getTrackerType() {
        return this.type;
    }

    public void setTrackerType(TrackerType type) {
        this.type = type;
    }

    public void setCurrentQuest() {
        this.quest = Quest.getQuest(Quest.speciallySelectedQuestId);
    }

    public Quest getCurrentQuest() {
        return this.quest;
    }

    public void openInterface(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkManager.sendToPlayer(GuiType.TRACKER.build(this.build()), (ServerPlayerEntity)player);
        }
    }

    private String[] build() {
        String[] data = new String[]{"" + this.field_174879_c.func_218275_a(), this.quest != null ? this.quest.getQuestId().toString() : null, "" + this.radius, "" + this.type.ordinal()};
        return data;
    }

    public void sendToServer() {
        NetworkManager.sendToServer(ClientChange.TRACKER_UPDATE.build((Object)this));
    }
}

