/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.tileentity;

import hardcorequesting.common.forge.blocks.DeliveryBlock;
import hardcorequesting.common.forge.blocks.ModBlocks;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import hardcorequesting.common.forge.tileentity.AbstractBaseBlockEntity;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBarrelBlockEntity
extends AbstractBaseBlockEntity
implements IInventory {
    private static final String NBT_PLAYER_UUID = "Player";
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_TASK = "Task";
    private UUID selectedQuestId;
    public int selectedTask;
    private UUID playerId;

    public AbstractBarrelBlockEntity() {
        super(ModBlocks.typeBarrel.get());
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    @NotNull
    public ItemStack func_70301_a(int i) {
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack func_70298_a(int i, int j) {
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, @NotNull ItemStack stack) {
        QuestTask task = this.getCurrentTask();
        if (task instanceof ConsumeItemTask) {
            ConsumeItemTask consumeTask = (ConsumeItemTask)task;
            NonNullList list = NonNullList.func_191196_a();
            list.add((Object)stack);
            if (consumeTask.increaseItems((NonNullList<ItemStack>)list, this.getPlayerUUID())) {
                this.updateState();
                this.doSync();
            }
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@NotNull PlayerEntity player) {
        return true;
    }

    public void func_174889_b(@NotNull PlayerEntity player) {
    }

    public void func_174886_c(@NotNull PlayerEntity player) {
    }

    public boolean func_94041_b(int index, @NotNull ItemStack stack) {
        QuestTask task = this.getCurrentTask();
        if (task instanceof ConsumeItemTask) {
            return ((ConsumeItemTask)task).canTakeItem(stack, this.getPlayerUUID());
        }
        return false;
    }

    public void func_174888_l() {
    }

    protected void doSync() {
        if (!this.field_145850_b.field_72995_K) {
            PlayerEntity player;
            this.syncToClientsNearby();
            QuestTask task = this.getCurrentTask();
            if (task != null && (player = QuestingData.getPlayer(this.getPlayerUUID())) != null) {
                task.getParent().sendUpdatedDataToTeam(player);
            }
        }
    }

    protected void updateState() {
        if (!this.field_145850_b.field_72995_K) {
            QuestTask task = this.getCurrentTask();
            boolean bound = false;
            if (task != null && !task.isCompleted(this.getPlayerUUID())) {
                bound = true;
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)ModBlocks.blockBarrel.get().func_176223_P().func_206870_a((Property)DeliveryBlock.BOUND, (Comparable)Boolean.valueOf(bound)), 3);
        }
    }

    public QuestTask getCurrentTask() {
        Quest quest;
        if (this.getPlayerUUID() != null && this.selectedQuestId != null && (quest = Quest.getQuest(this.selectedQuestId)) != null && this.selectedTask >= 0 && this.selectedTask < quest.getTasks().size()) {
            return quest.getTasks().get(this.selectedTask);
        }
        return null;
    }

    public void storeSettings(PlayerEntity player) {
        this.setPlayerUUID(player.func_110124_au());
        QuestingData data = QuestingDataManager.getInstance().getQuestingData(this.getPlayerUUID());
        this.setQuestUUID(data.selectedQuestId);
        this.selectedTask = data.selectedTask;
        QuestTask task = this.getCurrentTask();
        if (task == null || task.isCompleted(this.getPlayerUUID())) {
            this.setPlayerUUID(null);
            this.setQuestUUID(null);
            this.selectedTask = 0;
        }
        this.doSync();
        this.updateState();
    }

    public UUID getPlayerUUID() {
        return this.playerId;
    }

    public void setPlayerUUID(UUID playerId) {
        this.playerId = playerId;
    }

    public UUID getQuestUUID() {
        return this.selectedQuestId;
    }

    public void setQuestUUID(UUID questId) {
        this.selectedQuestId = questId;
    }

    @Override
    public void writeTile(CompoundNBT nbt, AbstractBaseBlockEntity.NBTType type) {
        if (this.getPlayerUUID() != null && this.selectedQuestId != null) {
            nbt.func_186854_a(NBT_PLAYER_UUID, this.getPlayerUUID());
            nbt.func_186854_a(NBT_QUEST, this.getQuestUUID());
            nbt.func_74774_a(NBT_TASK, (byte)this.selectedTask);
        }
    }

    @Override
    public void readTile(CompoundNBT nbt, AbstractBaseBlockEntity.NBTType type) {
        if (nbt.func_74764_b("PlayerMost")) {
            this.setPlayerUUID(nbt.func_186857_a(NBT_PLAYER_UUID));
            this.setQuestUUID(nbt.func_186857_a(NBT_QUEST));
            this.selectedTask = nbt.func_74771_c(NBT_TASK);
        }
    }
}

