/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.TeamErrorMessage;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum TeamError {
    INVALID_PLAYER("hqm.team.invalidPlayer.title", "hqm.team.invalidPlayer.desc"),
    IN_PARTY("hqm.team.playerInParty.title", "hqm.team.playerInParty.desc"),
    USED_NAME("hqm.team.usedTeamName.title", "hqm.team.usedTeamName.desc");

    public static TeamError latestError;
    private String header;
    private String message;

    private TeamError(String header, String message) {
        this.message = message;
        this.header = header;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getMessage() {
        return I18n.func_135052_a((String)this.message, (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getHeader() {
        return I18n.func_135052_a((String)this.header, (Object[])new Object[0]);
    }

    public void sendToClient(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkManager.sendToPlayer(new TeamErrorMessage(this), (ServerPlayerEntity)player);
        }
    }
}

