/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.LifeSetting;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamError;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.team.TeamUpdateSize;
import hardcorequesting.common.forge.team.TeamUpdateType;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public enum TeamAction {
    CREATE{

        @Override
        public void process(Team team, PlayerEntity player, String teamName) {
            if (team.isSingle()) {
                TeamManager manager = TeamManager.getInstance();
                if (teamName.length() == 0) {
                    return;
                }
                for (Team t : manager.getNamedTeams()) {
                    if (!t.getName().equals(teamName)) continue;
                    TeamError.USED_NAME.sendToClient(player);
                    return;
                }
                team.setId(UUID.randomUUID());
                manager.addTeam(team);
                team.setName(teamName);
                team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                Team.declineAll(player.func_110124_au());
                TeamLiteStat.refreshTeam(team);
                NetworkManager.sendToAllPlayers(TeamUpdateType.CREATE_TEAM.build(team, new Object[0]));
                if (player instanceof ServerPlayerEntity) {
                    NetworkManager.sendToPlayer(TeamUpdateType.JOIN_TEAM.build(team, player.func_110124_au().toString()), (ServerPlayerEntity)player);
                }
            }
        }
    }
    ,
    INVITE{

        @Override
        public void process(Team team, PlayerEntity player, String playerName) {
            ServerPlayerEntity invitedPlayer = HardcoreQuestingCore.getServer().func_184103_al().func_152612_a(playerName);
            if (!team.isSingle() && team.isOwner(player) && invitedPlayer != null) {
                QuestingDataManager manager = QuestingDataManager.getInstance();
                PlayerEntry invitedPlayerEntry = new PlayerEntry(invitedPlayer.func_110124_au(), false, false);
                if (!manager.hasData(invitedPlayer.func_110124_au())) {
                    TeamError.INVALID_PLAYER.sendToClient(player);
                    return;
                }
                if (!manager.getQuestingData(invitedPlayer.func_110124_au()).getTeam().isSingle()) {
                    TeamError.IN_PARTY.sendToClient(player);
                    return;
                }
                if (!team.getPlayers().contains(invitedPlayerEntry)) {
                    team.getPlayers().add(invitedPlayerEntry);
                    team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                    manager.getQuestingData(invitedPlayer.func_110124_au()).getTeam().refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                    manager.getQuestingData(invitedPlayer.func_110124_au()).getTeam().getInvites().add(team);
                    NetworkManager.sendToPlayer(TeamUpdateType.INVITE.build(team, new Object[0]), invitedPlayer);
                }
            }
        }
    }
    ,
    ACCEPT{

        @Override
        public void process(Team team, PlayerEntity player, String data) {
            if (team.isSingle()) {
                UUID acceptId = UUID.fromString(data);
                Team inviteTeam = TeamManager.getInstance().getByTeamId(acceptId);
                if (inviteTeam != null) {
                    int id = 0;
                    for (PlayerEntry entry : inviteTeam.getPlayers()) {
                        QuestData questData;
                        QuestData joinData;
                        if (entry.isInTeam()) {
                            ++id;
                            continue;
                        }
                        if (!entry.getUUID().equals(player.func_110124_au())) continue;
                        entry.setBookOpen(true);
                        entry.setInTeam(true);
                        QuestingDataManager.getInstance().getQuestingData(player).setTeam(inviteTeam);
                        for (UUID questId : inviteTeam.getQuestData().keySet()) {
                            joinData = team.getQuestData().get(questId);
                            questData = inviteTeam.getQuestData().get(questId);
                            if (questData == null) continue;
                            boolean[] old = questData.reward;
                            questData.reward = new boolean[old.length + 1];
                            for (int j = 0; j < questData.reward.length; ++j) {
                                questData.reward[j] = j == id ? joinData.reward[0] : (j < id ? old[j] : old[j - 1]);
                            }
                        }
                        for (UUID questId : inviteTeam.getQuestData().keySet()) {
                            joinData = team.getQuestData().get(questId);
                            questData = inviteTeam.getQuestData().get(questId);
                            if (questData == null || Quest.getQuest(questId) == null) continue;
                            Quest.getQuest(questId).mergeProgress(player.func_110124_au(), questData, joinData);
                        }
                        for (Reputation reputation : ReputationManager.getInstance().getReputations().values()) {
                            if (reputation == null) continue;
                            int joinValue = team.getReputation(reputation);
                            int teamValue = inviteTeam.getReputation(reputation);
                            int targetValue = Math.abs(joinValue) > Math.abs(teamValue) ? joinValue : teamValue;
                            inviteTeam.setReputation(reputation, targetValue);
                        }
                        inviteTeam.refreshData();
                        Team.declineAll(player.func_110124_au());
                        TeamLiteStat.refreshTeam(inviteTeam);
                        NetworkManager.sendToPlayer(TeamUpdateType.JOIN_TEAM.build(inviteTeam, player.func_110124_au()), entry.getPlayerMP());
                        break;
                    }
                }
            }
        }
    }
    ,
    DECLINE{

        @Override
        public void process(Team team, PlayerEntity player, String data) {
            if (team.isSingle()) {
                UUID declineId = UUID.fromString(data);
                TeamManager manager = TeamManager.getInstance();
                Team inviteTeam = manager.getByTeamId(declineId);
                if (inviteTeam != null) {
                    inviteTeam.getPlayers().remove(new PlayerEntry(player.func_110124_au(), false, false));
                    inviteTeam.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                    team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                }
            }
        }
    }
    ,
    KICK{

        @Override
        public void process(Team team, PlayerEntity player, String toRemovePlayerUuid) {
            PlayerEntry entryToRemove;
            ServerPlayerEntity playerToRemove = HardcoreQuestingCore.getServer().func_184103_al().func_177451_a(UUID.fromString(toRemovePlayerUuid));
            if (!team.isSingle() && team.isOwner(player) && playerToRemove != null && !(entryToRemove = team.getEntry(playerToRemove.func_110124_au())).isOwner()) {
                if (entryToRemove.isInTeam()) {
                    team.removePlayer((PlayerEntity)playerToRemove);
                    team.refreshTeamData(TeamUpdateSize.ALL);
                    TeamLiteStat.refreshTeam(team);
                } else {
                    team.getPlayers().remove(entryToRemove);
                    team.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                }
                QuestingDataManager.getInstance().getQuestingData((PlayerEntity)playerToRemove).getTeam().refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
            }
        }
    }
    ,
    LEAVE{

        @Override
        public void process(Team team, PlayerEntity player, String data) {
            if (!team.isSingle() && !team.isOwner(player)) {
                team.removePlayer(player);
                team.refreshTeamData(TeamUpdateSize.ALL);
                TeamAction.getTeam(player).refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                TeamLiteStat.refreshTeam(team);
            }
        }
    }
    ,
    DISBAND{

        @Override
        public void process(Team team, PlayerEntity player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.deleteTeam();
                TeamLiteStat.refreshTeam(team);
            }
        }
    }
    ,
    NEXT_LIFE_SETTING{

        @Override
        public void process(Team team, PlayerEntity player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.setLifeSetting(LifeSetting.values()[(team.getLifeSetting().ordinal() + 1) % LifeSetting.values().length]);
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
    }
    ,
    NEXT_REWARD_SETTING{

        @Override
        public void process(Team team, PlayerEntity player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.setRewardSetting(RewardSetting.values()[(team.getRewardSetting().ordinal() + 1) % RewardSetting.values().length]);
                if (team.getRewardSetting() == RewardSetting.ALL) {
                    team.setRewardSetting(RewardSetting.getDefault());
                }
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
    };


    private static Team getTeam(PlayerEntity player) {
        return QuestingDataManager.getInstance().getQuestingData(player).getTeam();
    }

    public void process(PlayerEntity player, String data) {
        this.process(TeamAction.getTeam(player), player, data);
    }

    public abstract void process(Team var1, PlayerEntity var2, String var3);
}

