/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.adapter.Adapter;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class PlayerEntry {
    private static final String ENTRY_UUID = "uuid";
    private static final String ENTRY_OWNER = "owner";
    private static final String ENTRY_BOOK = "bookOpen";
    private static final String ENTRY_IN_TEAM = "inTeam";
    private static final String ENTRY_NAME = "name";
    private UUID uuid;
    private boolean inTeam;
    private boolean owner;
    private boolean bookOpen;
    private String playerName = null;

    private PlayerEntry() {
    }

    public PlayerEntry(UUID uuid, boolean inTeam, boolean owner) {
        this();
        this.uuid = uuid;
        this.inTeam = inTeam;
        this.owner = owner;
        this.bookOpen = false;
    }

    public static PlayerEntry read(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        PlayerEntry playerEntry = new PlayerEntry();
        playerEntry.uuid = UUID.fromString(JSONUtils.func_151200_h((JsonObject)object, (String)ENTRY_UUID));
        playerEntry.owner = JSONUtils.func_151212_i((JsonObject)object, (String)ENTRY_OWNER);
        playerEntry.bookOpen = JSONUtils.func_151212_i((JsonObject)object, (String)ENTRY_BOOK);
        playerEntry.inTeam = JSONUtils.func_151212_i((JsonObject)object, (String)ENTRY_IN_TEAM);
        playerEntry.playerName = (String)StringUtils.defaultIfEmpty((CharSequence)JSONUtils.func_151219_a((JsonObject)object, (String)ENTRY_NAME, null), null);
        return playerEntry;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getDisplayName() {
        if (this.playerName == null) {
            ServerPlayerEntity entry;
            MinecraftServer server = HardcoreQuestingCore.getServer();
            if (server != null && (entry = server.func_184103_al().func_177451_a(this.getUUID())) != null) {
                this.playerName = entry.func_195047_I_();
                return (String)StringUtils.defaultIfEmpty((CharSequence)this.playerName, (CharSequence)"");
            }
            if (HardcoreQuestingCore.platform.isClient()) {
                this.playerName = this.getDisplayNameClient();
                return (String)StringUtils.defaultIfEmpty((CharSequence)this.playerName, (CharSequence)"");
            }
        }
        return Objects.toString(this.playerName);
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getDisplayNameClient() {
        PlayerEntity entry = Minecraft.func_71410_x().field_71441_e.func_217371_b(this.getUUID());
        if (entry != null) {
            return entry.func_195047_I_();
        }
        return null;
    }

    public boolean isInTeam() {
        return this.inTeam;
    }

    public void setInTeam(boolean inTeam) {
        this.inTeam = inTeam;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerEntry entry = (PlayerEntry)o;
        return Objects.equals(this.uuid, entry.uuid);
    }

    public boolean isBookOpen() {
        return this.bookOpen;
    }

    public void setBookOpen(boolean bookOpen) {
        this.bookOpen = bookOpen;
    }

    public JsonElement toJson() {
        return Adapter.object().add(ENTRY_UUID, this.uuid.toString()).add(ENTRY_OWNER, this.owner).add(ENTRY_BOOK, this.bookOpen).add(ENTRY_IN_TEAM, this.inTeam).add(ENTRY_NAME, this.getDisplayName()).build();
    }

    public ServerPlayerEntity getPlayerMP() {
        return HardcoreQuestingCore.getServer().func_184103_al().func_177451_a(this.getUUID());
    }
}

