/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.reputation;

import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.reputation.Reputation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReputationManager
extends SimpleSerializable {
    final Map<String, Reputation> reputationMap = new HashMap<String, Reputation>();

    public ReputationManager(QuestLine parent) {
        super(parent);
    }

    public static ReputationManager getInstance() {
        return QuestLine.getActiveQuestLine().reputationManager;
    }

    public void clear() {
        this.reputationMap.clear();
    }

    public Map<String, Reputation> getReputations() {
        return this.reputationMap;
    }

    public List<Reputation> getReputationList() {
        return new ArrayList<Reputation>(this.reputationMap.values());
    }

    public Reputation getReputation(String id) {
        return this.reputationMap.get(id);
    }

    public void addReputation(Reputation reputation) {
        this.reputationMap.put(reputation.getId(), reputation);
    }

    public int size() {
        return this.reputationMap.size();
    }

    @Override
    public String filePath() {
        return "reputations.json";
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.getReputationList(), new TypeToken<List<Reputation>>(){}.getType());
    }

    @Override
    public void loadFromString(Optional<String> string) {
        this.reputationMap.clear();
        string.flatMap(s -> SaveHandler.load(s, new TypeToken<List<Reputation>>(){}.getType())).ifPresent(reputations -> reputations.forEach(this::addReputation));
    }
}

