/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.reputation;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReputationBar {
    private String repId;
    private int x;
    private int y;
    private int questSet;

    public ReputationBar(Reputation reputation, int x, int y, QuestSet questSet) {
        this(reputation.getId(), x, y, questSet.getId());
    }

    public ReputationBar(String repId, int x, int y, int questSet) {
        this.repId = repId;
        this.x = x;
        this.y = y;
        this.questSet = questSet;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getRepId() {
        return this.repId;
    }

    public QuestSet getQuestSet() {
        return Quest.getQuestSets().get(this.questSet);
    }

    public void setQuestSet(int id) {
        this.questSet = id;
    }

    public boolean isValid() {
        return Quest.getQuestSets().size() > this.questSet && this.getQuestSet() != null && ReputationManager.getInstance().getReputation(this.repId) != null;
    }

    public boolean sameLocation(ReputationBar reputationBar) {
        return reputationBar != null && reputationBar.x == this.x && reputationBar.y == this.y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrices, GuiQuestBook gui, int mX, int mY, PlayerEntity player) {
        Reputation reputation = ReputationManager.getInstance().getReputation(this.repId);
        if (reputation == null) {
            return;
        }
        gui.applyColor(-1);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        String info = reputation.draw(matrices, gui, this.x, this.y, mX, mY, null, player, false, null, null, false, null, null, false);
        if (info != null) {
            gui.renderTooltip(matrices, Translator.plain(info), mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean inBounds(int mX, int mY) {
        return this.x <= mX && this.x + 125 >= mX && this.y - 9 <= mY && this.y + 18 >= mY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        if (this.inBounds(x, y)) {
            switch (gui.getCurrentMode()) {
                case MOVE: {
                    gui.modifyingBar = this;
                    SaveHelper.add(EditType.REPUTATION_BAR_MOVE);
                    break;
                }
                case REP_BAR_CHANGE: {
                    gui.setEditMenu(new EditGui((GuiBase)gui, gui.getPlayer(), this));
                    break;
                }
                case DELETE: {
                    this.getQuestSet().removeRepBar(this);
                    SaveHelper.add(EditType.REPUTATION_BAR_REMOVE);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EditGui
    extends GuiEditMenu {
        private ReputationBar bar;
        private boolean isNew;
        private final ScrollBar scrollBar = new ScrollBar(this, 160, 23, 186, 171, 69, 20){
            final /* synthetic */ EditGui this$0;
            {
                this.this$0 = this$0;
                super(x, y, h, u, v, left);
            }

            @Override
            public boolean isVisible(GuiBase gui) {
                return ReputationManager.getInstance().size() > 10;
            }
        };

        public EditGui(GuiBase guiBase, PlayerEntity player, ReputationBar bar) {
            super(guiBase, player);
            this.bar = bar;
            this.isNew = false;
        }

        public EditGui(GuiBase guiBase, PlayerEntity player, int x, int y, int selectedSet) {
            super(guiBase, player);
            this.bar = new ReputationBar(null, x, y, selectedSet);
            this.isNew = true;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(MatrixStack matrices, GuiBase guiB, int mX, int mY) {
            ReputationManager reputationManager = ReputationManager.getInstance();
            GuiQuestBook gui = (GuiQuestBook)guiB;
            int start = this.scrollBar.isVisible(gui) ? Math.round((float)(reputationManager.size() - 10) * this.scrollBar.getScroll()) : 0;
            int end = Math.min(start + 10, reputationManager.size());
            List<Reputation> reputationList = reputationManager.getReputationList();
            for (int i = start; i < end; ++i) {
                int x = 20;
                int y = 20 + (i - start) * 20;
                String str = reputationList.get(i).getName();
                boolean hover = gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY);
                boolean selected = reputationList.get(i).equals(reputationManager.getReputation(this.bar.repId));
                gui.drawString(matrices, Translator.plain(str), x, y, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            }
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.rep.select", new Object[0]), 1.0f, 120), 180, 20, 1.0f, 0x404040);
            this.scrollBar.draw(gui);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onClick(GuiBase guiB, int mX, int mY, int b) {
            super.onClick(guiB, mX, mY, b);
            ReputationManager reputationManager = ReputationManager.getInstance();
            GuiQuestBook gui = (GuiQuestBook)guiB;
            int start = this.scrollBar.isVisible(gui) ? Math.round((float)(reputationManager.size() - 10) * this.scrollBar.getScroll()) : 0;
            int end = Math.min(start + 10, reputationManager.size());
            List<Reputation> reputationList = reputationManager.getReputationList();
            for (int i = start; i < end; ++i) {
                int x = 20;
                int y = 20 + (i - start) * 20;
                String str = reputationList.get(i).getName();
                if (!gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY)) continue;
                this.bar.repId = reputationList.get(i).getId();
                this.save(guiB);
                this.close(guiB);
            }
            this.scrollBar.onClick(gui, mX, mY);
        }

        @Override
        public void onDrag(GuiBase gui, int mX, int mY) {
            this.scrollBar.onDrag(gui, mX, mY);
        }

        @Override
        public void onRelease(GuiBase gui, int mX, int mY) {
            this.scrollBar.onRelease(gui, mX, mY);
        }

        @Override
        public void onScroll(GuiBase gui, double mX, double mY, double scroll) {
            this.scrollBar.onScroll(gui, mX, mY, scroll);
        }

        @Override
        public void save(GuiBase gui) {
            if (this.isNew) {
                Quest.getQuestSets().get(this.bar.questSet).addRepBar(this.bar);
                SaveHelper.add(EditType.REPUTATION_BAR_ADD);
            } else {
                SaveHelper.add(EditType.REPUTATION_BAR_CHANGE);
            }
        }
    }
}

