/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.reputation;

import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.team.Team;
import net.minecraft.entity.player.PlayerEntity;

public class HaveReputationTask
extends ReputationTask<TaskData> {
    public HaveReputationTask(Quest parent, String description, String longDescription) {
        super(TaskData.class, parent, description, longDescription);
        this.register(EventTrigger.Type.OPEN_BOOK, EventTrigger.Type.REPUTATION_CHANGE);
    }

    private void checkReputation(PlayerEntity player) {
        if (this.parent.isEnabled(player) && this.parent.isAvailable(player) && this.isVisible(player) && !this.isCompleted(player) && this.isPlayerInRange(player)) {
            this.completeTask(player.func_110124_au());
            this.parent.sendUpdatedDataToTeam(player);
        }
    }

    @Override
    public float getCompletedRatio(Team team) {
        int count = this.parts.size();
        if (count == 0) {
            return 0.0f;
        }
        int valid = 0;
        for (ReputationTask.Part setting : this.parts) {
            if (!setting.isValid(team)) continue;
            ++valid;
        }
        return (float)valid / (float)count;
    }

    @Override
    public TaskData newQuestData() {
        return new TaskData();
    }

    @Override
    public void onUpdate(PlayerEntity player) {
    }

    @Override
    public void onOpenBook(EventTrigger.BookOpeningEvent event) {
        this.checkReputation(event.getPlayer());
    }

    @Override
    public void onReputationChange(EventTrigger.ReputationEvent event) {
        this.checkReputation(event.getPlayer());
    }
}

