/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.quests.ItemPrecision;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.client.ItemTaskGraphic;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemRequirementTask
extends QuestTask<ItemsTaskData> {
    private static final String ITEMS = "items";
    protected static final int LIMIT = 35;
    protected final PartList<Part> parts = new PartList<Part>(() -> new Part(), EditType.Type.TASK_ITEM, 35);

    public ItemRequirementTask(Quest parent, String description, String longDescription) {
        super(ItemsTaskData.class, parent, description, longDescription);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TaskGraphic createGraphic() {
        return new ItemTaskGraphic(this, this.parts);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(ITEMS, (JsonElement)this.parts.write(QuestTaskAdapter.ITEM_REQUIREMENT_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(JSONUtils.func_151213_a((JsonObject)object, (String)ITEMS, (JsonArray)new JsonArray()), QuestTaskAdapter.ITEM_REQUIREMENT_ADAPTER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setItem(Either<ItemStack, FluidStack> item, int amount, ItemPrecision precision, int id) {
        Part requirement = this.parts.getOrCreateForModify(id);
        item.ifLeft(itemStack -> {
            requirement.hasItem = true;
            requirement.fluid = null;
            requirement.stack = itemStack;
        }).ifRight(fluidStack -> {
            requirement.hasItem = false;
            requirement.fluid = fluidStack;
            requirement.stack = null;
        });
        requirement.required = amount;
        requirement.precision = precision;
        Part.access$102(requirement, null);
    }

    public int getProgress(PlayerEntity player, int id) {
        if (id >= this.parts.size()) {
            return 0;
        }
        return ((ItemsTaskData)this.getData(player)).getValue(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean mayUseFluids();

    public boolean increaseItems(NonNullList<ItemStack> itemsToConsume, UUID playerId) {
        if (!this.parent.isAvailable(playerId)) {
            return false;
        }
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        boolean updated = false;
        for (int i = 0; i < this.parts.size(); ++i) {
            Part item = this.parts.get(i);
            if (!item.hasItem || data.isDone(i, item)) continue;
            for (int j = 0; j < itemsToConsume.size(); ++j) {
                int amount;
                ItemStack stack = (ItemStack)itemsToConsume.get(j);
                if (!item.precision.areItemsSame(stack, item.stack) || (amount = Math.min(stack.func_190916_E(), item.required - data.getValue(i))) <= 0) continue;
                stack.func_190918_g(amount);
                if (stack.func_190916_E() == 0) {
                    itemsToConsume.set(j, (Object)ItemStack.field_190927_a);
                }
                data.setValue(i, data.getValue(i) + amount);
                updated = true;
            }
        }
        if (updated) {
            this.doCompletionCheck(data, playerId);
        }
        return updated;
    }

    public void doCompletionCheck(ItemsTaskData data, UUID playerId) {
        boolean isDone = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            Part item = this.parts.get(i);
            if (data.isDone(i, item)) continue;
            isDone = false;
            break;
        }
        if (isDone) {
            this.completeTask(playerId);
        }
        this.parent.sendUpdatedDataToTeam(playerId);
    }

    @Override
    public ItemsTaskData newQuestData() {
        return new ItemsTaskData(this.parts.size());
    }

    @Override
    public float getCompletedRatio(Team team) {
        ItemsTaskData data = (ItemsTaskData)this.getData(team);
        int done = 0;
        int total = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            int req = this.parts.get((int)i).required;
            done += Math.min(req, data.getValue(i));
            total += req;
        }
        return Math.max(0.0f, Math.min(1.0f, (float)done / (float)total));
    }

    @Override
    public void mergeProgress(UUID playerId, ItemsTaskData own, ItemsTaskData other) {
        own.merge(other);
        boolean completed = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (own.isDone(i, this.parts.get(i))) continue;
            completed = false;
            break;
        }
        if (completed) {
            this.completeTask(playerId);
        }
    }

    @Override
    public void setComplete(ItemsTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.setValue(i, this.parts.get((int)i).required);
        }
        data.completed = true;
    }

    public void switchPartStatus(int id, UUID playerId) {
        if (id >= 0 && id < this.parts.size()) {
            Part part = this.parts.get(id);
            ItemsTaskData qData = (ItemsTaskData)this.getData(playerId);
            if (qData.isDone(id, part)) {
                qData.setValue(id, 0);
                qData.completed = false;
                QuestingDataManager.getInstance().getQuestingData(playerId).getTeam().refreshData();
            } else {
                qData.setValue(id, part.required);
                this.doCompletionCheck(qData, playerId);
            }
            this.parent.sendUpdatedDataToTeam(playerId);
        }
    }

    @Override
    public void copyProgress(ItemsTaskData own, ItemsTaskData other) {
        own.update(other);
    }

    public static class Part {
        private static int CYCLE_TIME = 2;
        public FluidStack fluid;
        public int required;
        public boolean hasItem;
        private ItemStack stack = ItemStack.field_190927_a;
        private ItemPrecision precision = ItemPrecision.PRECISE;
        private ItemStack[] permutations;
        private int cycleAt = -1;
        private int current = 0;
        private int last;

        private Part() {
            this(ItemStack.field_190927_a, 1);
        }

        public Part(ItemStack stack, int required) {
            this.stack = stack;
            this.required = required;
            this.hasItem = true;
        }

        public Part(FluidStack fluid, int required) {
            this.fluid = fluid;
            this.required = required;
            this.hasItem = false;
        }

        public ItemPrecision getPrecision() {
            return this.precision;
        }

        public void setPrecision(ItemPrecision precision) {
            this.precision = precision;
            this.permutations = null;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
            this.permutations = null;
        }

        private void setPermutations() {
            if (this.stack == null) {
                return;
            }
            this.permutations = this.precision.getPermutations(this.stack);
            if (this.permutations != null && this.permutations.length > 0) {
                this.last = this.permutations.length - 1;
                this.cycleAt = -1;
            }
        }

        public ItemStack getPermutatedItem() {
            if (this.permutations == null && this.precision.hasPermutations()) {
                this.setPermutations();
            }
            if (this.permutations == null || this.permutations.length < 2) {
                return this.stack != null ? this.stack : ItemStack.field_190927_a;
            }
            int ticks = (int)(System.currentTimeMillis() / 1000L);
            if (this.cycleAt == -1) {
                this.cycleAt = ticks + CYCLE_TIME;
            }
            if (ticks >= this.cycleAt) {
                if (++this.current > this.last) {
                    this.current = 0;
                }
                while (ticks >= this.cycleAt) {
                    this.cycleAt += CYCLE_TIME;
                }
            }
            return this.permutations[this.current];
        }

        static /* synthetic */ ItemStack[] access$102(Part x0, ItemStack[] x1) {
            x0.permutations = x1;
            return x1;
        }
    }
}

