/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.item;

import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DetectItemTask
extends ItemRequirementTask {
    public DetectItemTask(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.register(EventTrigger.Type.CRAFTING, EventTrigger.Type.PICK_UP, EventTrigger.Type.OPEN_BOOK);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mayUseFluids() {
        return false;
    }

    @Override
    public void doCompletionCheck(ItemsTaskData data, UUID playerID) {
        boolean isDone = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part item = (ItemRequirementTask.Part)this.parts.get(i);
            if (data.isDone(i, item)) continue;
            data.setValue(i, 0);
            isDone = false;
        }
        if (isDone) {
            this.completeTask(playerID);
        }
        this.parent.sendUpdatedDataToTeam(playerID);
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        this.countItems(player, ItemStack.field_190927_a);
    }

    @Override
    public void onItemPickUp(PlayerEntity playerEntity, ItemStack stack) {
        this.countItems(playerEntity, stack);
    }

    @Override
    public void onOpenBook(EventTrigger.BookOpeningEvent event) {
        if (event.isRealName()) {
            this.countItems(event.getPlayer(), ItemStack.field_190927_a);
        }
    }

    @Override
    public void onCrafting(PlayerEntity player, ItemStack stack) {
        if (player != null) {
            if ((stack = stack.func_77946_l()).func_190916_E() == 0) {
                stack.func_190920_e(1);
            }
            this.countItems(player, stack);
        }
    }

    private void countItems(PlayerEntity player, ItemStack stack) {
        if (!player.func_130014_f_().field_72995_K) {
            NonNullList items = NonNullList.func_191197_a((int)(player.field_71071_by.field_70462_a.size() + 1), (Object)ItemStack.field_190927_a);
            Collections.copy(items, player.field_71071_by.field_70462_a);
            if (!stack.func_190926_b()) {
                items.set(items.size() - 1, (Object)stack);
            }
            this.countItems((NonNullList<ItemStack>)items, (ItemsTaskData)this.getData(player), player.func_110124_au());
        }
    }

    public void countItems(NonNullList<ItemStack> itemsToCount, ItemsTaskData data, UUID playerID) {
        if (!this.parent.isAvailable(playerID)) {
            return;
        }
        boolean updated = false;
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part item = (ItemRequirementTask.Part)this.parts.get(i);
            if (!item.hasItem || data.isDone(i, item)) continue;
            for (ItemStack stack : itemsToCount) {
                if (!item.getPrecision().areItemsSame(stack, item.getStack())) continue;
                int amount = Math.min(stack.func_190916_E(), item.required - data.getValue(i));
                data.setValue(i, data.getValue(i) + amount);
                updated = true;
            }
        }
        if (updated) {
            this.doCompletionCheck(data, playerID);
        }
    }

    @Override
    public boolean allowDetect() {
        return true;
    }
}

