/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.item;

import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import hardcorequesting.common.forge.util.Fraction;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConsumeItemTask
extends ItemRequirementTask {
    public ConsumeItemTask(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
    }

    public boolean increaseFluid(FluidStack fluidVolume, UUID playerId, boolean action) {
        boolean updated = false;
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        for (int i = 0; i < this.parts.size(); ++i) {
            Fraction amount;
            ItemRequirementTask.Part item = (ItemRequirementTask.Part)this.parts.get(i);
            if (item.fluid == null || data.isDone(i, item) || fluidVolume == null || fluidVolume.getFluid() == null || fluidVolume.getFluid() != item.fluid.getFluid()) continue;
            Fraction fraction = amount = fluidVolume.getAmount().isLessThan(Fraction.ofWhole(item.required - data.getValue(i))) ? fluidVolume.getAmount() : Fraction.ofWhole(item.required - data.getValue(i));
            if (action) {
                data.setValue(i, data.getValue(i) + amount.intValue());
            }
            fluidVolume.split(amount);
            updated = true;
            break;
        }
        if (action && updated) {
            this.doCompletionCheck(data, playerId);
        }
        return updated;
    }

    public boolean canTakeItem(ItemStack stack, UUID playerId) {
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part part = (ItemRequirementTask.Part)this.parts.get(i);
            if (!part.hasItem || !part.getPrecision().areItemsSame(part.getStack(), stack) || data.isDone(i, part)) continue;
            return true;
        }
        return false;
    }

    public boolean canTakeFluid(Fluid fluid, UUID playerId) {
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part part = (ItemRequirementTask.Part)this.parts.get(i);
            if (part.fluid == null || fluid != part.fluid.getFluid() || data.isDone(i, part)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        if (this.increaseItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, player.func_110124_au())) {
            player.field_71071_by.func_70296_d();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mayUseFluids() {
        return true;
    }

    @Override
    public boolean allowManual() {
        return true;
    }
}

