/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.TameTaskData;
import hardcorequesting.common.forge.quests.task.client.TameMobsTaskGraphic;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TameMobsTask
extends IconLayoutTask<Part, TameTaskData> {
    private static final String TAME = "part";
    public static final ResourceLocation ABSTRACT_HORSE = new ResourceLocation("abstracthorse");

    public TameMobsTask(Quest parent, String description, String longDescription) {
        super(TameTaskData.class, EditType.Type.MONSTER, parent, description, longDescription);
        this.register(EventTrigger.Type.ANIMAL_TAME);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TaskGraphic createGraphic() {
        return new TameMobsTaskGraphic(this, this.parts);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInfo(int id, String entityId, int amount) {
        SpawnEggItem egg;
        EntityType entityType;
        Part part = (Part)this.parts.getOrCreateForModify(id);
        part.setTame(entityId);
        part.setCount(amount);
        if (entityId != null && (part.getIconStack().func_190926_b() || part.getIconStack().func_77973_b() instanceof SpawnEggItem) && (entityType = (EntityType)Registry.field_212629_r.func_82594_a(new ResourceLocation(entityId))) != null && (egg = SpawnEggItem.func_200889_b((EntityType)entityType)) != null) {
            part.setIconStack(new ItemStack((IItemProvider)egg));
        }
    }

    public int tamed(int id, PlayerEntity player) {
        return ((TameTaskData)this.getData(player)).getValue(id);
    }

    @Override
    public TameTaskData newQuestData() {
        return new TameTaskData(this.parts.size());
    }

    @Override
    public void onUpdate(PlayerEntity player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        TameTaskData data = (TameTaskData)this.getData(team);
        int tamed = 0;
        int total = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            int req = ((Part)this.parts.get(i)).count;
            tamed += Math.min(req, data.getValue(i));
            total += req;
        }
        return (float)tamed / (float)total;
    }

    @Override
    public void mergeProgress(UUID uuid, TameTaskData own, TameTaskData other) {
        own.merge(other);
        boolean all = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (own.getValue(i) >= ((Part)this.parts.get(i)).count) continue;
            all = false;
            break;
        }
        if (all) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void setComplete(TameTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.setValue(i, ((Part)this.parts.get(i)).count);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(TameTaskData own, TameTaskData other) {
        own.update(other);
    }

    @Override
    public void onAnimalTame(PlayerEntity tamer, Entity entity) {
        if (tamer != null && this.parent.isEnabled(tamer) && this.parent.isAvailable(tamer) && this.isVisible(tamer) && !this.isCompleted(tamer)) {
            TameTaskData data = (TameTaskData)this.getData(tamer);
            boolean updated = false;
            for (int i = 0; i < this.parts.size(); ++i) {
                Part part = (Part)this.parts.get(i);
                if (part.count <= data.getValue(i) || part.mobId == null) continue;
                if (part.mobId.equals(ABSTRACT_HORSE.toString())) {
                    if (!(entity instanceof AbstractHorseEntity)) continue;
                    data.setValue(i, data.getValue(i) + 1);
                    updated = true;
                    continue;
                }
                EntityType type = (EntityType)Registry.field_212629_r.func_82594_a(new ResourceLocation(part.mobId));
                if (type == null || !type.equals(entity.func_200600_R())) continue;
                data.setValue(i, data.getValue(i) + 1);
                updated = true;
            }
            if (updated) {
                boolean done = true;
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (this.tamed(i, tamer) >= part.count) continue;
                    done = false;
                    break;
                }
                if (done) {
                    this.completeTask(tamer.func_110124_au());
                }
                this.parent.sendUpdatedDataToTeam(tamer);
            }
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(TAME, (JsonElement)this.parts.write(QuestTaskAdapter.TAME_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(JSONUtils.func_151213_a((JsonObject)object, (String)TAME, (JsonArray)new JsonArray()), QuestTaskAdapter.TAME_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        private String mobId;
        private int count = 1;

        public String getTame() {
            return this.mobId;
        }

        public void setTame(String part) {
            this.mobId = part;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

