/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.MobTaskData;
import hardcorequesting.common.forge.quests.task.client.KillMobsTaskGraphic;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KillMobsTask
extends IconLayoutTask<Part, MobTaskData> {
    private static final String MOBS = "mobs";

    public KillMobsTask(Quest parent, String description, String longDescription) {
        super(MobTaskData.class, EditType.Type.MONSTER, parent, description, longDescription);
        this.register(EventTrigger.Type.DEATH);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TaskGraphic createGraphic() {
        return new KillMobsTaskGraphic(this, this.parts);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    public static PlayerEntity getKiller(DamageSource source) {
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity) {
            return (PlayerEntity)entity;
        }
        return null;
    }

    public void setInfo(int id, ResourceLocation mobId, int amount) {
        Part part = (Part)this.parts.getOrCreateForModify(id);
        part.setMob(mobId);
        part.setCount(amount);
    }

    public int killed(int id, PlayerEntity player) {
        return ((MobTaskData)this.getData(player)).getValue(id);
    }

    @Override
    public MobTaskData newQuestData() {
        return new MobTaskData(this.parts.size());
    }

    @Override
    public void onUpdate(PlayerEntity player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        MobTaskData data = (MobTaskData)this.getData(team);
        int killed = 0;
        int total = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            int req = ((Part)this.parts.get(i)).count;
            killed += Math.min(req, data.getValue(i));
            total += req;
        }
        return (float)killed / (float)total;
    }

    @Override
    public void mergeProgress(UUID playerID, MobTaskData own, MobTaskData other) {
        own.merge(other);
        boolean all = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (own.getValue(i) >= ((Part)this.parts.get(i)).count) continue;
            all = false;
            break;
        }
        if (all) {
            this.completeTask(playerID);
        }
    }

    @Override
    public void setComplete(MobTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.setValue(i, ((Part)this.parts.get(i)).count);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(MobTaskData own, MobTaskData other) {
        own.update(other);
    }

    @Override
    public void onLivingDeath(LivingEntity entity, DamageSource source) {
        PlayerEntity killer = KillMobsTask.getKiller(source);
        if (killer != null && this.parent.isEnabled(killer) && this.parent.isAvailable(killer) && this.isVisible(killer) && !this.isCompleted(killer)) {
            MobTaskData data = (MobTaskData)this.getData(killer);
            boolean updated = false;
            for (int i = 0; i < this.parts.size(); ++i) {
                EntityType type;
                Part part = (Part)this.parts.get(i);
                if (part.count <= data.getValue(i) || (type = (EntityType)Registry.field_212629_r.func_82594_a(part.mobId)) == null || !type.equals(entity.func_200600_R())) continue;
                data.setValue(i, data.getValue(i) + 1);
                updated = true;
            }
            if (updated) {
                boolean done = true;
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (this.killed(i, killer) >= part.count) continue;
                    done = false;
                    break;
                }
                if (done) {
                    this.completeTask(killer.func_110124_au());
                }
                this.parent.sendUpdatedDataToTeam(killer);
            }
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(MOBS, (JsonElement)this.parts.write(QuestTaskAdapter.MOB_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(JSONUtils.func_151213_a((JsonObject)object, (String)MOBS, (JsonArray)new JsonArray()), QuestTaskAdapter.MOB_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        private ResourceLocation mobId = Registry.field_212629_r.func_212609_b();
        private int count = 1;

        public ResourceLocation getMob() {
            return this.mobId;
        }

        public void setMob(ResourceLocation mobId) {
            this.mobId = Registry.field_212629_r.func_241873_b(mobId).isPresent() ? mobId : Registry.field_212629_r.func_212609_b();
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

