/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.AdvancementTaskData;
import hardcorequesting.common.forge.quests.task.client.AdvancementTaskGraphic;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GetAdvancementTask
extends IconLayoutTask<Part, AdvancementTaskData> {
    private static final String ADVANCEMENTS = "advancements";

    public GetAdvancementTask(Quest parent, String description, String longDescription) {
        super(AdvancementTaskData.class, EditType.Type.ADVANCEMENT, parent, description, longDescription);
        this.register(EventTrigger.Type.ADVANCEMENT, EventTrigger.Type.OPEN_BOOK);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TaskGraphic createGraphic() {
        return new AdvancementTaskGraphic(this, this.parts);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    public boolean advanced(int id, PlayerEntity player) {
        return ((AdvancementTaskData)this.getData(player)).getValue(id);
    }

    public void setAdvancement(int id, String advancement) {
        ((Part)this.parts.getOrCreateForModify(id)).setAdvancement(advancement);
    }

    @Override
    public AdvancementTaskData newQuestData() {
        return new AdvancementTaskData(this.parts.size());
    }

    @Override
    public void onAdvancement(ServerPlayerEntity playerEntity) {
        this.checkAdvancement((PlayerEntity)playerEntity);
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        this.checkAdvancement(player);
    }

    private void checkAdvancement(PlayerEntity player) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K && !this.isCompleted(player) && player.func_184102_h() != null) {
            AdvancementTaskData data = (AdvancementTaskData)this.getData(player);
            boolean completed = true;
            AdvancementManager manager = player.func_184102_h().func_191949_aK();
            PlayerAdvancements playerAdvancements = player.func_184102_h().func_184103_al().func_192054_h((ServerPlayerEntity)player);
            for (int i = 0; i < this.parts.size(); ++i) {
                Part part;
                if (data.getValue(i) || (part = (Part)this.parts.get(i)) == null || part.getName() == null || part.getAdvancement() == null) continue;
                ResourceLocation advResource = new ResourceLocation(part.getAdvancement());
                Advancement advAdvancement = manager.func_192778_a(advResource);
                if (advAdvancement == null) {
                    completed = false;
                    continue;
                }
                AdvancementProgress progress = playerAdvancements.func_192747_a(advAdvancement);
                if (progress.func_192105_a()) {
                    data.complete(i);
                    continue;
                }
                completed = false;
            }
            if (completed && this.parts.size() > 0) {
                this.completeTask(player.func_110124_au());
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    @Override
    public float getCompletedRatio(Team team) {
        return ((AdvancementTaskData)this.getData(team)).getCompletedRatio(this.parts.size());
    }

    @Override
    public void mergeProgress(UUID uuid, AdvancementTaskData own, AdvancementTaskData other) {
        own.mergeResult(other);
        if (own.areAllCompleted(this.parts.size())) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void setComplete(AdvancementTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.complete(i);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(AdvancementTaskData own, AdvancementTaskData other) {
        own.update(other);
    }

    @Override
    public boolean allowDetect() {
        return true;
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(ADVANCEMENTS, (JsonElement)this.parts.write(QuestTaskAdapter.ADVANCEMENT_TASK_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(JSONUtils.func_151213_a((JsonObject)object, (String)ADVANCEMENTS, (JsonArray)new JsonArray()), QuestTaskAdapter.ADVANCEMENT_TASK_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        private Visibility visible = Visibility.FULL;
        private String adv_name;

        public Visibility getVisible() {
            return this.visible;
        }

        public void setVisible(Visibility visible) {
            this.visible = visible;
        }

        public void setAdvancement(String name) {
            this.adv_name = name;
        }

        public String getAdvancement() {
            return this.adv_name;
        }

        public void setAdvancement(ResourceLocation name) {
            this.setAdvancement(name.toString());
        }
    }

    public static enum Visibility {
        FULL("Full"),
        NONE("None");

        private final String id;

        private Visibility(String id) {
            this.id = id;
        }

        public String getName() {
            return Translator.get("hqm.locationMenu.vis" + this.id + ".title", new Object[0]);
        }

        public String getDescription() {
            return Translator.get("hqm.locationMenu.vis" + this.id + ".desc", new Object[0]);
        }
    }
}

