/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickMobMenu;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TameMobsTaskGraphic
extends IconTaskGraphic<TameMobsTask.Part> {
    private final TameMobsTask task;

    public TameMobsTaskGraphic(TameMobsTask task, PartList<TameMobsTask.Part> parts) {
        super(task, parts);
        this.task = task;
    }

    @Override
    protected void drawElementText(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, TameMobsTask.Part part, int index, int x, int y) {
        int tamed = this.task.tamed(index, player);
        if (tamed == part.getCount()) {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.tameTask.allTamed", GuiColor.GREEN, new Object[0]), x, y, 0.7f, 0x404040);
        } else {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.tameTask.partTames", tamed, 100 * tamed / part.getCount()), x, y, 0.7f, 0x404040);
        }
        gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.tameTask.totalTames", part.getCount()), x, y + 6, 0.7f, 0x404040);
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, TameMobsTask.Part part, int id) {
        if (mode == EditMode.MOB) {
            PickMobMenu.display(gui, player, part.getTame() == null ? null : ResourceLocation.func_208304_a((String)part.getTame()), part.getCount(), "tameTask", PickMobMenu.EXTRA_TAME_ENTRIES, result -> this.task.setInfo(id, result.getMobId().toString(), result.getAmount()));
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }
}

