/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuReputationSetting;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.ListTaskGraphic;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReputationTaskGraphic
extends ListTaskGraphic<ReputationTask.Part> {
    private static final int OFFSET_Y = 27;
    private final int startOffsetY;
    private final ReputationTask<?> task;

    public ReputationTaskGraphic(ReputationTask<?> task, PartList<ReputationTask.Part> parts) {
        super(parts);
        this.task = task;
        this.startOffsetY = 0;
    }

    protected ReputationTaskGraphic(ReputationTask<?> task, PartList<ReputationTask.Part> parts, int startOffsetY) {
        super(parts);
        this.task = task;
        this.startOffsetY = startOffsetY;
    }

    @Override
    protected List<Positioned<ReputationTask.Part>> positionParts(List<ReputationTask.Part> parts) {
        ArrayList<Positioned<ReputationTask.Part>> list = new ArrayList<Positioned<ReputationTask.Part>>(parts.size());
        int x = 180;
        int y = 95 + this.startOffsetY;
        for (ReputationTask.Part part : parts) {
            list.add(new Positioned<ReputationTask.Part>(x, y, part));
            y += 27;
        }
        return list;
    }

    protected PlayerEntity getPlayerForRender(PlayerEntity player) {
        return player;
    }

    @Override
    protected List<ITextProperties> drawPart(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, ReputationTask.Part part, int id, int x, int y, int mX, int mY) {
        gui.applyColor(-1);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        if (part.getReputation() == null) {
            gui.drawRect(x + 0, y + 5, 0, 101, 125, 3);
            return null;
        }
        String text = part.getReputation().draw(matrices, gui, x, y, mX, mY, null, this.getPlayerForRender(player), true, part.getLower(), part.getUpper(), part.isInverted(), null, null, this.task.isCompleted(player));
        return text == null ? null : Collections.singletonList(Translator.plain(text));
    }

    @Override
    protected boolean isInPartBounds(GuiQuestBook gui, int mX, int mY, Positioned<ReputationTask.Part> pos) {
        return gui.inBounds(pos.getX(), pos.getY(), 125, 20, mX, mY);
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, ReputationTask.Part part, int id) {
        if (gui.getCurrentMode() == EditMode.REPUTATION_TASK) {
            gui.setEditMenu(new GuiEditMenuReputationSetting(gui, player, this.task, id, part));
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }
}

