/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.LocationMenu;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LocationTaskGraphic
extends IconTaskGraphic<VisitLocationTask.Part> {
    private final VisitLocationTask task;

    public LocationTaskGraphic(VisitLocationTask task, PartList<VisitLocationTask.Part> parts) {
        super(task, parts);
        this.task = task;
    }

    @Override
    protected void drawElementText(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, VisitLocationTask.Part part, int index, int x, int y) {
        if (this.task.visited(index, player)) {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.locationMenu.visited", GuiColor.GREEN, new Object[0]), x, y, 0.7f, 0x404040);
        } else if (part.getVisibility().doShowCoordinate()) {
            int row = 0;
            if (part.getRadius() >= 0) {
                gui.drawString(matrices, Translator.plain("(" + part.getPosition().func_229422_x_() + ")"), x, y, 0.7f, 0x404040);
                ++row;
            }
            if (Objects.equals(player.func_130014_f_().func_234923_W_().func_240901_a_().toString(), part.getDimension())) {
                if (part.getRadius() >= 0) {
                    int distance = (int)player.func_70092_e((double)part.getPosition().func_177958_n() + 0.5, (double)part.getPosition().func_177956_o() + 0.5, (double)part.getPosition().func_177952_p() + 0.5);
                    IFormattableTextComponent str = Translator.translatable("hqm.locationMenu.mAway", distance);
                    if (part.getVisibility().doShowRadius()) {
                        str = ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{str, Translator.plain(" ["), Translator.translatable("hqm.locationMenu.mRadius", part.getRadius()), Translator.plain("]")});
                    }
                    gui.drawString(matrices, (ITextProperties)str, x, y + 6 * row, 0.7f, 0x404040);
                }
            } else {
                gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.locationMenu.wrongDim", new Object[0]), x, y + 6 * row, 0.7f, 0x404040);
            }
        }
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, VisitLocationTask.Part part, int id) {
        if (mode == EditMode.LOCATION) {
            LocationMenu.display(gui, player, part.getVisibility(), part.getPosition(), part.getRadius(), part.getDimension(), result -> this.task.setInfo(id, result.getVisibility(), result.getPos(), result.getRadius(), result.getDimension()));
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }
}

