/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.util.Positioned;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ListTaskGraphic<Part>
implements TaskGraphic {
    protected final PartList<Part> parts;

    public ListTaskGraphic(PartList<Part> parts) {
        this.parts = parts;
    }

    protected abstract List<Positioned<Part>> positionParts(List<Part> var1);

    protected abstract List<ITextProperties> drawPart(MatrixStack var1, GuiQuestBook var2, PlayerEntity var3, Part var4, int var5, int var6, int var7, int var8, int var9);

    protected abstract boolean isInPartBounds(GuiQuestBook var1, int var2, int var3, Positioned<Part> var4);

    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, Part part, int id) {
        if (mode == EditMode.DELETE) {
            this.parts.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public void draw(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, int mX, int mY) {
        List<Positioned<Part>> renderElements = this.positionParts(this.parts.getShownElements());
        List<ITextProperties> tooltip = null;
        for (int i = 0; i < renderElements.size(); ++i) {
            Positioned<Part> pos = renderElements.get(i);
            Part part = pos.getElement();
            List<ITextProperties> newTooltip = this.drawPart(matrices, gui, player, part, i, pos.getX(), pos.getY(), mX, mY);
            if (newTooltip == null) continue;
            tooltip = newTooltip;
        }
        if (tooltip != null) {
            gui.renderTooltipL(matrices, tooltip, gui.getLeft() + mX, gui.getTop() + mY);
        }
    }

    @Override
    public void onClick(GuiQuestBook gui, PlayerEntity player, int mX, int mY, int b) {
        int id;
        if (Quest.canQuestsBeEdited() && gui.getCurrentMode() != EditMode.NORMAL && (id = this.getClickedPart(gui, mX, mY)) >= 0) {
            this.handlePartClick(gui, player, gui.getCurrentMode(), this.parts.getShownElements().get(id), id);
        }
    }

    protected final int getClickedPart(GuiQuestBook gui, int mX, int mY) {
        List<Positioned<Part>> elements = this.positionParts(this.parts.getShownElements());
        for (int i = 0; i < elements.size(); ++i) {
            if (!this.isInPartBounds(gui, mX, mY, elements.get(i))) continue;
            return i;
        }
        return -1;
    }
}

