/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.ReputationTaskGraphic;
import hardcorequesting.common.forge.quests.task.reputation.KillReputationTask;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KillReputationTaskGraphic
extends ReputationTaskGraphic {
    private final KillReputationTask task;

    public KillReputationTaskGraphic(KillReputationTask task, PartList<ReputationTask.Part> parts) {
        super(task, parts, 20);
        this.task = task;
    }

    @Override
    protected PlayerEntity getPlayerForRender(PlayerEntity player) {
        return null;
    }

    @Override
    public void draw(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, int mX, int mY) {
        super.draw(matrices, gui, player, mX, mY);
        int killCount = this.task.getKills(player.func_110124_au());
        if (Quest.canQuestsBeEdited()) {
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.pluralTranslated(this.task.getKillsRequirement() != 1, "hqm.repKil.kills", killCount, this.task.getKillsRequirement()), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        } else {
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)(killCount == this.task.getKillsRequirement() ? Translator.pluralTranslated(this.task.getKillsRequirement() != 1, "hqm.repKil.killCount", GuiColor.GREEN, this.task.getKillsRequirement()) : Translator.translatable("hqm.repKil.killCountOutOf", killCount, this.task.getKillsRequirement())), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        }
    }
}

