/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickMobMenu;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KillMobsTaskGraphic
extends IconTaskGraphic<KillMobsTask.Part> {
    private final KillMobsTask task;

    public KillMobsTaskGraphic(KillMobsTask task, PartList<KillMobsTask.Part> parts) {
        super(task, parts);
        this.task = task;
    }

    @Override
    protected void drawElementText(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, KillMobsTask.Part part, int index, int x, int y) {
        int killed = this.task.killed(index, player);
        if (killed == part.getCount()) {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.mobTask.allKilled", GuiColor.GREEN, new Object[0]), x, y, 0.7f, 0x404040);
        } else {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.mobTask.partKills", killed, 100 * killed / part.getCount()), x, y, 0.7f, 0x404040);
        }
        gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.mobTask.totalKills", part.getCount()), x, y + 6, 0.7f, 0x404040);
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, KillMobsTask.Part part, int id) {
        if (mode == EditMode.MOB) {
            PickMobMenu.display(gui, player, part.getMob(), part.getCount(), "mobTask", result -> this.task.setInfo(id, result.getMobId(), result.getAmount()));
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }
}

