/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Either;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.ListTaskGraphic;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTaskGraphic
extends ListTaskGraphic<ItemRequirementTask.Part> {
    private static final int MAX_X = 300;
    private static final int OFFSET = 20;
    private static final int SIZE = 18;
    private static final int TEXT_HEIGHT = 9;
    private int lastClicked;
    private final ItemRequirementTask task;

    public ItemTaskGraphic(ItemRequirementTask task, PartList<ItemRequirementTask.Part> parts) {
        super(parts);
        this.task = task;
    }

    @Override
    protected List<Positioned<ItemRequirementTask.Part>> positionParts(List<ItemRequirementTask.Part> parts) {
        ArrayList<Positioned<ItemRequirementTask.Part>> list = new ArrayList<Positioned<ItemRequirementTask.Part>>(parts.size());
        int x = 180;
        int y = 95;
        for (ItemRequirementTask.Part item : parts) {
            list.add(new Positioned<ItemRequirementTask.Part>(x, y, item));
            if ((x += 20) <= 300) continue;
            x = 180;
            y += 20;
        }
        return list;
    }

    @Override
    protected List<ITextProperties> drawPart(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, ItemRequirementTask.Part part, int id, int x, int y, int mX, int mY) {
        if (part.hasItem) {
            gui.drawItemStack(part.getPermutatedItem(), x, y, mX, mY, false);
        } else if (part.fluid != null) {
            gui.drawFluid(part.fluid, matrices, x, y, mX, mY);
        }
        ITextProperties progressText = Translator.plain(this.task.getProgress(player, id) * 100 / part.required + "%");
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 0.0, 200.0);
        float textSize = 0.8f;
        gui.drawStringWithShadow(matrices, progressText, (int)((float)(x + 18) - (float)gui.getStringWidth(progressText) * textSize), (int)((float)(y + 18 - (part.hasItem && !part.getStack().func_190926_b() && part.getStack().func_190916_E() != 1 ? 9 : 0)) - 9.0f * textSize + 2.0f), textSize, this.task.getProgress(player, id) == part.required ? 0x308030 : 0xFFFFFF);
        matrices.func_227865_b_();
        if (gui.inBounds(x, y, 18, 18, mX, mY)) {
            GuiQuestBook.setSelectedStack(part.getStack());
            ItemStack stack = part.getStack();
            ArrayList<ITextProperties> str = new ArrayList<ITextProperties>();
            if (part.fluid != null) {
                ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
                str.add((ITextProperties)new StringTextComponent(part.fluid.getName().getString()));
                if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                    String entryId = Registry.field_212619_h.func_177774_c((Object)part.fluid.getFluid()).toString();
                    list.add(new StringTextComponent(entryId).func_240699_a_(TextFormatting.DARK_GRAY));
                }
                str.addAll(list);
            } else if (stack != null && !stack.func_190926_b()) {
                str.addAll(gui.func_231151_a_(stack));
            }
            str.add(ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{Translator.translatable("hqm.questBook.itemRequirementProgress", new Object[0]), Translator.plain(": " + this.task.getProgress(player, id) + "/" + part.required)}));
            if (part.fluid == null && Quest.canQuestsBeEdited()) {
                str.add(ITextProperties.field_240651_c_);
                str.add((ITextProperties)Translator.text(part.getPrecision().getName(), GuiColor.GRAY));
            }
            if (gui.isOpBook && Screen.func_231173_s_()) {
                if (this.task.getProgress(player, id) == part.required) {
                    str.addAll(Arrays.asList(ITextProperties.field_240651_c_, ITextProperties.field_240651_c_, Translator.translatable("hqm.questBook.resetTask", GuiColor.RED, new Object[0])));
                } else {
                    str.addAll(Arrays.asList(ITextProperties.field_240651_c_, ITextProperties.field_240651_c_, Translator.translatable("hqm.questBook.completeTask", GuiColor.ORANGE, new Object[0])));
                }
            }
            return str;
        }
        return null;
    }

    @Override
    protected boolean isInPartBounds(GuiQuestBook gui, int mX, int mY, Positioned<ItemRequirementTask.Part> pos) {
        return gui.inBounds(pos.getX(), pos.getY(), 18, 18, mX, mY);
    }

    @Override
    public void onClick(GuiQuestBook gui, PlayerEntity player, int mX, int mY, int b) {
        if (gui.isOpBook && Screen.func_231173_s_()) {
            int id = this.getClickedPart(gui, mX, mY);
            if (id >= 0) {
                OPBookHelper.reverseRequirementCompletion(this.task, id, player);
            }
        } else if (Quest.canQuestsBeEdited()) {
            super.onClick(gui, player, mX, mY, b);
        }
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, ItemRequirementTask.Part part, int id) {
        boolean doubleClick = false;
        int lastDiff = player.field_70173_aa - this.lastClicked;
        if (lastDiff < 0) {
            this.lastClicked = player.field_70173_aa;
        } else if (lastDiff < 6) {
            doubleClick = true;
        } else {
            this.lastClicked = player.field_70173_aa;
        }
        if (gui.getCurrentMode() == EditMode.ITEM || doubleClick) {
            if (this.task.mayUseFluids()) {
                PickItemMenu.display(gui, player, part.hasItem ? Either.left((Object)part.getStack()) : Either.right((Object)part.fluid), PickItemMenu.Type.ITEM_FLUID, part.required, part.getPrecision(), result -> this.task.setItem((Either<ItemStack, FluidStack>)((Either)result.get()), result.getAmount(), result.getPrecision(), id));
            } else {
                PickItemMenu.display(gui, player, part.getStack(), PickItemMenu.Type.ITEM, part.required, part.getPrecision(), result -> this.task.setItem((Either<ItemStack, FluidStack>)Either.left(result.get()), result.getAmount(), result.getPrecision(), id));
            }
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }
}

