/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.ListTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class IconTaskGraphic<Part extends IconLayoutTask.Part>
extends ListTaskGraphic<Part> {
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;
    private final IconLayoutTask<Part, ?> task;

    public IconTaskGraphic(IconLayoutTask<Part, ?> task, PartList<Part> parts) {
        super(parts);
        this.task = task;
    }

    protected abstract void drawElementText(MatrixStack var1, GuiQuestBook var2, PlayerEntity var3, Part var4, int var5, int var6, int var7);

    @Override
    protected List<Positioned<Part>> positionParts(List<Part> parts) {
        ArrayList<Positioned<Part>> list = new ArrayList<Positioned<Part>>(parts.size());
        int x = 180;
        int y = 95;
        for (IconLayoutTask.Part part : parts) {
            list.add(new Positioned<IconLayoutTask.Part>(x, y, part));
            y += 30;
        }
        return list;
    }

    @Override
    protected List<ITextProperties> drawPart(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, Part part, int id, int x, int y, int mX, int mY) {
        int textX = x + 23;
        int textY = y + 0;
        gui.drawItemStack(((IconLayoutTask.Part)part).getIconStack(), x, y, mX, mY, false);
        gui.drawString(matrices, Translator.plain(((IconLayoutTask.Part)part).getName()), textX, textY, 0x404040);
        this.drawElementText(matrices, gui, player, part, id, textX + 0, textY + 9);
        return null;
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, Part part, int id) {
        if (mode == EditMode.ITEM) {
            PickItemMenu.display(gui, player, ((IconLayoutTask.Part)part).getIconStack(), PickItemMenu.Type.ITEM, result -> this.task.setIcon(id, (ItemStack)result.get()));
            return true;
        }
        if (mode == EditMode.RENAME) {
            TextMenu.display(gui, player, ((IconLayoutTask.Part)part).getName(), 110, result -> this.task.setName(id, (String)result));
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }

    @Override
    protected boolean isInPartBounds(GuiQuestBook gui, int mX, int mY, Positioned<Part> pos) {
        return gui.inBounds(pos.getX(), pos.getY(), 18, 18, mX, mY);
    }
}

