/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.CompleteQuestTask;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.ListTaskGraphic;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompleteQuestTaskGraphic
extends ListTaskGraphic<CompleteQuestTask.Part> {
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;
    private final CompleteQuestTask task;

    public CompleteQuestTaskGraphic(CompleteQuestTask task, PartList<CompleteQuestTask.Part> parts) {
        super(parts);
        this.task = task;
    }

    @Override
    protected List<Positioned<CompleteQuestTask.Part>> positionParts(List<CompleteQuestTask.Part> parts) {
        ArrayList<Positioned<CompleteQuestTask.Part>> list = new ArrayList<Positioned<CompleteQuestTask.Part>>(parts.size());
        int x = 180;
        int y = 95;
        for (CompleteQuestTask.Part part : parts) {
            list.add(new Positioned<CompleteQuestTask.Part>(x, y, part));
            y += 30;
        }
        return list;
    }

    @Override
    protected List<ITextProperties> drawPart(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, CompleteQuestTask.Part part, int id, int x, int y, int mX, int mY) {
        gui.drawItemStack(part.getIconStack(), x, y, mX, mY, false);
        if (part.getQuest() != null) {
            gui.drawString(matrices, Translator.plain(part.getName()), x + 23, y + 0, 0x404040);
            if (this.task.completed(id, player)) {
                gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.completedMenu.visited", GuiColor.GREEN, new Object[0]), x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            }
        } else {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.completionTask.firstline", GuiColor.RED, new Object[0]), x + 23, y + 0, 0x404040);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.completionTask.secondline", GuiColor.RED, new Object[0]), x + 23, y + 0 + 9, 0x404040);
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.completionTask.thirdline", GuiColor.RED, new Object[0]), x + 23, y + 0 + 18, 0x404040);
        }
        return null;
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, CompleteQuestTask.Part part, int id) {
        if (super.handlePartClick(gui, player, mode, part, id)) {
            return true;
        }
        if (Quest.speciallySelectedQuestId != null) {
            ((CompleteQuestTask.Part)this.parts.getOrCreateForModify(id)).setQuest(Quest.speciallySelectedQuestId);
            SaveHelper.add(EditType.COMPLETE_CHECK_CHANGE);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isInPartBounds(GuiQuestBook gui, int mX, int mY, Positioned<CompleteQuestTask.Part> pos) {
        return gui.inBounds(pos.getX(), pos.getY(), 18, 18, mX, mY);
    }
}

