/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickAdvancementMenu;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.client.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.GetAdvancementTask;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementTaskGraphic
extends IconTaskGraphic<GetAdvancementTask.Part> {
    private final GetAdvancementTask task;

    public AdvancementTaskGraphic(GetAdvancementTask task, PartList<GetAdvancementTask.Part> parts) {
        super(task, parts);
        this.task = task;
    }

    @Override
    protected void drawElementText(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, GetAdvancementTask.Part part, int id, int x, int y) {
        if (this.task.advanced(id, player)) {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.advancementMenu.visited", GuiColor.GREEN, new Object[0]), x, y, 0.7f, 0x404040);
        }
    }

    @Override
    protected boolean handlePartClick(GuiQuestBook gui, PlayerEntity player, EditMode mode, GetAdvancementTask.Part part, int id) {
        if (mode == EditMode.LOCATION) {
            PickAdvancementMenu.display(gui, player, part.getAdvancement(), result -> this.task.setAdvancement(id, (String)result));
            return true;
        }
        return super.handlePartClick(gui, player, mode, part, id);
    }
}

