/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.CompleteQuestTask;
import hardcorequesting.common.forge.quests.task.DeathTask;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.icon.GetAdvancementTask;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.quests.task.item.BreakBlockTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemQDSTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import hardcorequesting.common.forge.quests.task.item.CraftingTask;
import hardcorequesting.common.forge.quests.task.item.DetectItemTask;
import hardcorequesting.common.forge.quests.task.item.PlaceBlockTask;
import hardcorequesting.common.forge.quests.task.reputation.HaveReputationTask;
import hardcorequesting.common.forge.quests.task.reputation.KillReputationTask;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.lang.reflect.Constructor;

public enum TaskType {
    CONSUME(ConsumeItemTask.class, "consume"),
    CRAFT(CraftingTask.class, "craft"),
    LOCATION(VisitLocationTask.class, "location"),
    CONSUME_QDS(ConsumeItemQDSTask.class, "consumeQDS"),
    DETECT(DetectItemTask.class, "detect"),
    KILL(KillMobsTask.class, "kill"),
    TAME(TameMobsTask.class, "tame"),
    DEATH(DeathTask.class, "death"),
    REPUTATION(HaveReputationTask.class, "reputation"),
    REPUTATION_KILL(KillReputationTask.class, "reputationKill"),
    ADVANCEMENT(GetAdvancementTask.class, "advancement"),
    COMPLETION(CompleteQuestTask.class, "completion"),
    BLOCK_BREAK(BreakBlockTask.class, "break"),
    BLOCK_PLACE(PlaceBlockTask.class, "place");

    private final Class<? extends QuestTask<?>> clazz;
    private final String id;

    private TaskType(Class<? extends QuestTask<?>> clazz, String id) {
        this.clazz = clazz;
        this.id = id;
    }

    public static TaskType getType(Class<?> clazz) {
        for (TaskType type : TaskType.values()) {
            if (type.clazz != clazz) continue;
            return type;
        }
        return CONSUME;
    }

    public QuestTask<?> addTask(Quest quest) {
        QuestTask<?> prev = quest.getTasks().size() > 0 ? quest.getTasks().get(quest.getTasks().size() - 1) : null;
        try {
            Constructor<QuestTask<?>> ex = this.clazz.getConstructor(Quest.class, String.class, String.class);
            QuestTask<?> task = ex.newInstance(quest, this.getName(), this.getDescription());
            if (prev != null) {
                task.addRequirement(prev);
            }
            quest.getTasks().add(task);
            SaveHelper.add(EditType.TASK_CREATE);
            return task;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLangKeyDescription() {
        return "hqm.taskType." + this.id + ".desc";
    }

    public String getLangKeyName() {
        return "hqm.taskType." + this.id + ".title";
    }

    public String getDescription() {
        return Translator.get(this.getLangKeyDescription(), new Object[0]);
    }

    public String getName() {
        return Translator.get(this.getLangKeyName(), new Object[0]);
    }
}

