/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.util.Translator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuestTask<Data extends TaskData> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<Data> dataType;
    public String description;
    protected Quest parent;
    private final List<QuestTask<?>> requirements;
    private String longDescription;
    private int id;
    private List<ITextProperties> cachedDescription;
    @OnlyIn(value=Dist.CLIENT)
    private TaskGraphic graphic;

    public QuestTask(Class<Data> dataType, Quest parent, String description, String longDescription) {
        this.dataType = dataType;
        this.parent = parent;
        this.requirements = new ArrayList();
        this.description = description;
        this.longDescription = longDescription;
        this.updateId();
    }

    public static void completeQuest(Quest quest, UUID uuid) {
        PlayerEntity player;
        if (!quest.isEnabled(uuid) || !quest.isAvailable(uuid)) {
            return;
        }
        for (QuestTask<?> questTask : quest.getTasks()) {
            if (((TaskData)questTask.getData((UUID)uuid)).completed) continue;
            return;
        }
        QuestData data = quest.getQuestData(uuid);
        data.completed = true;
        data.claimed = false;
        data.available = false;
        data.time = Quest.serverTicker.getHours();
        if (QuestingDataManager.getInstance().getQuestingData(uuid).getTeam().getRewardSetting() == RewardSetting.RANDOM) {
            int rewardId = (int)(Math.random() * (double)data.reward.length);
            data.reward[rewardId] = true;
        } else {
            Arrays.fill(data.reward, true);
        }
        quest.sendUpdatedDataToTeam(uuid);
        TeamLiteStat.refreshTeam(QuestingDataManager.getInstance().getQuestingData(uuid).getTeam());
        for (Quest child : quest.getReversedRequirement()) {
            QuestTask.completeQuest(child, uuid);
            child.sendUpdatedDataToTeam(uuid);
        }
        if (quest.getRepeatInfo().getType() == RepeatType.INSTANT) {
            quest.reset(uuid);
        }
        if ((player = QuestingData.getPlayer(uuid)) instanceof ServerPlayerEntity && !quest.hasReward(player)) {
            NetworkManager.sendToPlayer(ClientChange.SOUND.build((Object)Sounds.COMPLETE), (ServerPlayerEntity)player);
        }
        if (player != null) {
            EventTrigger.instance().onQuestComplete(new EventTrigger.QuestCompletedEvent(player, quest.getQuestId()));
        }
    }

    public abstract void write(Adapter.JsonObjectBuilder var1);

    public abstract void read(JsonObject var1);

    public void updateId() {
        this.id = this.parent.nextTaskId++;
    }

    public boolean allowManual() {
        return false;
    }

    public boolean allowDetect() {
        return false;
    }

    public boolean isCompleted(PlayerEntity player) {
        return ((TaskData)this.getData((PlayerEntity)player)).completed;
    }

    public boolean isCompleted(UUID uuid) {
        return ((TaskData)this.getData((UUID)uuid)).completed;
    }

    public boolean isVisible(PlayerEntity player) {
        QuestTask<?> requirement;
        Iterator<QuestTask<?>> itr = this.requirements.iterator();
        do {
            if (itr.hasNext()) continue;
            return true;
        } while ((requirement = itr.next()).isCompleted(player) && requirement.isVisible(player));
        return false;
    }

    public void write(TaskData task, JsonObject out) {
        task.write(new Adapter.JsonObjectBuilder(out));
    }

    public void read(TaskData task, JsonReader in) throws IOException {
        task.update(QuestTaskAdapter.QUEST_DATA_TASK_ADAPTER.read(in));
    }

    protected Data getData(PlayerEntity player) {
        return this.getData(player.func_110124_au());
    }

    protected Data getData(UUID uuid) {
        return this.getData(this.parent.getQuestData(uuid));
    }

    protected Data getData(Team team) {
        return this.getData(team.getQuestData(this.parent.getQuestId()));
    }

    private Data getData(QuestData questData) {
        TaskData data;
        if (this.id < 0) {
            return this.newQuestData();
        }
        if (this.id >= questData.tasks.length) {
            questData.tasks = Arrays.copyOf(questData.tasks, this.id + 1);
            questData.tasks[this.id] = this.newQuestData();
        }
        if (this.dataType.isInstance(data = questData.tasks[this.id])) {
            return (Data)((TaskData)this.dataType.cast(data));
        }
        LOGGER.warn("Found task data of wrong type. Expected {}, was {}. Replacing with empty data of the correct type.", this.dataType, data == null ? null : data.getClass());
        Data newData = this.newQuestData();
        questData.tasks[this.id] = newData;
        return newData;
    }

    public abstract Data newQuestData();

    public String getLangKeyDescription() {
        return this.description;
    }

    public String getDescription() {
        return Translator.get(this.description, new Object[0]);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLangKeyLongDescription() {
        return this.longDescription;
    }

    public String getLongDescription() {
        return Translator.get(this.longDescription, new Object[0]);
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
        this.cachedDescription = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextProperties> getCachedLongDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(Translator.plain(this.longDescription), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public void completeTask(UUID uuid) {
        ((TaskData)this.getData((UUID)uuid)).completed = true;
        QuestTask.completeQuest(this.parent, uuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract TaskGraphic createGraphic();

    @OnlyIn(value=Dist.CLIENT)
    public final TaskGraphic getGraphic() {
        if (this.graphic == null) {
            this.graphic = Objects.requireNonNull(this.createGraphic());
        }
        return this.graphic;
    }

    public abstract void onUpdate(PlayerEntity var1);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Quest getParent() {
        return this.parent;
    }

    public List<QuestTask<?>> getRequirements() {
        return this.requirements;
    }

    public void addRequirement(QuestTask<?> task) {
        this.requirements.add(task);
    }

    public void clearRequirements() {
        this.requirements.clear();
    }

    public abstract float getCompletedRatio(Team var1);

    public void mergeProgress(UUID playerId, QuestData own, QuestData other) {
        this.mergeProgress(playerId, this.getData(own), this.getData(other));
    }

    public abstract void mergeProgress(UUID var1, Data var2, Data var3);

    public void resetData(UUID playerId) {
        QuestData questData = this.parent.getQuestData(playerId);
        if (this.id < questData.tasks.length) {
            questData.tasks[this.id] = this.newQuestData();
        }
    }

    protected abstract void setComplete(Data var1);

    public void copyProgress(QuestData own, QuestData other) {
        this.copyProgress(this.getData(own), this.getData(other));
    }

    public void copyProgress(Data own, Data other) {
        ((TaskData)own).completed = ((TaskData)other).completed;
    }

    public void onDelete() {
        EventTrigger.instance().remove(this);
    }

    public void register(EventTrigger.Type ... types) {
        EventTrigger.instance().add(this, types);
    }

    public boolean isValid() {
        return this.getParent() != null && this.getParent().getTasks() != null && this.getParent().getTasks().contains(this);
    }

    public void onServerTick(MinecraftServer server) {
    }

    public void onPlayerTick(ServerPlayerEntity playerEntity) {
    }

    public void onLivingDeath(LivingEntity entity, DamageSource source) {
    }

    public void onCrafting(PlayerEntity player, ItemStack stack) {
    }

    public void onItemPickUp(PlayerEntity playerEntity, ItemStack stack) {
    }

    public void onOpenBook(EventTrigger.BookOpeningEvent event) {
    }

    public void onReputationChange(EventTrigger.ReputationEvent event) {
    }

    public void onAnimalTame(PlayerEntity tamer, Entity entity) {
    }

    public void onAdvancement(ServerPlayerEntity playerEntity) {
    }

    public void onQuestCompleted(EventTrigger.QuestCompletedEvent event) {
    }

    public void onQuestSelected(EventTrigger.QuestSelectedEvent event) {
    }

    public void onBlockPlaced(World world, BlockState state, LivingEntity entity) {
    }

    public void onBlockBroken(BlockPos blockPos, BlockState blockState, PlayerEntity player) {
    }

    public void onItemUsed(PlayerEntity playerEntity, World world, Hand hand) {
    }

    public void onBlockUsed(PlayerEntity playerEntity, World world, Hand hand) {
    }
}

