/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class PartList<Part>
implements Iterable<Part> {
    private final Supplier<Part> emptySupplier;
    private final EditType.Type type;
    private final int limit;
    private final List<Part> elements;
    private final List<Part> elementsWithEmpty;

    public PartList(Supplier<Part> emptySupplier, EditType.Type type, int limit) {
        this.emptySupplier = emptySupplier;
        this.type = type;
        this.limit = limit;
        ArrayList<Part> list = new ArrayList<Part>();
        list.add(emptySupplier.get());
        this.elements = list.subList(0, 0);
        this.elementsWithEmpty = Collections.unmodifiableList(list);
    }

    public List<Part> getShownElements() {
        if (Quest.canQuestsBeEdited() && this.elements.size() < this.limit) {
            return this.elementsWithEmpty;
        }
        return this.elements;
    }

    public Part getOrCreateForModify(int id) {
        if (id >= this.elements.size()) {
            Part element = this.emptySupplier.get();
            this.elements.add(element);
            SaveHelper.add(EditType.BaseEditType.ADD.with(this.type));
            return element;
        }
        SaveHelper.add(EditType.BaseEditType.CHANGE.with(this.type));
        return this.elements.get(id);
    }

    public void set(int id, Part element) {
        Objects.requireNonNull(element);
        if (id >= this.elements.size()) {
            this.elements.add(element);
            SaveHelper.add(EditType.BaseEditType.ADD.with(this.type));
        } else {
            this.elements.set(id, element);
            SaveHelper.add(EditType.BaseEditType.CHANGE.with(this.type));
        }
    }

    public void remove(int id) {
        if (id < this.elements.size()) {
            this.elements.remove(id);
            SaveHelper.add(EditType.BaseEditType.REMOVE.with(this.type));
        }
    }

    public Part get(int id) {
        return this.elements.get(id);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Deprecated
    public List<Part> getElements() {
        return this.elements;
    }

    public JsonArray write(TypeAdapter<Part> adapter) {
        Adapter.JsonArrayBuilder array = Adapter.array();
        for (Part part : this.elements) {
            array.add(adapter.toJsonTree(part));
        }
        return array.build();
    }

    public void read(JsonArray array, TypeAdapter<Part> adapter) {
        this.elements.clear();
        for (JsonElement element : array) {
            Object part = adapter.fromJsonTree(element);
            if (part == null) continue;
            this.elements.add(part);
        }
    }

    @Override
    @NotNull
    public Iterator<Part> iterator() {
        return this.elements.iterator();
    }
}

