/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.DeathTaskData;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.client.DeathTaskGraphic;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DeathTask
extends QuestTask<DeathTaskData> {
    private static final String DEATHS = "deaths";
    private int deaths;

    public DeathTask(Quest parent, String description, String longDescription) {
        super(DeathTaskData.class, parent, description, longDescription);
        this.register(EventTrigger.Type.DEATH);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TaskGraphic createGraphic() {
        return new DeathTaskGraphic(this);
    }

    @Override
    public DeathTaskData newQuestData() {
        return new DeathTaskData();
    }

    @Override
    public void onUpdate(PlayerEntity player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        return (float)((DeathTaskData)this.getData(team)).getDeaths() / (float)this.deaths;
    }

    @Override
    public void mergeProgress(UUID playerID, DeathTaskData own, DeathTaskData other) {
        own.merge(other);
        if (own.getDeaths() == this.deaths) {
            this.completeTask(playerID);
        }
    }

    @Override
    public void setComplete(DeathTaskData data) {
        data.setDeaths(this.deaths);
        data.completed = true;
    }

    @Override
    public void copyProgress(DeathTaskData own, DeathTaskData other) {
        own.update(other);
    }

    @Override
    public void onLivingDeath(LivingEntity player, DamageSource source) {
        DeathTaskData deathData;
        if (player instanceof ServerPlayerEntity && this.parent.isEnabled((PlayerEntity)player) && this.parent.isAvailable((PlayerEntity)player) && this.isVisible((PlayerEntity)player) && !this.isCompleted((PlayerEntity)player) && (deathData = (DeathTaskData)this.getData((PlayerEntity)player)).getDeaths() < this.deaths) {
            deathData.setDeaths(deathData.getDeaths() + 1);
            if (deathData.getDeaths() == this.deaths) {
                this.completeTask(player.func_110124_au());
            }
            this.parent.sendUpdatedDataToTeam((PlayerEntity)player);
        }
    }

    @Override
    public void completeTask(UUID uuid) {
        super.completeTask(uuid);
        ((DeathTaskData)this.getData(uuid)).setDeaths(this.deaths);
        DeathTask.completeQuest(this.parent, uuid);
    }

    public int getDeaths(UUID id) {
        return ((DeathTaskData)this.getData(id)).getDeaths();
    }

    public int getDeathsRequired() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
        SaveHelper.add(EditType.DEATH_CHANGE);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(DEATHS, this.getDeathsRequired());
    }

    @Override
    public void read(JsonObject object) {
        this.deaths = JSONUtils.func_151208_a((JsonObject)object, (String)DEATHS, (int)0);
    }
}

