/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.CompleteQuestTaskData;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.client.CompleteQuestTaskGraphic;
import hardcorequesting.common.forge.quests.task.client.TaskGraphic;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CompleteQuestTask
extends QuestTask<CompleteQuestTaskData> {
    private static final String COMPLETED_QUESTS = "completed_quests";
    protected static final int LIMIT = 3;
    private final PartList<Part> parts = new PartList<Part>(Part::new, EditType.Type.COMPLETION, 3);

    public CompleteQuestTask(Quest parent, String description, String longDescription) {
        super(CompleteQuestTaskData.class, parent, description, longDescription);
        this.register(EventTrigger.Type.QUEST_COMPLETED, EventTrigger.Type.OPEN_BOOK);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TaskGraphic createGraphic() {
        return new CompleteQuestTaskGraphic(this, this.parts);
    }

    public boolean completed(int id, PlayerEntity player) {
        return ((CompleteQuestTaskData)this.getData(player)).getValue(id);
    }

    public void setQuest(int id, UUID quest) {
        this.parts.getOrCreateForModify(id).setQuest(quest);
    }

    @Override
    public CompleteQuestTaskData newQuestData() {
        return new CompleteQuestTaskData(this.parts.size());
    }

    @Override
    public void onQuestCompleted(EventTrigger.QuestCompletedEvent event) {
        this.checkCompleted(event.getPlayer());
    }

    @Override
    public void onQuestSelected(EventTrigger.QuestSelectedEvent event) {
        this.checkCompleted(event.getPlayer());
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        this.checkCompleted(player);
    }

    private void checkCompleted(PlayerEntity player) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K && !this.isCompleted(player) && player.func_184102_h() != null) {
            CompleteQuestTaskData data = (CompleteQuestTaskData)this.getData(player);
            boolean completed = true;
            for (int i = 0; i < this.parts.size(); ++i) {
                Part task_quest;
                if (data.getValue(i) || (task_quest = this.parts.get(i)) == null || task_quest.getName() == null || task_quest.getQuest() == null) continue;
                Quest quest = task_quest.getQuest();
                if (quest != null) {
                    if (quest.isCompleted(player)) {
                        data.complete(i);
                        continue;
                    }
                    completed = false;
                    continue;
                }
                completed = false;
            }
            if (completed && !this.parts.isEmpty()) {
                this.completeTask(player.func_110124_au());
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    @Override
    public float getCompletedRatio(Team team) {
        return ((CompleteQuestTaskData)this.getData(team)).getCompletedRatio(this.parts.size());
    }

    @Override
    public void mergeProgress(UUID uuid, CompleteQuestTaskData own, CompleteQuestTaskData other) {
        own.mergeResult(other);
        if (own.areAllCompleted(this.parts.size())) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void setComplete(CompleteQuestTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.complete(i);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(CompleteQuestTaskData own, CompleteQuestTaskData other) {
        own.update(other);
    }

    @Override
    public boolean allowDetect() {
        return true;
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(COMPLETED_QUESTS, (JsonElement)this.parts.write(QuestTaskAdapter.QUEST_COMPLETED_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(JSONUtils.func_151213_a((JsonObject)object, (String)COMPLETED_QUESTS, (JsonArray)new JsonArray()), QuestTaskAdapter.QUEST_COMPLETED_ADAPTER);
    }

    public static class Part {
        private UUID quest_id;

        public ItemStack getIconStack() {
            Quest q = this.getQuest();
            return q != null ? q.getIconStack() : ItemStack.field_190927_a;
        }

        public String getName() {
            Quest q = this.getQuest();
            return q != null ? q.getName() : "Use \"Select Quest\" to pick";
        }

        public void setQuest(UUID quest_id) {
            this.quest_id = quest_id;
        }

        public UUID getQuestId() {
            return this.quest_id;
        }

        public Quest getQuest() {
            if (this.getQuestId() == null) {
                return null;
            }
            return Quest.getQuest(this.getQuestId());
        }
    }
}

