/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import net.minecraft.entity.player.PlayerEntity;

public class QuestData {
    public boolean[] reward;
    public boolean completed;
    public boolean claimed;
    public TaskData[] tasks;
    public boolean available = true;
    public long time;

    public QuestData(int players) {
        this.reward = new boolean[players];
    }

    public boolean getReward(PlayerEntity player) {
        int id = this.getId(player);
        return id >= 0 && id < this.reward.length && this.reward[id];
    }

    public void claimReward(PlayerEntity player) {
        int id = this.getId(player);
        if (id >= 0 && id < this.reward.length) {
            this.reward[id] = false;
        }
    }

    private int getId(PlayerEntity player) {
        Team team = QuestingDataManager.getInstance().getQuestingData(player).getTeam();
        int id = 0;
        for (PlayerEntry entry : team.getPlayers()) {
            if (!entry.isInTeam()) continue;
            if (entry.getUUID().equals(player.func_110124_au())) {
                return id;
            }
            ++id;
        }
        return -1;
    }

    public boolean canClaim() {
        return this.completed && !this.claimed;
    }
}

