/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.data.TaskData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.JSONUtils;

public class LocationTaskData
extends TaskData {
    private static final String COUNT = "count";
    private static final String VISITED = "visited";
    private final List<Boolean> visited;

    public LocationTaskData(int size) {
        this.visited = new ArrayList<Boolean>(size);
        while (this.visited.size() < size) {
            this.visited.add(false);
        }
    }

    public static TaskData construct(JsonObject in) {
        LocationTaskData data = new LocationTaskData(JSONUtils.func_151203_m((JsonObject)in, (String)COUNT));
        data.completed = JSONUtils.func_151209_a((JsonObject)in, (String)"completed", (boolean)false);
        JsonArray array = JSONUtils.func_151214_t((JsonObject)in, (String)VISITED);
        for (int i = 0; i < array.size(); ++i) {
            if (!array.get(i).getAsBoolean()) continue;
            data.complete(i);
        }
        return data;
    }

    public boolean getValue(int id) {
        if (id >= this.visited.size()) {
            return false;
        }
        return this.visited.get(id);
    }

    public void complete(int id) {
        while (id >= this.visited.size()) {
            this.visited.add(false);
        }
        this.visited.set(id, true);
    }

    public void mergeResult(LocationTaskData other) {
        for (int i = 0; i < other.visited.size(); ++i) {
            if (!other.visited.get(i).booleanValue()) continue;
            this.complete(i);
        }
    }

    public float getCompletedRatio(int size) {
        return (float)this.visited.stream().limit(size).filter(Boolean::booleanValue).count() / (float)size;
    }

    public boolean areAllCompleted(int size) {
        return this.visited.stream().limit(size).allMatch(Boolean::booleanValue);
    }

    @Override
    public QuestTaskAdapter.QuestDataType getDataType() {
        return QuestTaskAdapter.QuestDataType.LOCATION;
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(COUNT, this.visited.size());
        builder.add(VISITED, (JsonElement)Adapter.array(this.visited.toArray()).build());
    }

    @Override
    public void update(TaskData taskData) {
        super.update(taskData);
        this.visited.clear();
        this.visited.addAll(((LocationTaskData)taskData).visited);
    }
}

