/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.data.TaskData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.JSONUtils;

public class AdvancementTaskData
extends TaskData {
    private static final String COUNT = "count";
    private static final String ADVANCED = "advanced";
    private final List<Boolean> advanced;

    public AdvancementTaskData(int size) {
        this.advanced = new ArrayList<Boolean>(size);
        while (this.advanced.size() < size) {
            this.advanced.add(false);
        }
    }

    public static TaskData construct(JsonObject in) {
        AdvancementTaskData data = new AdvancementTaskData(JSONUtils.func_151203_m((JsonObject)in, (String)COUNT));
        data.completed = JSONUtils.func_151209_a((JsonObject)in, (String)"completed", (boolean)false);
        JsonArray array = JSONUtils.func_151214_t((JsonObject)in, (String)ADVANCED);
        for (int i = 0; i < array.size(); ++i) {
            if (!array.get(i).getAsBoolean()) continue;
            data.complete(i);
        }
        return data;
    }

    public boolean getValue(int id) {
        if (id >= this.advanced.size()) {
            return false;
        }
        return this.advanced.get(id);
    }

    public void complete(int id) {
        while (id >= this.advanced.size()) {
            this.advanced.add(false);
        }
        this.advanced.set(id, true);
    }

    public void mergeResult(AdvancementTaskData other) {
        for (int i = 0; i < other.advanced.size(); ++i) {
            if (!other.advanced.get(i).booleanValue()) continue;
            this.complete(i);
        }
    }

    public float getCompletedRatio(int size) {
        return (float)this.advanced.stream().limit(size).filter(Boolean::booleanValue).count() / (float)size;
    }

    public boolean areAllCompleted(int size) {
        return this.advanced.stream().limit(size).allMatch(Boolean::booleanValue);
    }

    @Override
    public QuestTaskAdapter.QuestDataType getDataType() {
        return QuestTaskAdapter.QuestDataType.ADVANCEMENT;
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(COUNT, this.advanced.size());
        builder.add(ADVANCED, (JsonElement)Adapter.array(this.advanced.toArray()).build());
    }

    @Override
    public void update(TaskData taskData) {
        super.update(taskData);
        this.advanced.clear();
        this.advanced.addAll(((AdvancementTaskData)taskData).advanced);
    }
}

