/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;

public enum TriggerType {
    NONE("none", false, false){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            return true;
        }

        @Override
        public String getMessage(Quest quest) {
            return null;
        }
    }
    ,
    QUEST_TRIGGER("quest", false, true){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            return false;
        }
    }
    ,
    TASK_TRIGGER("task", true, true){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            if (quest.getTriggerTasks() >= quest.getTasks().size()) {
                return quest.isCompleted(playerId);
            }
            return quest.getTasks().get(quest.getTriggerTasks() - 1).isCompleted(playerId);
        }

        @Override
        public String getMessage(Quest quest) {
            return super.getMessage(quest) + " (" + quest.getTriggerTasks() + ")";
        }
    }
    ,
    ANTI_TRIGGER("anti", false, false){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            return quest.isEnabled(playerId, false);
        }
    };

    private String id;
    private boolean useTaskCount;
    private boolean workAsInvisible;

    private TriggerType(String id, boolean useTaskCount, boolean workAsInvisible) {
        this.id = id;
        this.useTaskCount = useTaskCount;
        this.workAsInvisible = workAsInvisible;
    }

    public String getName() {
        return Translator.get("hqm.trigger." + this.id + ".title", new Object[0]);
    }

    public String getDescription() {
        return Translator.get("hqm.trigger." + this.id + ".desc", new Object[0]);
    }

    public boolean isUseTaskCount() {
        return this.useTaskCount;
    }

    public boolean doesWorkAsInvisible() {
        return this.workAsInvisible;
    }

    public abstract boolean isQuestVisible(Quest var1, UUID var2);

    public String getMessage(Quest quest) {
        return (Object)((Object)GuiColor.ORANGE) + this.getName();
    }
}

