/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.quests.Quest;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum RepeatType {
    NONE("none", false){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getMessage(Quest quest, PlayerEntity player, int days, int hours) {
            return null;
        }
    }
    ,
    INSTANT("instant", false){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getMessage(Quest quest, PlayerEntity player, int days, int hours) {
            return super.getMessage(quest, player, days, hours) + (Object)((Object)GuiColor.GRAY) + I18n.func_135052_a((String)"hqm.repeat.instant.message", (Object[])new Object[0]);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getShortMessage(int days, int hours) {
            return (Object)((Object)GuiColor.YELLOW) + I18n.func_135052_a((String)"hqm.repeat.instant.message", (Object[])new Object[0]);
        }
    }
    ,
    INTERVAL("interval", true){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getMessage(Quest quest, PlayerEntity player, int days, int hours) {
            return super.getMessage(quest, player, days, hours) + (Object)((Object)GuiColor.GRAY) + I18n.func_135052_a((String)"hqm.repeat.interval.message", (Object[])new Object[0]) + "\n" + RepeatType.formatTime(days, hours) + "\n" + RepeatType.formatIntervalTime(quest, player, days, hours);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getShortMessage(int days, int hours) {
            return (Object)((Object)GuiColor.YELLOW) + I18n.func_135052_a((String)"hqm.repeat.interval.message", (Object[])new Object[0]) + " (" + days + ":" + hours + ")";
        }
    }
    ,
    TIME("time", true){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getMessage(Quest quest, PlayerEntity player, int days, int hours) {
            return super.getMessage(quest, player, days, hours) + (Object)((Object)GuiColor.GRAY) + I18n.func_135052_a((String)"hqm.repeat.time.message", (Object[])new Object[0]) + "\n" + RepeatType.formatTime(days, hours) + RepeatType.formatCooldownTime(quest, player, days, hours);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String getShortMessage(int days, int hours) {
            return (Object)((Object)GuiColor.YELLOW) + I18n.func_135052_a((String)"hqm.repeat.time.message", (Object[])new Object[0]) + " (" + days + ":" + hours + ")";
        }
    };

    private String id;
    private boolean useTime;

    private RepeatType(String id, boolean useTime) {
        this.id = id;
        this.useTime = useTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String formatCooldownTime(Quest quest, PlayerEntity player, int days, int hours) {
        if (!quest.getQuestData((PlayerEntity)player).available) {
            int timerDuration = days * 24 + hours;
            long timerStart = quest.getQuestData((PlayerEntity)player).time;
            long current = Quest.clientTicker.getHours();
            int remaining = (int)(timerStart + (long)timerDuration - current);
            return "\n" + RepeatType.formatRemainingTime(quest, player, remaining / 24, remaining % 24);
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String formatIntervalTime(Quest quest, PlayerEntity player, int days, int hours) {
        if (days == 0 && hours == 0) {
            return (Object)((Object)GuiColor.RED) + I18n.func_135052_a((String)"hqm.repeat.invalid", (Object[])new Object[0]);
        }
        int interval = days * 24 + hours;
        int remaining = interval - (int)(Quest.clientTicker.getHours() % (long)interval);
        return RepeatType.formatRemainingTime(quest, player, remaining / 24, remaining % 24);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String formatRemainingTime(Quest quest, PlayerEntity player, int days, int hours) {
        if (!quest.isAvailable(player)) {
            return (Object)((Object)GuiColor.YELLOW) + I18n.func_135052_a((String)"hqm.repeat.resetIn", (Object[])new Object[]{RepeatType.formatTime(days, hours)});
        }
        return (Object)((Object)GuiColor.GRAY) + I18n.func_135052_a((String)"hqm.repeat.nextReset", (Object[])new Object[]{RepeatType.formatTime(days, hours)});
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String formatTime(int days, int hours) {
        String str = GuiColor.GRAY.toString();
        if (days > 0) {
            str = str + (Object)((Object)GuiColor.LIGHT_GRAY);
        }
        str = str + days;
        str = str + " ";
        str = str + I18n.func_135052_a((String)("hqm.repeat." + (days == 1 ? "day" : "days")), (Object[])new Object[0]);
        str = str + (Object)((Object)GuiColor.GRAY);
        str = str + " " + I18n.func_135052_a((String)"hqm.repeat.and", (Object[])new Object[0]) + " ";
        if (hours > 0) {
            str = str + (Object)((Object)GuiColor.LIGHT_GRAY);
        }
        str = str + hours;
        str = str + " ";
        str = str + I18n.func_135052_a((String)("hqm.repeat." + (hours == 1 ? "hour" : "hours")), (Object[])new Object[0]);
        return str;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)("hqm.repeat." + this.id + ".title"), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getDescription() {
        return I18n.func_135052_a((String)("hqm.repeat." + this.id + ".desc"), (Object[])new Object[0]);
    }

    public boolean isUseTime() {
        return this.useTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getMessage(Quest quest, PlayerEntity player, int days, int hours) {
        return (Object)((Object)GuiColor.YELLOW) + I18n.func_135052_a((String)"hqm.repeat.repeatable", (Object[])new Object[0]) + "\n";
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getShortMessage(int days, int hours) {
        return null;
    }
}

