/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.team.TeamManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;

public class QuestingDataManager {
    private final QuestLine parent;
    public final State state;
    public final Data data;
    private boolean hardcoreActive;
    private boolean questActive;
    public Map<UUID, QuestingData> questingData = new ConcurrentHashMap<UUID, QuestingData>();

    public QuestingDataManager(QuestLine parent) {
        this.parent = parent;
        this.state = new State(parent);
        this.data = new Data(parent);
    }

    public static QuestingDataManager getInstance() {
        return QuestLine.getActiveQuestLine().questingDataManager;
    }

    public QuestingData getQuestingData(PlayerEntity player) {
        return this.getQuestingData(player.func_110124_au());
    }

    public QuestingData getQuestingData(UUID playerUuid) {
        return this.questingData.computeIfAbsent(playerUuid, u -> new QuestingData(this, (UUID)u));
    }

    public Map<UUID, QuestingData> getQuestingData() {
        return this.questingData;
    }

    public boolean isHardcoreActive() {
        return this.hardcoreActive;
    }

    public boolean isQuestActive() {
        return this.questActive;
    }

    public int getDefaultLives() {
        HQMConfig instance = HQMConfig.getInstance();
        return Math.min(instance.Hardcore.MAX_LIVES, instance.Hardcore.DEFAULT_LIVES);
    }

    public void activateHardcore() {
        Boolean hardCore = null;
        try {
            hardCore = HardcoreQuestingCore.getServer().func_71199_h();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (hardCore != null && !this.hardcoreActive && !hardCore.booleanValue()) {
            this.hardcoreActive = true;
        }
    }

    public void disableHardcore() {
        this.hardcoreActive = false;
    }

    public void activateQuest(boolean giveBooks) {
        if (!this.questActive) {
            this.questActive = true;
            if (giveBooks) {
                for (PlayerEntity player : HardcoreQuestingCore.getServer().func_184103_al().func_181057_v()) {
                    if (player == null) continue;
                    this.spawnBook(player);
                }
            }
        }
    }

    public void deactivate() {
        if (this.hardcoreActive || this.questActive) {
            this.hardcoreActive = false;
            this.questActive = false;
            this.questingData = new HashMap<UUID, QuestingData>();
        }
    }

    public static String saveQuestingState(boolean questing, boolean hardcore) {
        JsonObject object = new JsonObject();
        object.addProperty("questing", Boolean.valueOf(questing));
        object.addProperty("hardcore", Boolean.valueOf(hardcore));
        return object.toString();
    }

    public void spawnBook(PlayerEntity player) {
        if (!Quest.canQuestsBeEdited() && !player.field_70170_p.field_72995_K && HQMConfig.getInstance().SPAWN_BOOK && !this.getQuestingData((PlayerEntity)player).receivedBook && this.isQuestActive()) {
            this.getQuestingData((PlayerEntity)player).receivedBook = true;
            CompoundNBT hqmTag = new CompoundNBT();
            CompoundNBT extraTag = HardcoreQuestingCore.platform.getPlayerExtraTag(player);
            if (extraTag.func_74764_b("HardcoreQuesting")) {
                hqmTag = extraTag.func_74775_l("HardcoreQuesting");
            }
            hqmTag.func_74757_a("questBook", true);
            extraTag.func_218657_a("HardcoreQuesting", (INBT)hqmTag);
            ItemStack stack = new ItemStack((IItemProvider)ModItems.book.get());
            if (!player.field_71071_by.func_70441_a(stack)) {
                QuestingDataManager.spawnItemAtPlayer(player, stack);
            }
        }
    }

    private static void spawnItemAtPlayer(PlayerEntity player, ItemStack stack) {
        ItemEntity item = new ItemEntity(player.field_70170_p, player.func_226277_ct_() + 0.5, player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, stack);
        player.field_70170_p.func_217376_c((Entity)item);
        item.func_70100_b_(player);
    }

    public void remove(PlayerEntity player) {
        this.questingData.remove(player.func_110124_au());
    }

    public boolean hasData(PlayerEntity player) {
        return this.questingData.containsKey(player.func_146103_bH().getId());
    }

    public boolean hasData(UUID uuid) {
        return this.questingData.containsKey(uuid);
    }

    public class Data
    extends SimpleSerializable {
        public Data(QuestLine parent) {
            super(parent);
        }

        @Override
        public String saveToString() {
            return SaveHandler.save(Lists.newArrayList(QuestingDataManager.this.getQuestingData().values()), new TypeToken<List<QuestingData>>(){}.getType());
        }

        public String saveToString(PlayerEntity player) {
            return "[" + SaveHandler.save(QuestingDataManager.this.getQuestingData(player), QuestingData.class) + "]";
        }

        @Override
        public String filePath() {
            return "data.json";
        }

        @Override
        public boolean isData() {
            return true;
        }

        @Override
        public void loadFromString(Optional<String> string) {
            QuestingDataManager.this.questingData.clear();
            string.flatMap(s -> SaveHandler.load(s, new TypeToken<List<QuestingData>>(){}.getType())).ifPresent(list -> list.forEach(d -> QuestingDataManager.this.questingData.put(d.getPlayerId(), (QuestingData)d)));
        }
    }

    public class State
    extends SimpleSerializable {
        public State(QuestLine parent) {
            super(parent);
        }

        @Override
        public String saveToString() {
            return QuestingDataManager.saveQuestingState(QuestingDataManager.this.isQuestActive(), QuestingDataManager.this.isHardcoreActive());
        }

        @Override
        public String filePath() {
            return "state.json";
        }

        @Override
        public boolean isData() {
            return true;
        }

        @Override
        public void loadFromString(Optional<String> string) {
            boolean autoQuesting = HQMConfig.getInstance().Starting.AUTO_QUESTING;
            boolean autoHardcore = HQMConfig.getInstance().Starting.AUTO_HARDCORE;
            if (string.isPresent()) {
                JsonObject object = new JsonParser().parse((Reader)new StringReader(string.get())).getAsJsonObject();
                QuestingDataManager.this.deactivate();
                TeamManager.getInstance().deactivate();
                if (object.get("questing").getAsBoolean() || autoQuesting) {
                    QuestingDataManager.this.activateQuest(false);
                }
                if (object.get("hardcore").getAsBoolean() || autoHardcore) {
                    QuestingDataManager.this.activateHardcore();
                }
            } else {
                if (autoQuesting) {
                    QuestingDataManager.this.activateQuest(false);
                }
                if (autoHardcore) {
                    QuestingDataManager.this.activateHardcore();
                }
            }
        }
    }
}

