/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Iterables;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.Group;
import hardcorequesting.common.forge.bag.GroupData;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.LivesUpdate;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.team.TeamUpdateSize;
import hardcorequesting.common.forge.util.Translator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestingData {
    public UUID selectedQuestId = null;
    public int selectedTask = -1;
    public boolean playedLore;
    public boolean receivedBook;
    private Team team;
    private int lives;
    private UUID playerId;
    private String name;
    private Map<UUID, GroupData> groupData;

    public QuestingData(QuestingDataManager manager, UUID playerId) {
        this.lives = manager.getDefaultLives();
        this.playerId = playerId;
        this.team = Team.single(playerId);
        this.createGroupData();
    }

    public QuestingData(QuestingDataManager manager, UUID playerId, int lives, Map<UUID, GroupData> groupData) {
        this.playerId = playerId;
        this.lives = lives;
        this.team = TeamManager.getInstance().getByPlayer(playerId);
        this.createGroupData();
        this.groupData.putAll(groupData);
        manager.questingData.put(playerId, this);
    }

    public static PlayerEntity getPlayerFromUsername(String playerName) {
        return HardcoreQuestingCore.getServer().func_184103_al().func_152612_a(playerName);
    }

    public static PlayerEntity getPlayer(String uuid) {
        if (uuid.split("-").length == 5) {
            return QuestingData.getPlayer(UUID.fromString(uuid));
        }
        return QuestingData.getPlayerFromUsername(uuid);
    }

    public static PlayerEntity getPlayer(UUID uuid) {
        MinecraftServer server = HardcoreQuestingCore.getServer();
        return server == null ? null : server.func_184103_al().func_177451_a(uuid);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getName() throws IllegalArgumentException {
        if (this.name == null) {
            PlayerEntity player = QuestingData.getPlayer(this.playerId);
            this.name = player != null ? player.func_195047_I_() : "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void createGroupData() {
        this.groupData = new HashMap<UUID, GroupData>();
        Group.getGroups().keySet().forEach(this::createGroupData);
    }

    private void createGroupData(UUID groupId) {
        this.groupData.put(groupId, new GroupData());
    }

    public int getLives() {
        boolean shareLives = this.getTeam().isSharingLives();
        return shareLives ? this.getTeam().getSharedLives() : this.getRawLives();
    }

    public int getLivesToStayAlive() {
        boolean shareLives = this.getTeam().isSharingLives();
        return shareLives ? this.getTeam().getPlayerCount() : 1;
    }

    public int getRawLives() {
        return this.lives;
    }

    public void setRawLives(int lives) {
        this.lives = lives;
    }

    public QuestData getQuestData(UUID questId) {
        return this.getTeam().getQuestData(questId);
    }

    public void setQuestData(UUID questId, QuestData data) {
        this.getTeam().setQuestData(questId, data);
    }

    public GroupData getGroupData(UUID groupId) {
        if (!this.groupData.containsKey(groupId)) {
            this.createGroupData(groupId);
        }
        return this.groupData.get(groupId);
    }

    public int addLives(PlayerEntity player, int amount) {
        int max = HQMConfig.getInstance().Hardcore.MAX_LIVES;
        int i = this.getRawLives() + amount;
        this.lives = Math.min(i, max);
        this.getTeam().refreshTeamLives();
        return this.lives;
    }

    public void removeLifeAndSendMessage(@NotNull PlayerEntity player) {
        boolean isDead;
        boolean bl = isDead = !this.removeLives(player, 1);
        if (!isDead) {
            player.func_145747_a((ITextComponent)Translator.pluralTranslated(this.getLives() != 1, "hqm.message.lostLife", this.getLives()), Util.field_240973_b_);
        }
        if (this.getTeam().isSharingLives()) {
            for (PlayerEntry entry : this.getTeam().getPlayers()) {
                PlayerEntity other;
                if (!entry.isInTeam() || entry.getUUID().equals(player.func_110124_au()) || (other = QuestingData.getPlayer(entry.getUUID())) == null) continue;
                other.func_145747_a((ITextComponent)Translator.pluralTranslated(this.getLives() != 1, "hqm.message.lostTeamLife", player.func_195047_I_(), isDead ? " " + Translator.get("hqm.message.andBanned", new Object[0]) : "", this.getLives()), Util.field_240973_b_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLives(@NotNull PlayerEntity player, int amount) {
        QuestingDataManager manager = QuestingDataManager.getInstance();
        boolean shareLives = this.getTeam().isSharingLives();
        if (shareLives) {
            int dif = Math.min(this.lives - 1, amount);
            amount -= dif;
            this.lives -= dif;
            block4: while (amount > 0) {
                int players = 0;
                for (PlayerEntry entry : manager.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getUUID().equals(player.func_110124_au()) || manager.getQuestingData(entry.getUUID()).getRawLives() <= 1) continue;
                    ++players;
                }
                if (players == 0) break;
                int id = (int)(Math.random() * (double)players);
                for (PlayerEntry entry : manager.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getUUID().equals(player.func_110124_au()) || manager.getQuestingData(entry.getUUID()).getRawLives() <= 1) continue;
                    if (id == 0) {
                        --manager.getQuestingData((UUID)entry.getUUID()).lives;
                        --amount;
                        continue block4;
                    }
                    --id;
                }
            }
            this.lives -= amount;
        } else {
            this.lives = this.getRawLives() - amount;
        }
        if (player instanceof ServerPlayerEntity) {
            NetworkManager.sendToPlayer(new LivesUpdate(this.playerId, this.lives), (ServerPlayerEntity)player);
        }
        this.getTeam().refreshTeamLives();
        try {
            boolean bl;
            if (this.getLives() < this.getLivesToStayAlive()) {
                this.outOfLives(player);
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            TeamLiteStat.refreshTeam(this.team);
        }
    }

    public void die(@NotNull PlayerEntity player) {
        if (QuestingDataManager.getInstance().isHardcoreActive()) {
            this.removeLifeAndSendMessage(player);
        }
    }

    private void outOfLives(PlayerEntity player) {
        QuestingDataManager manager = QuestingDataManager.getInstance();
        QuestingData data = manager.getQuestingData(player);
        Team team = data.getTeam();
        if (!team.isSingle() && !Iterables.isEmpty(TeamManager.getInstance().getNamedTeams())) {
            team.removePlayer(player);
            if (team.getPlayerCount() == 0) {
                team.deleteTeam();
            } else {
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
        player.field_71071_by.func_174888_l();
        MinecraftServer mcServer = player.func_184102_h();
        if (mcServer.func_71264_H()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("hqm.message.singlePlayerHardcore"), true);
        } else {
            String setBanReason = "Out of lives in Hardcore Questing mode";
            String setBannedBy = "HQM";
            ProfileBanEntry entry = new ProfileBanEntry(player.func_146103_bH(), null, setBannedBy, null, setBanReason);
            mcServer.func_184103_al().func_152608_h().func_152687_a((UserListEntry)entry);
            ((ServerPlayerEntity)player).field_71135_a.func_194028_b((ITextComponent)Translator.translatable("hqm.message.gameOver", new Object[0]));
            SoundHandler.playToAll(Sounds.DEATH);
        }
    }

    @NotNull
    public Team getTeam() {
        Team t;
        if (!this.team.isSingle() && (t = TeamManager.getInstance().getByTeamId(this.team.getId())) != null) {
            this.team = t;
        }
        return Objects.requireNonNull(this.team);
    }

    public void setTeam(@Nullable Team team) {
        if (team == null) {
            this.team = Team.single(this.playerId);
        } else if (team.isSingle()) {
            this.team = team;
        } else {
            Team t = TeamManager.getInstance().getByTeamId(team.getId());
            if (t != null) {
                this.team = t;
            } else {
                this.setTeam(null);
            }
        }
    }

    public Map<UUID, GroupData> getGroupData() {
        return this.groupData;
    }
}

