/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.io.adapter.QuestAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.Serializable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class QuestSetsManager
implements Serializable {
    private static final Pattern JSON = Pattern.compile(".*\\.json$", 2);
    private static final Pattern BAGS = Pattern.compile("^bags\\.json$", 2);
    private static final Pattern DEATHS = Pattern.compile("^deaths\\.json$", 2);
    private static final Pattern REPUTATIONS = Pattern.compile("^reputations\\.json$", 2);
    private static final Pattern TEAMS = Pattern.compile("^teams\\.json$", 2);
    private static final Pattern STATE = Pattern.compile("^state\\.json$", 2);
    private static final Pattern DATA = Pattern.compile("^data\\.json$", 2);
    private static final Pattern SETS = Pattern.compile("^sets\\.json$", 2);
    private static final FileFilter QUEST_SET_FILTER = pathname -> JSON.matcher(pathname.getName()).find() && !REPUTATIONS.matcher(pathname.getName()).find() && !BAGS.matcher(pathname.getName()).find() && !TEAMS.matcher(pathname.getName()).find() && !STATE.matcher(pathname.getName()).find() && !DATA.matcher(pathname.getName()).find() && !SETS.matcher(pathname.getName()).find() && !DEATHS.matcher(pathname.getName()).find();
    public final Map<UUID, Quest> quests = new ConcurrentHashMap<UUID, Quest>();
    public final List<QuestSet> questSets = Lists.newArrayList();
    private final QuestLine parent;

    public QuestSetsManager(QuestLine parent) {
        this.parent = parent;
    }

    public static QuestSetsManager getInstance() {
        return QuestLine.getActiveQuestLine().questSetsManager;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public void save() {
        this.parent.resolve("sets.json", provider -> {
            JsonObject object = new JsonObject();
            JsonArray array = new JsonArray();
            this.questSets.stream().map(QuestSet::getFilename).distinct().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            object.add("sets", (JsonElement)array);
            provider.set(object.toString());
        });
        for (QuestSet set : this.questSets) {
            this.parent.resolve("sets/" + set.getFilename() + ".json", provider -> provider.set(SaveHandler.save(set, QuestSet.class)));
        }
    }

    @Override
    public void load() {
        this.quests.clear();
        this.questSets.clear();
        EventTrigger.instance().clear();
        this.parent.resolve("sets.json").flatMap(QuestLine.FileProvider::get).map(arg_0 -> ((JsonParser)SaveHandler.JSON_PARSER).parse(arg_0)).ifPresent(jsonElement -> {
            if (jsonElement.isJsonArray()) {
                ArrayList order = Lists.newArrayList();
                for (JsonElement element : jsonElement.getAsJsonArray()) {
                    order.add(element.getAsString());
                }
                this.parent.basePath.ifPresent(path -> {
                    for (File file : path.toFile().listFiles(QUEST_SET_FILTER)) {
                        SaveHandler.load(file.toPath()).flatMap(setText -> SaveHandler.load(setText, QuestSet.class)).filter(Predicates.not(this.questSets::contains)).ifPresent(this.questSets::add);
                    }
                });
                this.questSets.sort((s1, s2) -> {
                    if (s1.equals(s2)) {
                        return 0;
                    }
                    int is1 = order.indexOf(s1.getName());
                    int is2 = order.indexOf(s2.getName());
                    if (is1 == -1) {
                        return is2 == -1 ? s1.getName().compareTo(s2.getName()) : 1;
                    }
                    if (is2 == -1) {
                        return -1;
                    }
                    if (is1 == is2) {
                        return 0;
                    }
                    return is1 < is2 ? -1 : 1;
                });
            } else {
                ArrayList sets = Lists.newArrayList();
                for (JsonElement element : jsonElement.getAsJsonObject().get("sets").getAsJsonArray()) {
                    sets.add(element.getAsString());
                }
                for (String set : sets) {
                    this.parent.resolve("sets/" + set + ".json").flatMap(QuestLine.FileProvider::get).flatMap(setText -> SaveHandler.load(setText, QuestSet.class)).filter(Predicates.not(this.questSets::contains)).ifPresent(this.questSets::add);
                }
            }
        });
        try {
            QuestAdapter.postLoad();
        }
        catch (IOException e) {
            HardcoreQuestingCore.LOGGER.warn("Failed loading quest sets for remote", (Throwable)e);
        }
        HardcoreQuestingCore.LOGGER.info("Loaded %d quests from %d quest sets.", (Object)this.quests.size(), (Object)this.questSets.size());
    }
}

