/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuParentCount;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuRepeat;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuTrigger;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.reputation.ReputationBar;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuestSet {
    private static final int LINE_2_X = 10;
    private static final int LINE_2_Y = 12;
    private static final int INFO_Y = 100;
    private static int lastClicked = -1;
    private static QuestSet lastLastQuestSet = null;
    private String name;
    private String description;
    private List<ITextProperties> cachedDescription;
    private Map<UUID, Quest> quests = new ConcurrentHashMap<UUID, Quest>();
    private List<ReputationBar> reputationBars;
    private int id;
    private static List<String> FORBIDDEN_SET_NAMES = Arrays.asList("sets", "reputations", "bags", "con", "prn", "aux", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "com0", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "lpt0");
    private static List<String> FORBIDDEN_SET_NAME_PIECES = Arrays.asList("<", ">", ":", "\"", "\\", "/", "|", "?", "*");

    public QuestSet(String name, String description) {
        this.name = name;
        this.description = description;
        this.reputationBars = new ArrayList<ReputationBar>();
        this.id = Quest.getQuestSets().size();
    }

    public static void loginReset() {
        lastClicked = -1;
        lastLastQuestSet = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawOverview(MatrixStack matrices, GuiQuestBook gui, ScrollBar setScroll, ScrollBar descriptionScroll, int x, int y) {
        PlayerEntity player = gui.getPlayer();
        List<QuestSet> questSets = Quest.getQuestSets();
        int start = setScroll.isVisible(gui) ? Math.round((float)(Quest.getQuestSets().size() - 7) * setScroll.getScroll()) : 0;
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (int i = start; i < Math.min(start + 7, questSets.size()); ++i) {
            QuestSet questSet = questSets.get(i);
            int setY = 20 + (i - start) * 29;
            int total = questSet.getQuests().size();
            boolean enabled = questSet.isEnabled(player, isVisibleCache, isLinkFreeCache);
            int completedCount = enabled ? questSet.getCompletedCount(player, isVisibleCache, isLinkFreeCache) : 0;
            boolean completed = true;
            int unclaimed = 0;
            for (Quest quest : questSet.getQuests().values()) {
                if (completed && !quest.isCompleted(player) && quest.isLinkFree(player, isLinkFreeCache)) {
                    completed = false;
                }
                if (!quest.isCompleted(player) || !quest.hasReward(player)) continue;
                ++unclaimed;
            }
            boolean selected = questSet == GuiQuestBook.selectedSet;
            boolean inBounds = gui.inBounds(25, setY, gui.getStringWidth(questSet.getName(i)), 9, x, y);
            int color = gui.modifyingQuestSet == questSet ? HQMConfig.CURRENTLY_MODIFYING_QUEST_SET : (enabled ? (completed ? (selected ? (inBounds ? HQMConfig.COMPLETED_SELECTED_IN_BOUNDS_SET : HQMConfig.COMPLETED_SELECTED_OUT_OF_BOUNDS_SET) : (inBounds ? HQMConfig.COMPLETED_UNSELECTED_IN_BOUNDS_SET : HQMConfig.COMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET)) : (selected ? (inBounds ? HQMConfig.UNCOMPLETED_SELECTED_IN_BOUNDS_SET : HQMConfig.UNCOMPLETED_SELECTED_OUT_OF_BOUNDS_SET) : (inBounds ? HQMConfig.UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET : HQMConfig.UNCOMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET))) : HQMConfig.DISABLED_SET);
            gui.drawString(matrices, Translator.plain(questSet.getName(i)), 25, setY, color);
            IFormattableTextComponent info = enabled ? (completed ? Translator.translatable("hqm.questBook.allQuests", new Object[0]) : Translator.translatable("hqm.questBook.percentageQuests", completedCount * 100 / total)) : Translator.translatable("hqm.questBook.locked", new Object[0]);
            gui.drawString(matrices, (ITextProperties)info, 35, setY + 12, 0.7f, color);
            if (!enabled || unclaimed == 0) continue;
            IFormattableTextComponent toClaim = Translator.pluralTranslated(unclaimed != 1, "hqm.questBook.unclaimedRewards", GuiColor.PURPLE, unclaimed);
            gui.drawString(matrices, (ITextProperties)toClaim, 35, setY + 12 + 8, 0.7f, -1);
        }
        if (Quest.canQuestsBeEdited() && gui.getCurrentMode() == EditMode.CREATE) {
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.questBook.createNewSet", new Object[0]), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else {
            if (GuiQuestBook.selectedSet != null) {
                int startLine = descriptionScroll.isVisible(gui) ? Math.round((float)(GuiQuestBook.selectedSet.getDescription(gui).size() - 7) * descriptionScroll.getScroll()) : 0;
                gui.drawString(matrices, GuiQuestBook.selectedSet.getDescription(gui), startLine, 7, 180, 20, 0.7f, 0x404040);
            }
            QuestSet.drawQuestInfo(matrices, gui, GuiQuestBook.selectedSet, 180, GuiQuestBook.selectedSet == null ? 20 : 100, isVisibleCache, isLinkFreeCache);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawQuestInfo(MatrixStack matrices, GuiQuestBook gui, QuestSet set, int x, int y) {
        QuestSet.drawQuestInfo(matrices, gui, set, x, y, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawQuestInfo(MatrixStack matrices, GuiQuestBook gui, QuestSet set, int x, int y, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache) {
        int completed = 0;
        int reward = 0;
        int enabled = 0;
        int total = 0;
        int realTotal = 0;
        PlayerEntity player = gui.getPlayer();
        for (Quest quest : Quest.getQuests().values()) {
            if (set != null && !quest.hasSet(set)) continue;
            ++realTotal;
            if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            ++total;
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++enabled;
            if (!quest.isCompleted(player)) continue;
            ++completed;
            if (!quest.hasReward(player)) continue;
            ++reward;
        }
        ArrayList<ITextProperties> info = new ArrayList<ITextProperties>();
        info.add((ITextProperties)Translator.pluralTranslated(total != 1, "hqm.questBook.totalQuests", GuiColor.GRAY, total));
        info.add((ITextProperties)Translator.pluralTranslated(enabled != 1, "hqm.questBook.unlockedQuests", GuiColor.CYAN, enabled));
        info.add((ITextProperties)Translator.pluralTranslated(completed != 1, "hqm.questBook.completedQuests", GuiColor.GREEN, completed));
        info.add((ITextProperties)Translator.pluralTranslated(enabled - completed != 1, "hqm.questBook.totalQuests", GuiColor.LIGHT_BLUE, enabled - completed));
        if (reward > 0) {
            info.add((ITextProperties)Translator.pluralTranslated(reward != 1, "hqm.questBook.unclaimedQuests", GuiColor.PURPLE, reward));
        }
        if (Quest.canQuestsBeEdited() && !Screen.func_231172_r_()) {
            info.add((ITextProperties)Translator.pluralTranslated(realTotal != 1, "hqm.questBook.inclInvisiQuests", GuiColor.LIGHT_GRAY, realTotal));
        }
        gui.drawString(matrices, info, x, y, 0.7f, 0x404040);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar setScroll, int x, int y) {
        List<QuestSet> questSets = Quest.getQuestSets();
        int start = setScroll.isVisible(gui) ? Math.round((float)(Quest.getQuestSets().size() - 7) * setScroll.getScroll()) : 0;
        HashMap isVisibleCache = new HashMap();
        HashMap isLinkFreeCache = new HashMap();
        for (int i = start; i < Math.min(start + 7, questSets.size()); ++i) {
            int setY = 20 + (i - start) * 29;
            QuestSet questSet = questSets.get(i);
            if (!gui.inBounds(25, setY, gui.getStringWidth(questSet.getName(i)), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case DELETE: {
                    if (!questSet.getQuests().isEmpty()) {
                        ArrayList<Quest> quests = new ArrayList<Quest>(questSet.getQuests().values());
                        for (Quest q : quests) {
                            questSet.removeQuest(q);
                            Quest.removeQuest(q);
                        }
                    }
                    for (int j = questSet.getId() + 1; j < Quest.getQuestSets().size(); ++j) {
                        Quest.getQuestSets().get(j).decreaseId();
                    }
                    Quest.getQuestSets().remove(questSet);
                    SaveHelper.add(EditType.SET_REMOVE);
                    break;
                }
                case SWAP_SELECT: {
                    gui.modifyingQuestSet = gui.modifyingQuestSet == questSet ? null : questSet;
                    break;
                }
                case RENAME: {
                    TextMenu.display(gui, gui.getPlayer(), questSet.getName(), true, result -> {
                        if (!questSet.setName((String)result)) {
                            gui.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("hqm.editMode.rename.invalid_set").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                        }
                    });
                    break;
                }
                default: {
                    int thisClicked = gui.getPlayer().field_70173_aa - lastClicked;
                    if (thisClicked < 0) {
                        lastClicked = -1;
                    }
                    if (lastClicked != -1 && thisClicked < 6) {
                        if (GuiQuestBook.selectedSet == null && lastLastQuestSet != null) {
                            GuiQuestBook.selectedSet = lastLastQuestSet;
                        }
                        gui.openSet();
                        lastLastQuestSet = null;
                        break;
                    }
                    GuiQuestBook.selectedSet = questSet == GuiQuestBook.selectedSet ? null : questSet;
                    lastClicked = gui.getPlayer().field_70173_aa;
                    lastLastQuestSet = questSet;
                    break;
                }
            }
            break;
        }
        if (Quest.canQuestsBeEdited() && gui.getCurrentMode() == EditMode.RENAME && gui.inBounds(180, 20, 130, 44, x, y)) {
            TextMenu.display(gui, gui.getPlayer(), GuiQuestBook.selectedSet.getDescription(), false, GuiQuestBook.selectedSet::setDescription);
        }
    }

    public Map<UUID, Quest> getQuests() {
        return this.quests;
    }

    public List<ReputationBar> getReputationBars() {
        this.validateBars();
        return this.reputationBars;
    }

    private void validateBars() {
        ArrayList<ReputationBar> toRemove = new ArrayList<ReputationBar>();
        for (ReputationBar reputationBar : this.reputationBars) {
            if (reputationBar.isValid()) continue;
            toRemove.add(reputationBar);
        }
        this.reputationBars.removeAll(toRemove);
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String name) {
        String test_name = name.toLowerCase().trim();
        if (FORBIDDEN_SET_NAMES.contains(test_name)) {
            return false;
        }
        for (String piece : FORBIDDEN_SET_NAME_PIECES) {
            if (!test_name.contains(piece)) continue;
            return false;
        }
        int inc = 1;
        String new_name = name;
        List names = Quest.getQuestSets().stream().filter(q -> q != this).map(q -> q.getName().toLowerCase()).collect(Collectors.toList());
        while (names.contains(new_name.toLowerCase())) {
            new_name = String.format("%s%d", name, inc++);
            if (inc < 20) continue;
            return false;
        }
        this.name = new_name;
        return true;
    }

    public String getFilename() {
        return this.name.replaceAll(" ", "_");
    }

    public String getName(int i) {
        return i + 1 + ". " + this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextProperties> getDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(Translator.plain(this.description), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public boolean isEnabled(PlayerEntity player) {
        return this.isEnabled(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private boolean isEnabled(PlayerEntity player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests.values()) {
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted(PlayerEntity player) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests.values()) {
            if (quest.isCompleted(player)) continue;
            return false;
        }
        return true;
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest.getQuestId());
    }

    public void addQuest(Quest quest) {
        this.quests.put(quest.getQuestId(), quest);
    }

    public void removeRepBar(ReputationBar repBar) {
        this.reputationBars.remove(repBar);
    }

    public void addRepBar(ReputationBar repBar) {
        if (repBar == null) {
            return;
        }
        repBar.setQuestSet(this.id);
        this.reputationBars.add(repBar);
    }

    public int getCompletedCount(PlayerEntity player) {
        return this.getCompletedCount(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private int getCompletedCount(PlayerEntity player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        int count = 0;
        for (Quest quest : this.quests.values()) {
            if (!quest.isCompleted(player) || !quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++count;
        }
        return count;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public int getId() {
        return this.id;
    }

    public void decreaseId() {
        --this.id;
        for (ReputationBar reputationBar : this.reputationBars) {
            reputationBar.setQuestSet(this.id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrices, GuiQuestBook gui, int x0, int y0, int x, int y) {
        int color;
        if (gui.isOpBook) {
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.questBook.shiftSetReset", new Object[0]), 0.7f, 130), 184, 192, 0.7f, 0x707070);
        }
        PlayerEntity player = gui.getPlayer();
        for (ReputationBar bar : this.getReputationBars()) {
            bar.draw(matrices, gui, x, y, player);
        }
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (Quest child : this.getQuests().values()) {
            if (!Quest.canQuestsBeEdited() && !child.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            for (Quest parent : child.getRequirements()) {
                if (!Quest.canQuestsBeEdited() && !parent.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.hasSameSetAs(child)) continue;
                color = Quest.canQuestsBeEdited() && (!child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache)) ? 0x55404040 : -12566464;
                gui.drawLine(gui.getLeft() + parent.getGuiCenterX(), gui.getTop() + parent.getGuiCenterY(), gui.getLeft() + child.getGuiCenterX(), gui.getTop() + child.getGuiCenterY(), 5, color);
            }
        }
        if (Quest.canQuestsBeEdited()) {
            for (Quest child : this.getQuests().values()) {
                for (Quest parent : child.getOptionLinks()) {
                    if (!parent.hasSameSetAs(child)) continue;
                    color = !child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache) ? 1430274269 : -12566307;
                    gui.drawLine(gui.getLeft() + parent.getGuiCenterX(), gui.getTop() + parent.getGuiCenterY(), gui.getLeft() + child.getGuiCenterX(), gui.getTop() + child.getGuiCenterY(), 5, color);
                }
            }
        }
        for (Quest quest : this.getQuests().values()) {
            int color2;
            if (!Quest.canQuestsBeEdited() && !quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            if (quest == gui.modifyingQuest) {
                int color22 = -4456517;
            } else {
                color2 = quest.getQuestId().equals(Quest.speciallySelectedQuestId) ? -476161 : quest.getColorFilter(player, gui.getTick());
            }
            gui.applyColor(color2);
            ResourceHelper.bindResource(GuiBase.MAP_TEXTURE);
            gui.drawRect(quest.getGuiX(), quest.getGuiY(), quest.getGuiU(), quest.getGuiV(player, x, y), quest.getGuiW(), quest.getGuiH());
            int iconX = quest.getGuiCenterX() - 8;
            int iconY = quest.getGuiCenterY() - 8;
            if (quest.useBigIcon()) {
                ++iconX;
                ++iconY;
            }
            gui.drawItemStack(quest.getIconStack(), iconX, iconY, true);
            RenderSystem.popMatrix();
        }
        for (Quest quest : this.getQuests().values()) {
            boolean editing;
            boolean bl = editing = Quest.canQuestsBeEdited() && !Screen.func_231172_r_();
            if (!editing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(x, y)) continue;
            boolean shouldDrawText = false;
            boolean enabled = quest.isEnabled(player, isVisibleCache, isLinkFreeCache);
            String txt = "";
            if (enabled || editing) {
                txt = txt + quest.getName();
            }
            if (!enabled) {
                if (editing) {
                    txt = txt + "\n";
                }
                txt = txt + (Object)((Object)GuiColor.GRAY) + I18n.func_135052_a((String)"hqm.questBook.lockedQuest", (Object[])new Object[0]);
            }
            if (!enabled || editing) {
                int allowedUncompleted;
                int totalParentCount = 0;
                int totalCompletedCount = 0;
                int parentCount = 0;
                int completed = 0;
                ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                for (Quest quest2 : quest.getRequirements()) {
                    ++totalParentCount;
                    boolean isCompleted = quest2.isCompleted(player);
                    if (isCompleted) {
                        ++totalCompletedCount;
                    }
                    if (quest2.hasSameSetAs(quest)) continue;
                    externalQuests.add(quest2);
                    ++parentCount;
                    if (!isCompleted) continue;
                    ++completed;
                }
                if (editing && totalParentCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + Translator.rawString((ITextProperties)Translator.pluralTranslated(totalParentCount != 1, "hqm.questBook.parentCount", totalParentCount - totalCompletedCount, totalParentCount));
                    if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)82)) {
                        txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.holding", (Object[])new Object[]{"R"}) + "]";
                        for (Quest quest3 : quest.getRequirements()) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + quest3.getName();
                            if (!quest3.isCompleted(player)) continue;
                            txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [" + I18n.func_135052_a((String)"hqm.questBook.completed", (Object[])new Object[0]) + "]";
                        }
                    } else {
                        txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.hold", (Object[])new Object[]{"R"}) + "]";
                    }
                }
                int n = allowedUncompleted = quest.getUseModifiedParentRequirement() ? Math.max(0, quest.getRequirements().size() - quest.getParentRequirementCount()) : 0;
                if (parentCount - completed > allowedUncompleted || editing && parentCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + Translator.rawString((ITextProperties)Translator.pluralTranslated(totalParentCount != 1, "hqm.questBook.parentCountElsewhere", totalParentCount - totalCompletedCount, totalParentCount));
                    shouldDrawText = true;
                    if (editing) {
                        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)69)) {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.holding", (Object[])new Object[]{"E"}) + "]";
                            for (Quest parent : externalQuests) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + parent.getName() + " (" + parent.getQuestSet().getName() + ")";
                                if (!parent.isCompleted(player)) continue;
                                txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [" + I18n.func_135052_a((String)"hqm.questBook.completed", (Object[])new Object[0]) + "]";
                            }
                        } else {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.hold", (Object[])new Object[]{"E"}) + "]";
                        }
                    }
                }
                if (editing && quest.getUseModifiedParentRequirement()) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.MAGENTA);
                    int n2 = quest.getParentRequirementCount();
                    txt = n2 < quest.getRequirements().size() ? txt + Translator.rawString((ITextProperties)Translator.pluralTranslated(n2 != 1, "hqm.questBook.reqOnly", n2)) : (n2 > quest.getRequirements().size() ? txt + Translator.rawString((ITextProperties)Translator.pluralTranslated(n2 != 1, "hqm.questBook.reqMore", n2)) : txt + Translator.rawString((ITextProperties)Translator.pluralTranslated(n2 != 1, "hqm.questBook.reqAll", n2)));
                }
            }
            if (enabled || editing) {
                String repeatMessage;
                if (quest.isCompleted(player)) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.GREEN) + I18n.func_135052_a((String)"hqm.questBook.completed", (Object[])new Object[0]);
                }
                if (quest.hasReward(player)) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PURPLE) + I18n.func_135052_a((String)"hqm.questBook.unclaimedReward", (Object[])new Object[0]);
                }
                String string = repeatMessage = enabled ? quest.getRepeatInfo().getMessage(quest, player) : quest.getRepeatInfo().getShortMessage();
                if (repeatMessage != null) {
                    txt = txt + "\n" + repeatMessage;
                }
                if (editing) {
                    int totalTasks = 0;
                    int completedTasks = 0;
                    for (QuestTask<?> task : quest.getTasks()) {
                        ++totalTasks;
                        if (!task.isCompleted(player)) continue;
                        ++completedTasks;
                    }
                    if (totalTasks == 0) {
                        txt = txt + "\n" + (Object)((Object)GuiColor.RED) + I18n.func_135052_a((String)"hqm.questBook.noTasks", (Object[])new Object[0]);
                    } else {
                        txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + I18n.func_135052_a((String)"hqm.questBook.completedTasks", (Object[])new Object[]{completedTasks, totalTasks});
                        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)84)) {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.holding", (Object[])new Object[]{"T"}) + "]";
                            for (QuestTask<?> task : quest.getTasks()) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + task.getDescription();
                                if (!task.isCompleted(player)) continue;
                                txt = txt + (Object)((Object)GuiColor.WHITE) + " [" + I18n.func_135052_a((String)"hqm.questBook.completed", (Object[])new Object[0]) + "]";
                            }
                        } else {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.holding", (Object[])new Object[]{"T"}) + "]";
                        }
                    }
                    String triggerMessage = quest.getTriggerType().getMessage(quest);
                    if (triggerMessage != null) {
                        txt = txt + "\n" + triggerMessage;
                    }
                    if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) {
                        String invisibilityMessage;
                        if (quest.isLinkFree(player, isLinkFreeCache)) {
                            boolean parentInvisible = false;
                            for (Quest parent : quest.getRequirements()) {
                                if (parent.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
                                parentInvisible = true;
                                break;
                            }
                            switch (quest.getTriggerType()) {
                                case ANTI_TRIGGER: {
                                    invisibilityMessage = I18n.func_135052_a((String)"hqm.questBook.invisLocked", (Object[])new Object[0]);
                                    break;
                                }
                                case QUEST_TRIGGER: {
                                    invisibilityMessage = I18n.func_135052_a((String)"hqm.questBook.invisPerm", (Object[])new Object[0]);
                                    parentInvisible = false;
                                    break;
                                }
                                case TASK_TRIGGER: {
                                    invisibilityMessage = Translator.rawString((ITextProperties)Translator.pluralTranslated(quest.getTriggerTasks() != 1, "hqm.questBook.invisCount", quest.getTriggerTasks()));
                                    break;
                                }
                                default: {
                                    invisibilityMessage = null;
                                }
                            }
                            if (parentInvisible) {
                                String string2 = I18n.func_135052_a((String)"hqm.questBook.invisInherit", (Object[])new Object[0]);
                                invisibilityMessage = invisibilityMessage == null ? string2 : string2 + " " + I18n.func_135052_a((String)"hqm.questBook.and", (Object[])new Object[0]) + " " + invisibilityMessage;
                            }
                        } else {
                            invisibilityMessage = I18n.func_135052_a((String)"hqm.questBook.invisOption", (Object[])new Object[0]);
                        }
                        if (invisibilityMessage != null) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.LIGHT_BLUE) + invisibilityMessage;
                        }
                    }
                    ArrayList<UUID> ids = new ArrayList<UUID>();
                    for (Quest quest4 : quest.getOptionLinks()) {
                        ids.add(quest4.getQuestId());
                    }
                    for (Quest quest5 : quest.getReversedOptionLinks()) {
                        UUID id = quest5.getQuestId();
                        if (ids.contains(id)) continue;
                        ids.add(id);
                    }
                    int optionLinks = ids.size();
                    if (optionLinks > 0) {
                        txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + Translator.rawString((ITextProperties)Translator.pluralTranslated(optionLinks != 1, "hqm.questBook.optionLinks", optionLinks));
                        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)79)) {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.holding", (Object[])new Object[]{"O"}) + "]";
                            for (UUID id : ids) {
                                Quest option = Quest.getQuest(id);
                                txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + option.getName();
                                if (option.hasSameSetAs(quest)) continue;
                                txt = txt + " (" + option.getQuestSet().getName() + ")";
                            }
                        } else {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.hold", (Object[])new Object[]{"O"}) + "]";
                        }
                    }
                }
                ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                int childCount = 0;
                for (Quest child : quest.getReversedRequirement()) {
                    if (quest.hasSameSetAs(child)) continue;
                    ++childCount;
                    externalQuests.add(child);
                }
                if (childCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + Translator.rawString((ITextProperties)Translator.pluralTranslated(childCount != 1, "hqm.questBook.childUnlocks", childCount));
                    if (editing) {
                        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)85)) {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.holding", (Object[])new Object[]{"U"}) + "]";
                            for (Quest child : externalQuests) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + child.getName() + " (" + child.getQuestSet().getName() + ")";
                            }
                        } else {
                            txt = txt + " [" + I18n.func_135052_a((String)"hqm.questBook.hold", (Object[])new Object[]{"U"}) + "]";
                        }
                    }
                }
                shouldDrawText = true;
            }
            if (editing) {
                txt = txt + "\n\n" + (Object)((Object)GuiColor.GRAY) + I18n.func_135052_a((String)"hqm.questBook.ctrlNonEditor", (Object[])new Object[0]);
            }
            if (gui.isOpBook && Screen.func_231173_s_()) {
                txt = quest.isCompleted(player) ? txt + "\n\n" + (Object)((Object)GuiColor.RED) + I18n.func_135052_a((String)"hqm.questBook.resetQuest", (Object[])new Object[0]) : txt + "\n\n" + (Object)((Object)GuiColor.ORANGE) + I18n.func_135052_a((String)"hqm.questBook.completeQuest", (Object[])new Object[0]);
            }
            if (!shouldDrawText || gui.getCurrentMode() == EditMode.MOVE) break;
            gui.renderTooltipL(matrices, Stream.of(txt.split("\n")).map(ITextProperties::func_240652_a_).collect(Collectors.toList()), x0, y0);
            break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        block33: {
            PlayerEntity player;
            block32: {
                player = gui.getPlayer();
                if (!Quest.canQuestsBeEdited() || gui.getCurrentMode() != EditMode.CREATE && gui.getCurrentMode() != EditMode.REP_BAR_CREATE) break block32;
                switch (gui.getCurrentMode()) {
                    case CREATE: {
                        if (x > 0) {
                            Quest newQuest = new Quest("Unnamed", "Unnamed quest", 0, 0, false);
                            newQuest.setGuiCenterX(x);
                            newQuest.setGuiCenterY(y);
                            newQuest.setQuestSet(this);
                            SaveHelper.add(EditType.QUEST_CREATE);
                            break;
                        }
                        break block33;
                    }
                    case REP_BAR_CREATE: {
                        gui.setEditMenu(new ReputationBar.EditGui(gui, player, x, y, this.getId()));
                        break;
                    }
                }
                break block33;
            }
            HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
            HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
            block18: for (Quest quest : this.getQuests().values()) {
                if (!Quest.canQuestsBeEdited() && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(x, y)) continue;
                if (Quest.canQuestsBeEdited()) {
                    switch (gui.getCurrentMode()) {
                        case MOVE: {
                            gui.modifyingQuest = quest;
                            SaveHelper.add(EditType.QUEST_MOVE);
                            break;
                        }
                        case REQUIREMENT: {
                            if (gui.modifyingQuest == quest) {
                                if (Screen.func_231173_s_()) {
                                    gui.modifyingQuest.clearRequirements();
                                }
                                gui.modifyingQuest = null;
                                break;
                            }
                            if (gui.modifyingQuest == null) {
                                gui.modifyingQuest = quest;
                                break;
                            }
                            gui.modifyingQuest.addRequirement(quest.getQuestId());
                            break;
                        }
                        case SIZE: {
                            int cX = quest.getGuiCenterX();
                            int cY = quest.getGuiCenterY();
                            quest.setBigIcon(!quest.useBigIcon());
                            quest.setGuiCenterX(cX);
                            quest.setGuiCenterY(cY);
                            SaveHelper.add(EditType.QUEST_SIZE_CHANGE);
                            break;
                        }
                        case ITEM: {
                            PickItemMenu.display(gui, player, quest.getIconStack(), PickItemMenu.Type.ITEM, result -> {
                                try {
                                    quest.setIconStack((ItemStack)result.get());
                                }
                                catch (Exception e) {
                                    System.out.println("Tell LordDusk that he found the issue.");
                                }
                                SaveHelper.add(EditType.ICON_CHANGE);
                            });
                            break;
                        }
                        case DELETE: {
                            Quest.removeQuest(quest);
                            SaveHelper.add(EditType.QUEST_REMOVE);
                            break;
                        }
                        case SWAP: {
                            if (gui.modifyingQuestSet == null || gui.modifyingQuestSet == this) break block18;
                            quest.setQuestSet(gui.modifyingQuestSet);
                            SaveHelper.add(EditType.QUEST_CHANGE_SET);
                            break;
                        }
                        case REPEATABLE: {
                            gui.setEditMenu(new GuiEditMenuRepeat(gui, player, quest));
                            break;
                        }
                        case REQUIRED_PARENTS: {
                            gui.setEditMenu(new GuiEditMenuParentCount((GuiBase)gui, player, quest));
                            break;
                        }
                        case QUEST_SELECTION: {
                            if (Quest.speciallySelectedQuestId == quest.getQuestId()) {
                                Quest.speciallySelectedQuestId = null;
                                break;
                            }
                            Quest.speciallySelectedQuestId = quest.getQuestId();
                            break;
                        }
                        case QUEST_OPTION: {
                            if (gui.modifyingQuest == quest) {
                                if (Screen.func_231173_s_()) {
                                    gui.modifyingQuest.clearOptionLinks();
                                }
                                gui.modifyingQuest = null;
                                break;
                            }
                            if (gui.modifyingQuest == null) {
                                gui.modifyingQuest = quest;
                                break;
                            }
                            gui.modifyingQuest.addOptionLink(quest.getQuestId());
                            break;
                        }
                        case TRIGGER: {
                            gui.setEditMenu(new GuiEditMenuTrigger(gui, player, quest));
                            break;
                        }
                        case NORMAL: {
                            if (gui.isOpBook && Screen.func_231173_s_()) {
                                OPBookHelper.reverseQuestCompletion(quest, player);
                                break;
                            }
                        }
                        default: {
                            GuiQuestBook.selectedQuest = quest;
                            quest.onOpen(gui, player);
                            break;
                        }
                    }
                    break;
                }
                if (gui.isOpBook && Screen.func_231173_s_()) {
                    OPBookHelper.reverseQuestCompletion(quest, player);
                    break;
                }
                GuiQuestBook.selectedQuest = quest;
                quest.onOpen(gui, player);
                break;
            }
        }
        if (Quest.canQuestsBeEdited()) {
            for (ReputationBar reputationBar : new ArrayList<ReputationBar>(this.getReputationBars())) {
                reputationBar.mouseClicked(gui, x, y);
            }
        }
    }
}

