/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.DeathStatsMessage;
import hardcorequesting.common.forge.network.message.PlayerDataSyncMessage;
import hardcorequesting.common.forge.network.message.QuestLineSyncMessage;
import hardcorequesting.common.forge.network.message.TeamStatsMessage;
import hardcorequesting.common.forge.quests.QuestSetsManager;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.Serializable;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuestLine {
    private static QuestLine activeQuestLine;
    private static boolean hasLoadedMainSound;
    public final ReputationManager reputationManager;
    public final GroupTierManager groupTierManager;
    public final QuestingDataManager questingDataManager;
    public final DeathStatsManager deathStatsManager;
    public final QuestSetsManager questSetsManager;
    public final TeamManager teamManager;
    public String mainDescription = "No description";
    private List<ITextProperties> cachedMainDescription;
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation front;
    @Deprecated
    public final Optional<Path> basePath;
    @Deprecated
    public final Optional<Path> dataPath;
    private final List<Serializable> serializables = Lists.newArrayList();
    private final Map<String, FileProvider> tempPaths = Maps.newHashMap();

    private QuestLine(Optional<Path> basePath, Optional<Path> dataPath) {
        if (HardcoreQuestingCore.platform.isClient()) {
            this.resetClient();
        }
        this.basePath = basePath;
        this.dataPath = dataPath;
        this.reputationManager = new ReputationManager(this);
        this.groupTierManager = new GroupTierManager(this);
        this.questingDataManager = new QuestingDataManager(this);
        this.deathStatsManager = new DeathStatsManager(this);
        this.questSetsManager = new QuestSetsManager(this);
        this.teamManager = new TeamManager(this);
        GroupTier.initBaseTiers(this);
        try {
            if (this.basePath.isPresent() && !Files.exists(this.basePath.get(), new LinkOption[0])) {
                Files.createDirectories(this.basePath.get(), new FileAttribute[0]);
            }
            if (this.dataPath.isPresent() && !Files.exists(this.dataPath.get(), new LinkOption[0])) {
                Files.createDirectories(this.dataPath.get(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.add(new Serializable(){

            @Override
            public void save() {
                QuestLine.this.resolve("description.txt", provider -> provider.set(QuestLine.this.mainDescription));
            }

            @Override
            public void load() {
                if (!QuestLine.this.resolve("description.txt", provider -> QuestLine.this.setMainDescription(provider.get().orElse("No description")))) {
                    QuestLine.this.setMainDescription("No description");
                }
            }

            @Override
            public boolean isData() {
                return false;
            }
        });
        this.add(this.questingDataManager.state);
        this.add(this.deathStatsManager);
        this.add(this.reputationManager);
        this.add(this.groupTierManager);
        this.add(this.questSetsManager);
        this.add(this.teamManager);
        this.add(this.questingDataManager.data);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void resetClient() {
        GuiQuestBook.resetBookPosition();
    }

    public void add(Serializable serializable) {
        this.serializables.add(serializable);
    }

    public static QuestLine getActiveQuestLine() {
        return activeQuestLine;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveDataFromServer(PlayerEntity receiver, boolean remote) {
        if (!hasLoadedMainSound) {
            SoundHandler.loadLoreReading(HardcoreQuestingCore.configDir);
            hasLoadedMainSound = true;
        }
        QuestLine questLine = QuestLine.reset(Optional.empty(), Optional.empty());
        questLine.loadAll();
        SoundHandler.loadLoreReading(HardcoreQuestingCore.configDir);
    }

    public static QuestLine reset(Optional<Path> basePath, Optional<Path> dataPath) {
        activeQuestLine = new QuestLine(basePath, dataPath);
        return activeQuestLine;
    }

    public static void sendDataToClient(ServerPlayerEntity player) {
        QuestLine questLine = QuestLine.getActiveQuestLine();
        if (!player.func_146103_bH().getName().equals(player.field_71133_b.func_71214_G())) {
            boolean side = !HardcoreQuestingCore.platform.isClient();
            NetworkManager.sendToPlayer(new PlayerDataSyncMessage(questLine, !side, side, (PlayerEntity)player), player);
            NetworkManager.sendToPlayer(new QuestLineSyncMessage(questLine), player);
            NetworkManager.sendToPlayer(new DeathStatsMessage(side), player);
        }
        NetworkManager.sendToPlayer(new TeamStatsMessage(StreamSupport.stream(questLine.teamManager.getNamedTeams().spliterator(), false)), player);
    }

    public void setMainDescription(String mainDescription) {
        this.mainDescription = mainDescription;
        this.cachedMainDescription = null;
    }

    public void saveAll() {
        for (Serializable serializable : this.serializables) {
            serializable.save();
        }
        SaveHelper.onSave();
    }

    public void saveData() {
        for (Serializable serializable : this.serializables) {
            if (!serializable.isData()) continue;
            serializable.save();
        }
    }

    public void loadAll() {
        HardcoreQuestingCore.LOGGER.info("[HQM] Loading Quest Line, with %d temp paths. (%s)", (Object)this.tempPaths.size(), (Object)this.tempPaths.keySet().stream().sorted().collect(Collectors.joining(", ")));
        for (Serializable serializable : this.serializables) {
            serializable.load();
        }
        SaveHelper.onLoad();
        if (HardcoreQuestingCore.platform.isClient()) {
            this.resetClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextProperties> getMainDescription(GuiBase gui) {
        if (this.cachedMainDescription == null) {
            this.cachedMainDescription = gui.getLinesFromText(Translator.plain(this.mainDescription), 0.7f, 130);
        }
        return this.cachedMainDescription;
    }

    public boolean resolve(String name, Consumer<FileProvider> pathConsumer) {
        Optional<FileProvider> provider = this.resolve(name);
        provider.ifPresent(pathConsumer);
        return provider.isPresent();
    }

    public boolean resolveData(String name, Consumer<FileProvider> pathConsumer) {
        Optional<FileProvider> provider = this.resolveData(name);
        provider.ifPresent(pathConsumer);
        return provider.isPresent();
    }

    public Optional<FileProvider> resolve(String name) {
        Optional<FileProvider> provider = this.basePath.map(path -> new PathProvider(path.resolve(name)));
        if (!provider.isPresent() && this.tempPaths.containsKey(name)) {
            provider = Optional.of(this.tempPaths.get(name));
        }
        return provider;
    }

    public Optional<FileProvider> resolveData(String name) {
        Optional<FileProvider> provider = this.dataPath.map(path -> new PathProvider(path.resolve(name)));
        if (!provider.isPresent() && this.tempPaths.containsKey(name)) {
            provider = Optional.of(this.tempPaths.get(name));
        }
        return provider;
    }

    public void provideTemp(SimpleSerializable serializable, String str) {
        this.provideTemp(serializable.filePath(), str);
    }

    public void provideTemp(String path, final String str) {
        this.tempPaths.put(path, new FileProvider(){
            String s;
            {
                this.s = str;
            }

            @Override
            public Optional<String> get() {
                return Optional.of(this.s);
            }

            @Override
            public void set(String str2) {
                this.s = str2;
            }
        });
    }

    public static class PathProvider
    implements FileProvider {
        private final Path path;

        public PathProvider(Path path) {
            this.path = path;
        }

        @Override
        public Optional<String> get() {
            return SaveHandler.load(this.path);
        }

        @Override
        public void set(String str) {
            SaveHandler.save(this.path, str);
        }
    }

    public static interface FileProvider {
        public Optional<String> get();

        public void set(String var1);
    }
}

