/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuReputationReward;
import hardcorequesting.common.forge.client.interfaces.edit.IntInputMenu;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.QuestDataUpdateMessage;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestSetsManager;
import hardcorequesting.common.forge.quests.QuestTicker;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.RepeatInfo;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.quests.TriggerType;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.reward.CommandRewardList;
import hardcorequesting.common.forge.quests.reward.ItemStackRewardList;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.quests.task.DeathTask;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import hardcorequesting.common.forge.quests.task.reputation.KillReputationTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Quest {
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_TASKS = 3;
    private static final int START_X = 20;
    private static final int TEXT_HEIGHT = 9;
    private static final int TASK_LABEL_START_Y = 100;
    private static final int TASK_MARGIN = 2;
    private static final int TITLE_START_Y = 15;
    private static final int DESCRIPTION_START_Y = 30;
    private static final int TASK_DESCRIPTION_X = 180;
    private static final int TASK_DESCRIPTION_Y = 20;
    private static final int REWARD_STR_Y = 140;
    private static final int REWARD_Y = 150;
    private static final int REWARD_Y_OFFSET = 40;
    private static final int REWARD_OFFSET = 20;
    private static final int ITEM_SIZE = 18;
    private static final int REPUTATION_X = 142;
    private static final int REPUTATION_Y = 133;
    private static final int REPUTATION_Y_LOWER = 150;
    private static final int REPUTATION_SIZE = 16;
    private static final int REPUTATION_SRC_X = 30;
    private static final int REPUTATION_SRC_Y = 82;
    private static final int MAX_REWARD_SLOTS = 7;
    private static final int MAX_SELECT_REWARD_SLOTS = 4;
    @Deprecated
    public static boolean isEditing = false;
    public static UUID speciallySelectedQuestId = null;
    public static QuestTicker clientTicker;
    public static QuestTicker serverTicker;
    private final List<LargeButton> buttons = new ArrayList<LargeButton>();
    private final ScrollBar descriptionScroll;
    private final ScrollBar taskDescriptionScroll;
    private final ScrollBar taskScroll;
    private final List<ScrollBar> scrollBars = new ArrayList<ScrollBar>();
    public int nextTaskId;
    private UUID questId;
    private String name;
    private String description;
    private List<UUID> requirement;
    private List<UUID> reversedRequirement;
    private List<UUID> optionLinks;
    private List<UUID> reversedOptionLinks;
    private List<QuestTask<?>> tasks;
    private List<ITextProperties> cachedDescription;
    private List<ReputationReward> reputationRewards;
    private QuestTask<?> selectedTask;
    private ItemStackRewardList rewards;
    private ItemStackRewardList rewardChoices;
    private CommandRewardList commandRewardList;
    private RepeatInfo repeatInfo = new RepeatInfo(RepeatType.NONE, 0, 0);
    private TriggerType triggerType = TriggerType.NONE;
    private int triggerTasks = 1;
    private int parentRequirementCount = -1;
    private int x;
    private int y;
    private boolean isBig;
    private ItemStack iconStack = ItemStack.field_190927_a;
    private QuestSet set;
    private int selectedReward = -1;
    private int lastClicked;
    private ParentEvaluator enabledParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(UUID playerId, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isCompleted(playerId);
        }
    };
    private ParentEvaluator linkParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(UUID playerId, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isLinkFree(playerId, isLinkFreeCache);
        }
    };
    private ParentEvaluator visibleParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(UUID playerId, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isVisible(playerId, isVisibleCache, isLinkFreeCache) || parent.isCompleted(playerId);
        }
    };

    public Quest(String name, String description, int x, int y, boolean isBig) {
        this.buttons.add(new LargeButton("hqm.quest.claim", 100, 190){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return Quest.this.canPlayerClaimReward(player);
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.this.hasReward(player);
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                NetworkManager.sendToServer(ClientChange.CLAIM_QUEST.build(new Tuple((Object)Quest.this.getQuestId(), (Object)(Quest.this.rewardChoices.isEmpty() ? -1 : Quest.this.selectedReward))));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.manualSubmit", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask.allowManual();
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask.allowManual() && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                NetworkManager.sendToServer(ClientChange.UPDATE_TASK.build(Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.manualDetect", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask.allowDetect();
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask.allowDetect() && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                NetworkManager.sendToServer(ClientChange.UPDATE_TASK.build(Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.requirement", 185, 200){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof DeathTask && Quest.canQuestsBeEdited();
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void onClick(GuiBase gui, PlayerEntity player) {
                DeathTask task = (DeathTask)Quest.this.selectedTask;
                IntInputMenu.display(gui, player, "hqm.deathTask.reqDeathCount", task.getDeathsRequired(), task::setDeaths);
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.requirement", 250, 95){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof KillReputationTask && Quest.canQuestsBeEdited();
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void onClick(GuiBase gui, PlayerEntity player) {
                KillReputationTask task = (KillReputationTask)Quest.this.selectedTask;
                IntInputMenu.display(gui, player, "hqm.mobTask.reqKills", task.getKillsRequirement(), task::setKills);
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.selectTask", 250, 200){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                QuestingData data = QuestingDataManager.getInstance().getQuestingData(player);
                if (data != null && data.selectedQuestId != null && data.selectedQuestId.equals(Quest.this.getQuestId())) {
                    return data.selectedTask != Quest.this.selectedTask.getId();
                }
                return false;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.this.selectedTask instanceof ConsumeItemTask && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void onClick(GuiBase gui, PlayerEntity player) {
                QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).selectedQuestId = Quest.this.getQuestId();
                QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).selectedTask = Quest.this.selectedTask.getId();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.hqm:item_barrel.selectedTask", new Object[]{Quest.this.selectedTask.getDescription()}).func_240699_a_(TextFormatting.GREEN), false);
                GeneralUsage.sendBookSelectTaskUpdate(Quest.this.selectedTask);
            }
        });
        boolean itemIds = false;
        for (final TaskType taskType : TaskType.values()) {
            this.buttons.add(new LargeButton(taskType.getLangKeyName(), taskType.getLangKeyDescription(), 185 + taskType.ordinal() % 2 * 65, 50 + taskType.ordinal() / 2 * 20){

                @Override
                public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                    return true;
                }

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public boolean isVisible(GuiBase gui, PlayerEntity player) {
                    return Quest.canQuestsBeEdited() && Quest.this.selectedTask == null && ((GuiQuestBook)gui).getCurrentMode() == EditMode.TASK;
                }

                @Override
                public void onClick(GuiBase gui, PlayerEntity player) {
                    taskType.addTask(Quest.this);
                }
            });
        }
        this.descriptionScroll = new ScrollBar(155, 28, 64, 249, 102, 20){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isVisible(GuiBase gui) {
                return Quest.this.getCachedDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.taskDescriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isVisible(GuiBase gui) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask.getCachedLongDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.taskDescriptionScroll);
        this.taskScroll = new ScrollBar(155, 100, 29, 242, 102, 20){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean isVisible(GuiBase gui) {
                return Quest.this.tasks.size() > 3 && Quest.this.getVisibleTasks(gui) > 3;
            }
        };
        this.scrollBars.add(this.taskScroll);
        do {
            this.questId = UUID.randomUUID();
        } while (Quest.getQuests().containsKey(this.questId));
        this.name = name;
        this.x = x;
        this.y = y;
        this.isBig = isBig;
        this.description = description;
        this.requirement = new ArrayList<UUID>();
        this.reversedRequirement = new ArrayList<UUID>();
        this.optionLinks = new ArrayList<UUID>();
        this.reversedOptionLinks = new ArrayList<UUID>();
        this.tasks = new ArrayList();
        this.rewards = new ItemStackRewardList();
        this.rewardChoices = new ItemStackRewardList();
        this.commandRewardList = new CommandRewardList();
        QuestSetsManager.getInstance().quests.put(this.getQuestId(), this);
    }

    public static Map<UUID, Quest> getQuests() {
        return QuestSetsManager.getInstance().quests;
    }

    public static List<QuestSet> getQuestSets() {
        return QuestLine.getActiveQuestLine().questSetsManager.questSets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<ITextProperties> getMainDescription(GuiBase gui) {
        return QuestLine.getActiveQuestLine().getMainDescription(gui);
    }

    public static String getRawMainDescription() {
        return QuestLine.getActiveQuestLine().mainDescription;
    }

    public static Quest getQuest(UUID questId) {
        if (questId == null) {
            return null;
        }
        return QuestSetsManager.getInstance().quests.get(questId);
    }

    public static void addItems(PlayerEntity player, List<ItemStack> itemsToAdd) {
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            Iterator<ItemStack> iterator = itemsToAdd.iterator();
            while (iterator.hasNext()) {
                int amount;
                ItemStack nextStack = iterator.next();
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b()) {
                    amount = Math.min(nextStack.func_77976_d(), nextStack.func_190916_E());
                    ItemStack copyStack = nextStack.func_77946_l();
                    copyStack.func_190920_e(amount);
                    player.field_71071_by.field_70462_a.set(i, (Object)copyStack);
                    nextStack.func_190918_g(amount);
                    if (nextStack.func_190916_E() > 0) continue block0;
                    iterator.remove();
                    continue block0;
                }
                if (!stack.func_185136_b(nextStack) || !ItemStack.func_77970_a((ItemStack)nextStack, (ItemStack)stack)) continue;
                amount = Math.min(nextStack.func_77976_d() - stack.func_190916_E(), nextStack.func_190916_E());
                stack.func_190917_f(amount);
                nextStack.func_190918_g(amount);
                if (nextStack.func_190916_E() > 0) continue block0;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static void removeQuest(Quest quest) {
        for (UUID requirementId : quest.requirement) {
            Quest.getQuest((UUID)requirementId).reversedRequirement.remove(quest.getQuestId());
        }
        for (UUID optionLinkId : quest.optionLinks) {
            Quest.getQuest((UUID)optionLinkId).reversedOptionLinks.remove(quest.getQuestId());
        }
        quest.tasks.forEach(QuestTask::onDelete);
        quest.setQuestSet(null);
        QuestSetsManager.getInstance().quests.remove(quest.getQuestId());
        for (Quest other : QuestSetsManager.getInstance().quests.values()) {
            UUID element;
            Iterator<UUID> iterator = other.requirement.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!element.equals(quest.getQuestId())) continue;
                iterator.remove();
            }
            iterator = other.optionLinks.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!element.equals(quest.getQuestId())) continue;
                iterator.remove();
            }
        }
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public NonNullList<ItemStack> getReward() {
        return this.rewards.toList();
    }

    public void setReward(NonNullList<ItemStack> reward) {
        this.rewards.set(reward);
    }

    public NonNullList<ItemStack> getRewardChoice() {
        return this.rewardChoices.toList();
    }

    public void setRewardChoice(NonNullList<ItemStack> rewardChoice) {
        this.rewardChoices.set(rewardChoice);
    }

    public String[] getCommandRewardsAsStrings() {
        return this.commandRewardList.asStrings();
    }

    public void setCommandRewards(String[] commands) {
        this.commandRewardList.set(commands);
    }

    public void addCommand(String command) {
        this.commandRewardList.add(command);
    }

    public void editCommand(int id, String command) {
        this.commandRewardList.set(id, command);
    }

    public void removeCommand(int id) {
        this.commandRewardList.remove(id);
    }

    public RepeatInfo getRepeatInfo() {
        return this.repeatInfo;
    }

    public void setRepeatInfo(RepeatInfo repeatInfo) {
        this.repeatInfo = repeatInfo;
    }

    public void addRequirement(UUID requirementQuestId) {
        if (requirementQuestId.equals(this.questId)) {
            return;
        }
        if (this.lookForId(requirementQuestId, false) || this.lookForId(requirementQuestId, true)) {
            return;
        }
        Quest quest = QuestSetsManager.getInstance().quests.get(requirementQuestId);
        if (quest != null) {
            this.requirement.add(quest.getQuestId());
            quest.reversedRequirement.add(this.getQuestId());
            SaveHelper.add(EditType.REQUIREMENT_CHANGE);
        }
    }

    private boolean lookForId(UUID questId, boolean reversed) {
        return this.lookForId(questId, new HashSet<UUID>(), reversed);
    }

    private boolean lookForId(UUID questId, Set<UUID> visited, boolean reversed) {
        if (visited.add(this.getQuestId())) {
            List<UUID> currentRequirements = reversed ? this.reversedRequirement : this.requirement;
            for (UUID id : currentRequirements) {
                if (!id.equals(questId) && !QuestSetsManager.getInstance().quests.get(id).lookForId(questId, visited, reversed)) continue;
                return true;
            }
        }
        return false;
    }

    public void clearRequirements() {
        SaveHelper.add(EditType.REQUIREMENT_REMOVE, this.requirement.size());
        for (UUID questId : this.requirement) {
            QuestSetsManager.getInstance().quests.get((Object)questId).reversedRequirement.remove(this.getQuestId());
        }
        this.requirement.clear();
    }

    public void addOptionLink(UUID optionLinkId) {
        if (optionLinkId.equals(this.questId)) {
            return;
        }
        for (UUID currentOptionId : this.optionLinks) {
            if (!currentOptionId.equals(optionLinkId)) continue;
            return;
        }
        for (UUID currentReverseOptionsId : this.reversedOptionLinks) {
            if (!currentReverseOptionsId.equals(optionLinkId)) continue;
            return;
        }
        Quest quest = QuestSetsManager.getInstance().quests.get(optionLinkId);
        if (quest != null) {
            SaveHelper.add(EditType.OPTION_CHANGE);
            this.optionLinks.add(quest.getQuestId());
            quest.reversedOptionLinks.add(this.getQuestId());
        }
    }

    public void clearOptionLinks() {
        SaveHelper.add(EditType.OPTION_REMOVE, this.optionLinks.size());
        for (UUID questId : this.reversedOptionLinks) {
            QuestSetsManager.getInstance().quests.get((Object)questId).optionLinks.remove(this.getQuestId());
        }
        for (UUID questId : this.optionLinks) {
            QuestSetsManager.getInstance().quests.get((Object)questId).reversedOptionLinks.remove(this.getQuestId());
        }
        this.reversedRequirement.clear();
        this.optionLinks.clear();
    }

    public QuestData getQuestData(PlayerEntity player) {
        return QuestingDataManager.getInstance().getQuestingData(player).getQuestData(this.getQuestId());
    }

    public QuestData getQuestData(UUID uuid) {
        return QuestingDataManager.getInstance().getQuestingData(uuid).getQuestData(this.getQuestId());
    }

    public void setQuestData(PlayerEntity player, QuestData data) {
        QuestingDataManager.getInstance().getQuestingData(player).setQuestData(this.getQuestId(), data);
    }

    public UUID getQuestId() {
        return this.questId;
    }

    public void setId(UUID questId) {
        if (this.getQuestSet() != null) {
            this.getQuestSet().removeQuest(this);
        }
        Quest.getQuests().remove(this.getQuestId());
        this.questId = questId;
        Quest.getQuests().put(this.getQuestId(), this);
        if (this.getQuestSet() != null) {
            this.getQuestSet().addQuest(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible(PlayerEntity player) {
        return this.isVisible(player.func_110124_au());
    }

    boolean isVisible(PlayerEntity player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isVisible(player.func_110124_au(), isVisibleCache, isLinkFreeCache);
    }

    public boolean isVisible(UUID uuid) {
        return this.isVisible(uuid, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isVisible(UUID playerId, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        Boolean cachedResult = isVisibleCache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.triggerType.isQuestVisible(this, playerId) && this.isLinkFree(playerId, isLinkFreeCache) && this.visibleParentEvaluator.isValid(playerId, isVisibleCache, isLinkFreeCache);
        isVisibleCache.put(this, result);
        return result;
    }

    public boolean isEnabled(PlayerEntity player) {
        return this.isEnabled(player.func_110124_au());
    }

    boolean isEnabled(PlayerEntity player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isEnabled(player.func_110124_au(), true, isVisibleCache, isLinkFreeCache);
    }

    public boolean isEnabled(UUID playerId) {
        return this.isEnabled(playerId, true);
    }

    public boolean isEnabled(UUID playerId, boolean requiresVisible) {
        return this.isEnabled(playerId, requiresVisible, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isEnabled(UUID playerId, boolean requiresVisible, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.set != null && this.isLinkFree(playerId, isLinkFreeCache) && (!requiresVisible || this.triggerType.doesWorkAsInvisible() || this.isVisible(playerId, isVisibleCache, isLinkFreeCache)) && this.enabledParentEvaluator.isValid(playerId, isVisibleCache, isLinkFreeCache);
    }

    public boolean isLinkFree(PlayerEntity player) {
        return this.isLinkFree(player.func_110124_au(), new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(PlayerEntity player, Map<Quest, Boolean> cache) {
        return this.isLinkFree(player.func_110124_au(), cache);
    }

    public boolean isLinkFree(UUID uuid) {
        return this.isLinkFree(uuid, new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(UUID playerId, Map<Quest, Boolean> cache) {
        Boolean cachedResult = cache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = true;
        for (UUID optionLinkId : this.optionLinks) {
            if (!QuestSetsManager.getInstance().quests.get(optionLinkId).isCompleted(playerId)) continue;
            result = false;
            break;
        }
        if (result) {
            for (UUID optionLinkId : this.reversedOptionLinks) {
                if (!QuestSetsManager.getInstance().quests.get(optionLinkId).isCompleted(playerId)) continue;
                result = false;
                break;
            }
        }
        if (result) {
            result = this.linkParentEvaluator.isValid(playerId, null, cache);
        }
        cache.put(this, result);
        return result;
    }

    public List<ReputationReward> getReputationRewards() {
        return this.reputationRewards;
    }

    public void setReputationRewards(List<ReputationReward> reputationRewards) {
        this.reputationRewards = reputationRewards;
    }

    public boolean isAvailable(PlayerEntity player) {
        return this.isAvailable(player.func_110124_au());
    }

    public boolean isCompleted(PlayerEntity player) {
        return this.isCompleted(player.func_110124_au());
    }

    public boolean isAvailable(UUID playerId) {
        QuestData data = this.getQuestData(playerId);
        return data != null && data.available;
    }

    public boolean isCompleted(UUID uuid) {
        QuestData data = this.getQuestData(uuid);
        return data != null && data.completed;
    }

    public List<Quest> getRequirements() {
        return this.requirement.stream().map(QuestSetsManager.getInstance().quests::get).collect(Collectors.toList());
    }

    public int getGuiX() {
        return this.x;
    }

    public int getGuiY() {
        return this.y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getGuiU() {
        return this.isBig ? 195 : 170;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getGuiV(PlayerEntity player, int x, int y) {
        return this.isEnabled(player) && this.isMouseInObject(x, y) ? this.getGuiH() : 0;
    }

    public int getGuiW() {
        return this.isBig ? 31 : 25;
    }

    public int getGuiH() {
        return this.isBig ? 37 : 30;
    }

    public int getGuiCenterX() {
        return this.getGuiX() + this.getGuiW() / 2;
    }

    public void setGuiCenterX(int x) {
        this.x = x - this.getGuiW() / 2;
    }

    public int getGuiCenterY() {
        return this.getGuiY() + this.getGuiH() / 2;
    }

    public void setGuiCenterY(int y) {
        this.y = y - this.getGuiH() / 2;
    }

    public ItemStack getIconStack() {
        return this.iconStack;
    }

    public void setIconStack(ItemStack iconStack) {
        this.iconStack = iconStack;
        if (iconStack != null) {
            iconStack.func_190920_e(1);
        }
    }

    public boolean useBigIcon() {
        return this.isBig;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public int getTriggerTasks() {
        return this.triggerTasks;
    }

    public void setTriggerTasks(int triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFilter(PlayerEntity player, int tick) {
        if (Quest.canQuestsBeEdited() && !this.isVisible(player)) {
            return HQMConfig.QUEST_INVISIBLE;
        }
        if (!this.isEnabled(player)) {
            return HQMConfig.QUEST_DISABLED;
        }
        if (!this.isAvailable(player) && !this.hasReward(player)) {
            return this.getRepeatInfo().getType() == RepeatType.NONE ? HQMConfig.QUEST_COMPLETE : HQMConfig.QUEST_COMPLETE_REPEATABLE;
        }
        if (HQMConfig.getInstance().Interface.Quests.SINGLE_COLOUR) {
            return HQMConfig.QUEST_AVAILABLE;
        }
        int componentBase = 187;
        int componentVariable = (int)(Math.abs(Math.sin((float)tick / 5.0f)) * 68.0);
        int component = componentBase + componentVariable;
        int red = this.hasReward(player) ? componentBase : component;
        int green = this.hasReward(player) ? component * 3 / 4 : component;
        int blue = component;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isMouseInObject(int x, int y) {
        if (this.getGuiX() > x || x > this.getGuiX() + this.getGuiW() || this.getGuiY() > y || y > this.getGuiY() + this.getGuiH()) {
            return false;
        }
        Polygon poly = new Polygon();
        if (this.isBig) {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 1);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 36);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 27);
        } else {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 2);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 21);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 21);
        }
        return poly.contains(x, y);
    }

    @OnlyIn(value=Dist.CLIENT)
    private List<ITextProperties> getCachedDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(Translator.plain(this.description), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawMenu(MatrixStack matrices, GuiQuestBook gui, PlayerEntity player, int mX, int mY) {
        if (!Quest.canQuestsBeEdited() && this.selectedTask != null && !this.selectedTask.isVisible(player)) {
            this.selectedTask = this.tasks.size() > 0 ? this.tasks.get(0) : null;
        }
        gui.drawString(matrices, Translator.plain(this.name), 20, 15, 0x404040);
        int startLine = this.descriptionScroll.isVisible(gui) ? Math.round((float)(this.getCachedDescription(gui).size() - 7) * this.descriptionScroll.getScroll()) : 0;
        gui.drawString(matrices, this.getCachedDescription(gui), startLine, 7, 20, 30, 0.7f, 0x404040);
        int id = 0;
        int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
        int end = Math.min(start + 3, this.tasks.size());
        for (int i = start; i < end; ++i) {
            QuestTask<?> task = this.tasks.get(i);
            boolean isVisible = task.isVisible(player);
            if (!isVisible && !Quest.canQuestsBeEdited()) continue;
            boolean completed = task.isCompleted(player);
            int yPos = this.getTaskY(gui, id);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(task.getDescription()), 9, mX, mY);
            boolean isSelected = task == this.selectedTask;
            gui.drawString(matrices, Translator.plain(task.getDescription()), 20, yPos, completed ? (isSelected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (isSelected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : (isVisible ? 0x404040 : 0xDDDDDD))));
            ++id;
        }
        if (this.selectedReward != -1 && !this.hasReward(player)) {
            this.selectedReward = -1;
        }
        if (!this.rewards.isEmpty() || Quest.canQuestsBeEdited()) {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.quest.rewards", new Object[0]), 20, 140, 0x404040);
            this.drawRewards(gui, this.rewards.toList(), 150, -1, mX, mY, 7);
            if (!this.rewardChoices.isEmpty() || Quest.canQuestsBeEdited()) {
                gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.quest.pickOne", new Object[0]), 20, 180, 0x404040);
                this.drawRewards(gui, this.rewardChoices.toList(), 190, this.selectedReward, mX, mY, 4);
            }
        } else if (!this.rewardChoices.isEmpty()) {
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.quest.pickOneReward", new Object[0]), 20, 140, 0x404040);
            this.drawRewards(gui, this.rewardChoices.toList(), 150, this.selectedReward, mX, mY, 4);
        }
        for (LargeButton button : this.buttons) {
            button.draw(matrices, gui, player, mX, mY);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.draw(gui);
        }
        boolean claimed = this.getQuestData((PlayerEntity)player).claimed;
        int y = this.rewards == null || this.rewards.size() <= 7 - (Quest.canQuestsBeEdited() ? 2 : 1) ? 150 : 133;
        boolean hover = gui.inBounds(142, y, 16, 16, mX, mY);
        if (this.reputationRewards != null || Quest.canQuestsBeEdited()) {
            int foregroundIndex;
            int backgroundIndex;
            if (this.reputationRewards == null) {
                claimed = true;
            }
            int n = claimed ? 2 : (backgroundIndex = hover ? 1 : 0);
            if (claimed) {
                foregroundIndex = 3;
            } else {
                boolean positive = false;
                boolean negative = false;
                for (ReputationReward reputationReward : this.reputationRewards) {
                    if (reputationReward.getValue() < 0) {
                        negative = true;
                        continue;
                    }
                    if (reputationReward.getValue() <= 0) continue;
                    positive = true;
                }
                foregroundIndex = negative == positive ? 2 : (positive ? 0 : 1);
            }
            gui.drawRect(142, y, 30 + backgroundIndex * 16, 82, 16, 16);
            gui.drawRect(142, y, 30 + (foregroundIndex += 3) * 16, 82, 16, 16);
        }
        if (this.selectedTask != null) {
            List<ITextProperties> description = this.selectedTask.getCachedLongDescription(gui);
            int taskStartLine = this.taskDescriptionScroll.isVisible(gui) ? Math.round((float)(description.size() - 7) * this.taskDescriptionScroll.getScroll()) : 0;
            gui.drawString(matrices, description, taskStartLine, 7, 180, 20, 0.7f, 0x404040);
            this.selectedTask.getGraphic().draw(matrices, gui, player, mX, mY);
        } else if (Quest.canQuestsBeEdited() && gui.getCurrentMode() == EditMode.TASK) {
            gui.drawString(matrices, gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.quest.createTasks", new Object[0]), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        }
        if (!this.rewards.isEmpty() || Quest.canQuestsBeEdited()) {
            this.drawRewardMouseOver(matrices, gui, this.rewards.toList(), 150, -1, mX, mY);
            if (!this.rewardChoices.isEmpty() || Quest.canQuestsBeEdited()) {
                this.drawRewardMouseOver(matrices, gui, this.rewardChoices.toList(), 190, this.selectedReward, mX, mY);
            }
        } else if (!this.rewardChoices.isEmpty()) {
            this.drawRewardMouseOver(matrices, gui, this.rewardChoices.toList(), 150, this.selectedReward, mX, mY);
        }
        for (LargeButton button : this.buttons) {
            button.renderTooltip(matrices, gui, player, mX, mY);
        }
        if (this.reputationRewards != null && hover) {
            ArrayList<Object> str = new ArrayList<Object>();
            for (ReputationReward reputationReward : this.reputationRewards) {
                if (reputationReward.getValue() == 0 || reputationReward.getReward() == null || !((Reputation)reputationReward.getReward()).isValid()) continue;
                str.add(Translator.plain(reputationReward.getLabel()));
            }
            List<ITextProperties> commentLines = gui.getLinesFromText((ITextProperties)Translator.translatable("hqm.quest.partyRepReward" + (claimed ? "Claimed" : ""), new Object[0]), 1.0f, 200);
            if (commentLines != null) {
                str.add(ITextProperties.field_240651_c_);
                for (ITextProperties commentLine : commentLines) {
                    str.add(Translator.text(Translator.rawString(commentLine), GuiColor.GRAY));
                }
            }
            gui.renderTooltipL(matrices, str, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getVisibleTasks(GuiBase gui) {
        if (Quest.canQuestsBeEdited()) {
            return this.tasks.size();
        }
        int count = 0;
        for (QuestTask<?> task : this.tasks) {
            if (!task.isVisible(((GuiQuestBook)gui).getPlayer())) continue;
            ++count;
        }
        return count;
    }

    private boolean canPlayerClaimReward(PlayerEntity player) {
        return this.hasReward(player) && (this.rewardChoices.isEmpty() || this.selectedReward != -1) && this.isEnabled(player);
    }

    public boolean hasReward(PlayerEntity player) {
        return this.getQuestData(player).getReward(player) && (!this.rewards.isEmpty() || !this.rewardChoices.isEmpty()) || this.getQuestData(player).canClaim() && (this.reputationRewards != null || !this.commandRewardList.isEmpty());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawRewards(GuiQuestBook gui, NonNullList<ItemStack> rewards, int y, int selected, int mX, int mY, int max) {
        rewards = this.getEditFriendlyRewards(rewards, max);
        for (int i = 0; i < rewards.size(); ++i) {
            gui.drawItemStack((ItemStack)rewards.get(i), 20 + i * 20, y, mX, mY, selected == i);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawRewardMouseOver(MatrixStack matrices, GuiQuestBook gui, NonNullList<ItemStack> rewards, int y, int selected, int mX, int mY) {
        if (rewards != null) {
            for (int i = 0; i < rewards.size(); ++i) {
                if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
                if (((ItemStack)rewards.get(i)).func_190926_b()) break;
                GuiQuestBook.setSelectedStack((ItemStack)rewards.get(i));
                List str = ((ItemStack)rewards.get(i)).func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                ArrayList list2 = Lists.newArrayList((Iterable)str);
                if (selected == i) {
                    list2.add(ITextProperties.field_240651_c_);
                    list2.add(Translator.translatable("hqm.quest.selected", GuiColor.GREEN, new Object[0]));
                }
                gui.renderTooltipL(matrices, list2, gui.getLeft() + mX, gui.getTop() + mY);
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private NonNullList<ItemStack> getEditFriendlyRewards(NonNullList<ItemStack> rewards, int max) {
        if (rewards.isEmpty()) {
            return NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        }
        if (Quest.canQuestsBeEdited() && rewards.size() < max) {
            NonNullList rewardsWithEmpty = NonNullList.func_191196_a();
            rewardsWithEmpty.addAll(rewards);
            rewardsWithEmpty.add((Object)ItemStack.field_190927_a);
            return rewardsWithEmpty;
        }
        return rewards;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleRewardClick(GuiQuestBook gui, PlayerEntity player, NonNullList<ItemStack> rawRewards, int y, boolean canSelect, int mX, int mY) {
        NonNullList<ItemStack> rewards = this.getEditFriendlyRewards(rawRewards, canSelect ? 4 : 7);
        boolean doubleClick = false;
        for (int i = 0; i < rewards.size(); ++i) {
            if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
            if (gui.getCurrentMode() == EditMode.NORMAL) {
                int lastDiff = player.field_70173_aa - this.lastClicked;
                if (lastDiff < 0) {
                    this.lastClicked = player.field_70173_aa;
                } else if (lastDiff < 6) {
                    doubleClick = true;
                } else {
                    this.lastClicked = player.field_70173_aa;
                }
            }
            if (canSelect && (!Quest.canQuestsBeEdited() || gui.getCurrentMode() == EditMode.NORMAL && !doubleClick)) {
                if (this.selectedReward == i) {
                    this.selectedReward = -1;
                    break;
                }
                if (((ItemStack)rewards.get(i)).func_190926_b()) break;
                this.selectedReward = i;
                break;
            }
            if (!Quest.canQuestsBeEdited()) break;
            if (gui.getCurrentMode() == EditMode.DELETE) {
                if (i >= rawRewards.size()) break;
                rawRewards.remove(i);
                if (canSelect && this.selectedReward != -1) {
                    if (this.selectedReward == i) {
                        this.selectedReward = -1;
                    } else if (this.selectedReward > i) {
                        --this.selectedReward;
                    }
                }
                if (canSelect) {
                    this.rewardChoices.set(rawRewards);
                } else {
                    this.rewards.set(rawRewards);
                }
                SaveHelper.add(EditType.REWARD_REMOVE);
                break;
            }
            if (gui.getCurrentMode() != EditMode.ITEM && !doubleClick) break;
            int id = i;
            PickItemMenu.display(gui, player, rewards.get(i), PickItemMenu.Type.ITEM, ((ItemStack)rewards.get(i)).func_190926_b() ? 1 : ((ItemStack)rewards.get(i)).func_190916_E(), result -> this.setReward((ItemStack)result.getWithAmount(), id, !canSelect));
            break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getTaskY(GuiQuestBook gui, int id) {
        return 100 + id * 11;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClick(GuiQuestBook gui, PlayerEntity player, int mX, int mY, int b) {
        if (b == 1) {
            gui.loadMap();
        } else {
            int id = 0;
            int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
            int end = Math.min(start + 3, this.tasks.size());
            for (int i = start; i < end; ++i) {
                QuestTask<?> task = this.tasks.get(i);
                if (!task.isVisible(player) && !Quest.canQuestsBeEdited()) continue;
                if (gui.inBounds(20, this.getTaskY(gui, id), gui.getStringWidth(task.getDescription()), 9, mX, mY)) {
                    if (gui.isOpBook && Screen.func_231173_s_()) {
                        OPBookHelper.reverseTaskCompletion(task, player);
                        return;
                    }
                    if (Quest.canQuestsBeEdited() && gui.getCurrentMode() == EditMode.TASK) {
                        gui.setCurrentMode(EditMode.NORMAL);
                    }
                    if (Quest.canQuestsBeEdited() && (gui.getCurrentMode() == EditMode.RENAME || gui.getCurrentMode() == EditMode.DELETE)) {
                        if (gui.getCurrentMode() == EditMode.RENAME) {
                            TextMenu.display(gui, player, task.getDescription(), true, task::setDescription);
                            break;
                        }
                        if (gui.getCurrentMode() != EditMode.DELETE) break;
                        if (i + 1 < this.tasks.size()) {
                            this.tasks.get(i + 1).clearRequirements();
                            if (i > 0) {
                                this.tasks.get(i + 1).addRequirement(this.tasks.get(i - 1));
                            }
                        }
                        if (this.selectedTask == task) {
                            this.selectedTask = null;
                        }
                        task.onDelete();
                        this.tasks.remove(i);
                        this.nextTaskId = 0;
                        for (QuestTask<?> questTask : this.tasks) {
                            questTask.updateId();
                        }
                        this.addTaskData(this.getQuestData(player));
                        SaveHelper.add(EditType.TASK_REMOVE);
                        break;
                    }
                    if (task == this.selectedTask) {
                        this.selectedTask = null;
                        break;
                    }
                    this.selectedTask = task;
                    this.taskDescriptionScroll.resetScroll();
                    break;
                }
                ++id;
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(gui, mX, mY);
            }
            if (!this.rewards.isEmpty() || Quest.canQuestsBeEdited()) {
                this.handleRewardClick(gui, player, this.rewards.toList(), 150, false, mX, mY);
                if (!this.rewardChoices.isEmpty() || Quest.canQuestsBeEdited()) {
                    this.handleRewardClick(gui, player, this.rewardChoices.toList(), 190, true, mX, mY);
                }
            } else if (!this.rewardChoices.isEmpty()) {
                this.handleRewardClick(gui, player, this.rewardChoices.toList(), 150, true, mX, mY);
            }
            if (this.selectedTask != null) {
                this.selectedTask.getGraphic().onClick(gui, player, mX, mY, b);
            }
            for (LargeButton button : this.buttons) {
                if (!button.inButtonBounds(gui, mX, mY) || !button.isVisible(gui, player) || !button.isEnabled(gui, player)) continue;
                button.onClick(gui, player);
                break;
            }
            if (gui.getCurrentMode() == EditMode.RENAME) {
                if (gui.inBounds(20, 15, 140, 9, mX, mY)) {
                    TextMenu.display(gui, player, this.getName(), true, this::setName);
                } else if (gui.inBounds(20, 30, 130, 44, mX, mY)) {
                    TextMenu.display(gui, player, this.getDescription(), false, this::setDescription);
                } else if (this.selectedTask != null && gui.inBounds(180, 20, 130, 44, mX, mY)) {
                    TextMenu.display(gui, player, this.selectedTask.getLongDescription(), false, this.selectedTask::setLongDescription);
                }
            }
            if (Quest.canQuestsBeEdited() && this.selectedTask != null && gui.getCurrentMode() == EditMode.TASK) {
                this.selectedTask = null;
            }
            if (Quest.canQuestsBeEdited() && gui.getCurrentMode() == EditMode.REPUTATION_REWARD) {
                int y;
                int n = this.rewards == null || this.rewards.size() <= 7 - (Quest.canQuestsBeEdited() ? 2 : 1) ? 150 : (y = 133);
                if (gui.inBounds(142, y, 16, 16, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuReputationReward((GuiBase)gui, player, this.reputationRewards));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDrag(GuiQuestBook gui, PlayerEntity player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onDrag(gui, mX, mY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRelease(GuiQuestBook gui, PlayerEntity player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onRelease(gui, mX, mY);
        }
    }

    public QuestData createData(int players) {
        QuestData data = new QuestData(players);
        if (!this.addTaskData(data)) {
            return null;
        }
        return data;
    }

    public boolean addTaskData(QuestData data) {
        data.tasks = new TaskData[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            data.tasks[i] = this.tasks.get(i).newQuestData();
        }
        return true;
    }

    public void initRewards(int players, QuestData data) {
        data.reward = new boolean[players];
    }

    public List<QuestTask<?>> getTasks() {
        return this.tasks;
    }

    public void sendUpdatedDataToTeam(PlayerEntity player) {
        this.sendUpdatedDataToTeam(QuestingDataManager.getInstance().getQuestingData(player).getTeam());
    }

    public void sendUpdatedDataToTeam(UUID playerId) {
        this.sendUpdatedDataToTeam(QuestingDataManager.getInstance().getQuestingData(playerId).getTeam());
    }

    public void sendUpdatedDataToTeam(Team team) {
        MinecraftServer server = HardcoreQuestingCore.getServer();
        if (server == null || !server.func_213162_bc()) {
            throw new IllegalStateException("Tried sending data to players from the client-side. Something is being called client-side when it shouldn't be!");
        }
        for (PlayerEntry entry : team.getPlayers()) {
            this.sendUpdatedData(entry.getPlayerMP());
        }
    }

    private void sendUpdatedData(ServerPlayerEntity player) {
        if (player == null) {
            return;
        }
        QuestDataUpdateMessage update = new QuestDataUpdateMessage(this.getQuestId(), QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).getTeam().getPlayerCount(), QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).getQuestData(this.getQuestId()));
        NetworkManager.sendToPlayer(update, player);
    }

    public void claimReward(PlayerEntity player, int selectedReward) {
        if (this.hasReward(player)) {
            boolean sentInfo = false;
            if (!(!this.getQuestData(player).getReward(player) || this.rewards.isEmpty() && this.rewardChoices.isEmpty())) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (!this.rewards.isEmpty()) {
                    for (ItemStack stack : this.rewards.toList()) {
                        items.add(stack.func_77946_l());
                    }
                }
                if (!this.rewardChoices.isEmpty()) {
                    if (selectedReward >= 0 && selectedReward < this.rewardChoices.size()) {
                        items.add(((ItemStack)this.rewardChoices.getReward(selectedReward)).func_77946_l());
                    } else {
                        return;
                    }
                }
                ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
                for (Object stack : items) {
                    boolean added = false;
                    for (ItemStack stack1 : itemsToAdd) {
                        if (!stack.func_185136_b(stack1) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack1)) continue;
                        stack1.func_190917_f(stack.func_190916_E());
                        added = true;
                        break;
                    }
                    if (added) continue;
                    itemsToAdd.add(stack.func_77946_l());
                }
                ArrayList<ItemStack> itemsToCheck = new ArrayList<ItemStack>();
                for (ItemStack stack : itemsToAdd) {
                    itemsToCheck.add(stack.func_77946_l());
                }
                block4: for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    for (ItemStack stack1 : itemsToCheck) {
                        if (stack1.func_190916_E() <= 0) continue;
                        ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                        if (stack == ItemStack.field_190927_a) {
                            stack1.func_190918_g(stack1.func_77976_d());
                            continue block4;
                        }
                        if (!stack.func_185136_b(stack1) || !ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack)) continue;
                        stack1.func_190918_g(stack1.func_77976_d() - stack.func_190916_E());
                        continue block4;
                    }
                }
                boolean valid = true;
                for (ItemStack stack : itemsToCheck) {
                    if (stack.func_190916_E() <= 0) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    Quest.addItems(player, itemsToAdd);
                    player.field_71071_by.func_70296_d();
                    QuestData data = this.getQuestData(player);
                    Team team = QuestingDataManager.getInstance().getQuestingData(player).getTeam();
                    if (!team.isSingle() && team.getRewardSetting() == RewardSetting.ANY) {
                        Arrays.fill(data.reward, false);
                        this.sendUpdatedDataToTeam(player);
                    } else {
                        data.claimReward(player);
                        if (player instanceof ServerPlayerEntity) {
                            this.sendUpdatedData((ServerPlayerEntity)player);
                        }
                    }
                    sentInfo = true;
                } else {
                    return;
                }
            }
            if (this.reputationRewards != null && this.getQuestData(player).canClaim()) {
                QuestingDataManager.getInstance().getQuestingData(player).getTeam().receiveAndSyncReputation(this, this.reputationRewards);
                EventTrigger.instance().onReputationChange(new EventTrigger.ReputationEvent(player));
                sentInfo = true;
            }
            if (this.commandRewardList != null && this.getQuestData(player).canClaim()) {
                this.commandRewardList.executeAll(player);
                sentInfo = true;
            }
            this.getQuestData((PlayerEntity)player).claimed = true;
            if (sentInfo) {
                SoundHandler.play(Sounds.COMPLETE, player);
            }
        }
    }

    public void setBigIcon(boolean b) {
        this.isBig = b;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    private void setReward(ItemStack stack, int id, boolean isStandardReward) {
        ItemStackRewardList rewardList;
        ItemStackRewardList itemStackRewardList = rewardList = isStandardReward ? this.rewards : this.rewardChoices;
        if (id < rewardList.size()) {
            rewardList.set(id, stack);
            SaveHelper.add(EditType.REWARD_CHANGE);
        } else {
            SaveHelper.add(EditType.REWARD_CREATE);
            rewardList.add(stack);
        }
    }

    public boolean hasSameSetAs(Quest child) {
        return child.set.equals(this.set);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScroll(GuiQuestBook gui, double x, double y, double scroll) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(gui, x, y, scroll);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onOpen(GuiQuestBook gui, PlayerEntity player) {
        if (this.selectedTask == null) {
            for (QuestTask<?> task : this.tasks) {
                if (task.isCompleted(player)) continue;
                this.selectedTask = task;
                break;
            }
        }
        if (this.selectedTask == null && this.tasks.size() > 0) {
            this.selectedTask = this.tasks.get(0);
        }
        QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).selectedQuestId = this.getQuestId();
        int n = QuestingDataManager.getInstance().getQuestingData((PlayerEntity)player).selectedTask = this.selectedTask == null ? -1 : this.selectedTask.getId();
        if (this.selectedTask != null) {
            GeneralUsage.sendBookSelectTaskUpdate(this.selectedTask);
        }
        EventTrigger.instance().onQuestSelected(new EventTrigger.QuestSelectedEvent(player, this.getQuestId()));
    }

    public boolean hasSet(QuestSet selectedSet) {
        return this.set != null && this.set.equals(selectedSet);
    }

    public void mergeProgress(UUID playerId, QuestData own, QuestData other) {
        if (other.completed) {
            own.completed = true;
            if (other.available && !own.claimed) {
                own.available = true;
            }
        }
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask<?> task = this.tasks.get(i);
            task.mergeProgress(playerId, own, other);
        }
    }

    public void copyProgress(QuestData own, QuestData other) {
        own.completed = other.completed;
        own.available = other.available;
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask<?> task = this.tasks.get(i);
            task.copyProgress(own, other);
        }
    }

    public void completeQuest(PlayerEntity player) {
        for (QuestTask<?> task : this.tasks) {
            task.completeTask(player.func_110124_au());
        }
        QuestTask.completeQuest(this, player.func_110124_au());
    }

    public void reset(UUID playerId) {
        this.reset(this.getQuestData(playerId));
    }

    public void reset(QuestData data) {
        data.available = true;
        this.addTaskData(data);
    }

    public void resetAll() {
        for (Team team : TeamManager.getInstance().getTeams()) {
            QuestData data = team.getQuestData(this.getQuestId());
            if (data == null || data.available) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public void resetOnTime(long time) {
        for (Team team : TeamManager.getInstance().getTeams()) {
            QuestData data = team.getQuestData(this.getQuestId());
            if (data == null || data.available || data.time > time) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public float getProgress(Team team) {
        float data = 0.0f;
        for (QuestTask<?> task : this.tasks) {
            data += task.getCompletedRatio(team);
        }
        return data / (float)this.tasks.size();
    }

    public List<Quest> getOptionLinks() {
        return QuestSetsManager.getInstance().quests.values().stream().filter(quest -> this.optionLinks.contains(quest.getQuestId())).collect(Collectors.toList());
    }

    public List<Quest> getReversedOptionLinks() {
        return QuestSetsManager.getInstance().quests.values().stream().filter(quest -> this.reversedOptionLinks.contains(quest.getQuestId())).collect(Collectors.toList());
    }

    public boolean getUseModifiedParentRequirement() {
        return this.parentRequirementCount != -1;
    }

    public int getParentRequirementCount() {
        return this.parentRequirementCount == -1 ? this.getRequirements().size() : this.parentRequirementCount;
    }

    public int _getParentRequirementCount() {
        return this.parentRequirementCount;
    }

    public void setParentRequirementCount(int parentRequirementCount) {
        this.parentRequirementCount = parentRequirementCount;
    }

    public QuestSet getQuestSet() {
        return this.set;
    }

    public void setQuestSet(QuestSet set) {
        if (this.set != null) {
            this.set.removeQuest(this);
        }
        this.set = set;
        if (this.set != null) {
            this.set.addQuest(this);
        }
    }

    public List<Quest> getReversedRequirement() {
        return QuestSetsManager.getInstance().quests.values().stream().filter(quest -> this.reversedRequirement.contains(quest.getQuestId())).collect(Collectors.toList());
    }

    public static boolean canQuestsBeEdited() {
        if (isEditing && !HQMUtil.isGameSingleplayer()) {
            Quest.setEditMode(false);
        }
        return isEditing;
    }

    public static void setEditMode(boolean enabled) {
        isEditing = enabled;
    }

    private abstract class ParentEvaluator {
        private ParentEvaluator() {
        }

        protected abstract boolean isValid(UUID var1, Quest var2, Map<Quest, Boolean> var3, Map<Quest, Boolean> var4);

        private boolean isValid(UUID uuid, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            int parents = Quest.this.getRequirements().size();
            int requiredAmount = Quest.this.getParentRequirementCount();
            if (requiredAmount > parents) {
                return false;
            }
            int allowedUncompleted = parents - requiredAmount;
            int uncompleted = 0;
            for (Quest quest : Quest.this.getRequirements()) {
                if (this.isValid(uuid, quest, isVisibleCache, isLinkFreeCache) || ++uncompleted <= allowedUncompleted) continue;
                return false;
            }
            return true;
        }
    }
}

