/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.ImmutableList;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemPrecision {
    public static final ItemPrecision PRECISE = new ItemPrecision("precise"){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
        }
    };
    public static final ItemPrecision NBT_FUZZY = new ItemPrecision("nbtFuzzy"){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }
    };
    public static final ItemPrecision FUZZY = new ItemPrecision("fuzzy", true){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }
    };
    public static final ItemPrecision TAG_NBT_FUZZY = new ItemPrecision("tagNbtFuzzy", true){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            if (stack1.func_77973_b() == stack2.func_77973_b()) {
                return true;
            }
            for (Map.Entry entry : HardcoreQuestingCore.getServer().func_244266_aF().func_241836_b().func_241833_a().entrySet()) {
                if (!((ITag)entry.getValue()).func_230235_a_((Object)stack1.func_77973_b()) || !((ITag)entry.getValue()).func_230235_a_((Object)stack2.func_77973_b())) continue;
                return true;
            }
            return false;
        }
    };
    public static final ItemPrecision TAG_FUZZY = new ItemPrecision("tagFuzzy", true){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            if (stack1.func_77973_b() == stack2.func_77973_b()) {
                return true;
            }
            for (Map.Entry entry : HardcoreQuestingCore.getServer().func_244266_aF().func_241836_b().func_241833_a().entrySet()) {
                if (!((ITag)entry.getValue()).func_230235_a_((Object)stack1.func_77973_b()) || !((ITag)entry.getValue()).func_230235_a_((Object)stack2.func_77973_b())) continue;
                return false;
            }
            return false;
        }
    };
    private static final LinkedHashMap<String, ItemPrecision> precisionTypes = new LinkedHashMap();
    protected boolean hasPermutations = false;
    private String tag;

    public ItemPrecision(String tag) {
        this.tag = tag;
    }

    public ItemPrecision(String tag, boolean hasPermutations) {
        this(tag);
        this.hasPermutations = hasPermutations;
    }

    public static boolean registerPrecisionType(String uniqueID, ItemPrecision p) {
        if (uniqueID == null || p == null) {
            return false;
        }
        if (!precisionTypes.containsKey(uniqueID)) {
            precisionTypes.put(uniqueID, p);
            return true;
        }
        return false;
    }

    public static ImmutableList<ItemPrecision> getPrecisionTypes() {
        return ImmutableList.copyOf(precisionTypes.values());
    }

    public static ItemPrecision getPrecisionType(String uniqueID) {
        return precisionTypes.getOrDefault(uniqueID, PRECISE);
    }

    public static String getUniqueID(ItemPrecision p) {
        for (Map.Entry<String, ItemPrecision> entry : precisionTypes.entrySet()) {
            if (entry.getValue() != p) continue;
            return entry.getKey();
        }
        return "PRECISE";
    }

    protected abstract boolean same(ItemStack var1, ItemStack var2);

    public final boolean areItemsSame(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() && stack2.func_190926_b() || !stack1.func_190926_b() && !stack2.func_190926_b() && this.same(stack1, stack2);
    }

    public String toString() {
        return this.tag;
    }

    public String getLocalizationTag() {
        return "hqm.precision." + this.tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)this.getLocalizationTag(), (Object[])new Object[0]);
    }

    public boolean hasPermutations() {
        return this.hasPermutations;
    }

    public ItemStack[] getPermutations(ItemStack stack) {
        return new ItemStack[0];
    }

    static {
        ItemPrecision.registerPrecisionType("PRECISE", PRECISE);
        ItemPrecision.registerPrecisionType("NBT_FUZZY", NBT_FUZZY);
        ItemPrecision.registerPrecisionType("FUZZY", FUZZY);
        ItemPrecision.registerPrecisionType("TAG_NBT_FUZZY", TAG_NBT_FUZZY);
        ItemPrecision.registerPrecisionType("TAG_FUZZY", TAG_FUZZY);
    }
}

